/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.mapper;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.room.InvitationDTO;
import org.apache.openmeetings.db.dto.room.RoomDTO;
import org.apache.openmeetings.db.dto.room.RoomFileDTO;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoomMapper {
    private static final Logger log = LoggerFactory.getLogger(RoomMapper.class);
    private static final FastDateFormat SDF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    @Autowired
    private RoomDao roomDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private FileItemDao fileDao;

    public Room get(RoomDTO dto) {
        Room r = dto.getId() == null ? new Room() : this.roomDao.get(dto.getId());
        r.setId(dto.getId());
        r.setName(dto.getName());
        r.setTag(dto.getTag());
        r.setComment(dto.getComment());
        r.setType(dto.getType());
        r.setCapacity(dto.getCapacity());
        r.setAppointment(dto.isAppointment());
        r.setConfno(dto.getConfno());
        r.setIspublic(dto.isPublic());
        r.setDemoRoom(dto.isDemo());
        r.setClosed(dto.isClosed());
        r.setDemoTime(dto.getDemoTime());
        r.setExternalId(dto.getExternalId());
        String externalType = dto.getExternalType();
        if (!Strings.isEmpty((String)externalType) && r.getGroups().stream().filter(gu -> gu.getGroup().isExternal() && gu.getGroup().getName().equals(externalType)).count() == 0L) {
            r.addGroup(this.groupDao.getExternal(externalType));
        }
        r.setRedirectURL(dto.getRedirectUrl());
        r.setModerated(dto.isModerated());
        r.setWaitModerator(dto.isWaitModerator());
        r.setAllowUserQuestions(dto.isAllowUserQuestions());
        r.setAllowRecording(dto.isAllowRecording());
        r.setWaitRecording(dto.isWaitRecording());
        r.setAudioOnly(dto.isAudioOnly());
        r.setHiddenElements(dto.getHiddenElements());
        r.setFiles(this.get(dto.getId(), dto.getFiles()));
        return r;
    }

    public RoomFile get(RoomFileDTO dto, Long roomId) {
        RoomFile f = new RoomFile();
        f.setId(dto.getId());
        f.setRoomId(roomId);
        f.setFile(this.fileDao.getBase(dto.getFileId()));
        f.setWbIdx(dto.getWbIdx());
        return f;
    }

    public List<RoomFile> get(Long roomId, List<RoomFileDTO> rfl) {
        ArrayList<RoomFile> r = new ArrayList<RoomFile>();
        if (rfl != null) {
            for (RoomFileDTO rf : rfl) {
                RoomFile f = this.get(rf, roomId);
                if (f.getFile() == null) continue;
                r.add(f);
            }
        }
        return r;
    }

    public Invitation get(InvitationDTO dto, Long userId) {
        Invitation i = new Invitation();
        i.setHash(UUID.randomUUID().toString());
        i.setPasswordProtected(dto.isPasswordProtected());
        if (dto.isPasswordProtected()) {
            i.setPassword(CryptProvider.get().hash(dto.getPassword()));
        }
        i.setUsed(false);
        i.setValid(dto.getValid());
        try {
            switch (dto.getValid()) {
                case PERIOD: {
                    i.setValidFrom(new Date(SDF.parse(dto.getValidFrom()).getTime() - 300000L));
                    i.setValidTo(SDF.parse(dto.getValidTo()));
                    break;
                }
            }
        }
        catch (ParseException e) {
            log.error("Unexpected error while creating invitation", (Throwable)e);
            throw new RuntimeException(e);
        }
        i.setDeleted(false);
        i.setInvitedBy(this.userDao.get(userId));
        i.setInvitee(this.userDao.getContact(dto.getEmail(), dto.getFirstname(), dto.getLastname(), userId));
        if (User.Type.CONTACT == i.getInvitee().getType()) {
            i.getInvitee().setLanguageId(dto.getLanguageId());
        }
        i.setRoom(this.roomDao.get(dto.getRoomId()));
        i.setInserted(new Date());
        i.setAppointment(null);
        return i;
    }
}

