/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.record;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.core.converter.IRecordingConverter;
import org.apache.openmeetings.core.converter.InterviewConverter;
import org.apache.openmeetings.core.converter.RecordingConverter;
import org.apache.openmeetings.db.dao.record.RecordingChunkDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dto.record.RecordingContainerData;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.InvitationDialog;
import org.apache.openmeetings.web.common.NameDialog;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.openmeetings.web.common.tree.FileTreePanel;
import org.apache.openmeetings.web.user.record.RecordingInvitationForm;
import org.apache.openmeetings.web.user.record.VideoInfo;
import org.apache.openmeetings.web.user.record.VideoPlayer;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RecordingsPanel
extends UserBasePanel {
    private static final long serialVersionUID = 1L;
    private static final String recordingInviteDialogId = "recordingInviteDialog";
    private final VideoPlayer video = new VideoPlayer("video");
    private final VideoInfo info = new VideoInfo("info");
    private FileTreePanel fileTree;
    private InvitationDialog invite;
    private RecordingInvitationForm rif = new RecordingInvitationForm("form", "recordingInviteDialog");
    @SpringBean
    private RecordingDao recDao;
    @SpringBean
    private InterviewConverter interviewConverter;
    @SpringBean
    private RecordingConverter recordingConverter;
    @SpringBean
    private RecordingChunkDao chunkDao;

    public RecordingsPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        NameDialog addFolder = new NameDialog("addFolder", this.getString("712")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                RecordingsPanel.this.fileTree.createFolder(target, (String)this.getModelObject());
                super.onSubmit(target);
            }
        };
        Component[] componentArray = new Component[1];
        this.fileTree = new FileTreePanel("tree", null, addFolder){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateSizes() {
                RecordingContainerData sizeData = RecordingsPanel.this.recDao.getContainerData(WebSession.getUserId().longValue());
                if (sizeData != null) {
                    this.homeSize.setObject((Object)OmFileHelper.getHumanSize((long)sizeData.getUserHomeSize()));
                    this.publicSize.setObject((Object)OmFileHelper.getHumanSize((long)sizeData.getPublicFileSize()));
                }
            }

            @Override
            protected void update(AjaxRequestTarget target, BaseFileItem f) {
                RecordingsPanel.this.video.update(target, f);
                RecordingsPanel.this.info.update(target, f);
            }

            @Override
            protected List<AbstractLink> newOtherButtons(String markupId) {
                return List.of(new BootstrapAjaxLink<String>(markupId, (IModel)Model.of((Serializable)((Object)"")), Buttons.Type.Outline_Warning, (IModel)new ResourceModel("1600")){
                    private static final long serialVersionUID = 1L;
                    private boolean isInterview;
                    {
                        this.isInterview = false;
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        boolean enabled = false;
                        this.isInterview = false;
                        if (this.getSelected().size() == 1 && BaseFileItem.Type.RECORDING == this.getLastSelected().getType()) {
                            Recording r = (Recording)this.getLastSelected();
                            this.isInterview = r.isInterview();
                            if (r.getRoomId() != null && r.getOwnerId() != null && r.getOwnerId().equals(WebSession.getUserId()) && r.getStatus() != Recording.Status.RECORDING && r.getStatus() != Recording.Status.CONVERTING) {
                                enabled = RecordingsPanel.this.chunkDao.getByRecording(r.getId()).stream().anyMatch(chunk -> OmFileHelper.getRecordingChunk((Long)r.getRoomId(), (String)chunk.getStreamName()).exists());
                            }
                        }
                        this.setEnabled(enabled);
                    }

                    public void onClick(AjaxRequestTarget target) {
                        InterviewConverter converter = this.isInterview ? RecordingsPanel.this.interviewConverter : RecordingsPanel.this.recordingConverter;
                        new Thread(() -> this.lambda$onClick$1((IRecordingConverter)converter)).start();
                    }

                    private /* synthetic */ void lambda$onClick$1(IRecordingConverter converter) {
                        converter.startConversion((Recording)this.getLastSelected());
                    }
                }, new BootstrapAjaxLink<String>(markupId, (IModel)Model.of((Serializable)((Object)"")), Buttons.Type.Outline_Success, (IModel)new ResourceModel("button.label.share")){
                    private static final long serialVersionUID = 1L;

                    protected void onConfigure() {
                        Recording r;
                        super.onConfigure();
                        boolean enabled = false;
                        if (this.getSelected().size() == 1 && BaseFileItem.Type.RECORDING == this.getLastSelected().getType() && !(r = (Recording)this.getLastSelected()).isReadOnly() && r.exists()) {
                            enabled = true;
                        }
                        this.setEnabled(enabled);
                    }

                    public void onClick(AjaxRequestTarget target) {
                        RecordingsPanel.this.rif.setRecordingId(this.getLastSelected().getId());
                        RecordingsPanel.this.invite.updateModel(target);
                        RecordingsPanel.this.invite.show((IPartialPageRequestHandler)target);
                    }
                });
            }
        };
        componentArray[0] = this.fileTree;
        this.add(componentArray);
        this.add(new Component[]{this.video, this.info, addFolder});
        Component[] componentArray2 = new Component[1];
        this.invite = new InvitationDialog(recordingInviteDialogId, this.rif);
        componentArray2[0] = this.invite;
        this.add(componentArray2);
        this.rif.setDialog(this.invite);
        super.onInitialize();
    }
}

