/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.openmeetings.db.dao.room.InvitationDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.openmeetings.web.user.profile.InvitationDetails;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class InvitationsPanel
extends UserBasePanel {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer list = new WebMarkupContainer("list");
    private Long selected = null;
    private final InvitationDetails form;

    public InvitationsPanel(String id) {
        super(id);
        this.setOutputMarkupId(true);
        SearchableDataView<Invitation> dataView = new SearchableDataView<Invitation>("invitations", (SearchableDataProvider)new InvitationProvider()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<Invitation> item) {
                Invitation i = (Invitation)item.getModelObject();
                item.add(new Component[]{new Label("id")});
                item.add(new Component[]{new Label("valid")});
                item.add(new Component[]{new Label("invitee", (Serializable)((Object)FormatHelper.formatUser((User)i.getInvitee())))});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    InvitationsPanel.this.selected = i.getId().equals(InvitationsPanel.this.selected) ? null : i.getId();
                    InvitationsPanel.this.form.setModelObject(i);
                    target.add(new Component[]{InvitationsPanel.this.form, InvitationsPanel.this.list});
                })});
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)InvitationsPanel.this.getRowClass(i))});
            }
        };
        this.add(new Component[]{this.list.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{InvitationsPanel.this.list});
            }
        };
        DataViewContainer<Invitation> container = new DataViewContainer<Invitation>(this.list, dataView, navigator);
        container.addLink(new OmOrderByBorder<Invitation>("orderById", "id", container)).addLink(new OmOrderByBorder<Invitation>("orderByValid", "valid", container)).addLink(new OmOrderByBorder<Invitation>("orderByInvitee", "invitee", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator});
        this.form = new InvitationDetails("form", this.list, new Invitation());
        this.add(new Component[]{this.form});
    }

    protected StringBuilder getRowClass(Invitation i) {
        Long id = i.getId();
        StringBuilder sb = new StringBuilder("clickable");
        if (id != null && id.equals(this.selected)) {
            sb.append(" selected");
        }
        return sb;
    }

    private static class InvitationProvider
    extends SearchableDataProvider<Invitation> {
        private static final long serialVersionUID = 1L;
        private final Set<User.Right> rights = WebSession.getRights();
        private final Long userId = WebSession.getUserId();

        public InvitationProvider() {
            super(InvitationDao.class);
        }

        protected InvitationDao getDao() {
            return (InvitationDao)super.getDao();
        }

        @Override
        public Iterator<? extends Invitation> iterator(long first, long count) {
            if (this.rights.contains(User.Right.ADMIN)) {
                return this.getDao().get(this.search, first, count, this.getSortStr()).iterator();
            }
            if (this.rights.contains(User.Right.GROUP_ADMIN)) {
                return this.getDao().getGroup(this.search, first, count, this.userId, this.getSortStr()).iterator();
            }
            return this.getDao().getUser(this.search, first, count, this.userId, this.getSortStr()).iterator();
        }

        @Override
        public long size() {
            if (this.rights.contains(User.Right.ADMIN)) {
                return this.getDao().count(this.search);
            }
            if (this.rights.contains(User.Right.GROUP_ADMIN)) {
                return this.getDao().countGroup(this.search, this.userId);
            }
            return this.getDao().countUser(this.search, this.userId);
        }
    }
}

