/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.sidebar;

import java.io.Serializable;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.web.common.upload.UploadForm;
import org.apache.openmeetings.web.room.sidebar.RoomFilePanel;
import org.apache.openmeetings.web.room.sidebar.RoomFileUploadResourceReference;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class RoomUploadForm
extends UploadForm {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer lastSelectedId = new WebMarkupContainer("lastSelectedId");
    private final WebMarkupContainer lastSelectedRoom = new WebMarkupContainer("lastSelectedRoom");
    private final WebMarkupContainer lastSelectedOwner = new WebMarkupContainer("lastSelectedOwner");
    private final WebMarkupContainer lastSelectedGroup = new WebMarkupContainer("lastSelectedGroup");
    private final RoomFilePanel roomFiles;

    public RoomUploadForm(String id, RoomFilePanel roomFiles) {
        super(id, "" + RequestCycle.get().urlFor((ResourceReference)new RoomFileUploadResourceReference(), new PageParameters()));
        this.roomFiles = roomFiles;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.form.add(new Component[]{this.lastSelectedId.setMarkupId("room-upload-last-selected-id").setOutputMarkupId(true)});
        this.form.add(new Component[]{this.lastSelectedRoom.setMarkupId("room-upload-last-selected-room").setOutputMarkupId(true)});
        this.form.add(new Component[]{this.lastSelectedOwner.setMarkupId("room-upload-last-selected-owner").setOutputMarkupId(true)});
        this.form.add(new Component[]{this.lastSelectedGroup.setMarkupId("room-upload-last-selected-group").setOutputMarkupId(true)});
    }

    @Override
    public void show(IPartialPageRequestHandler handler) {
        BaseFileItem last = this.roomFiles.getLastSelected();
        if (last.getId() == null) {
            this.lastSelectedRoom.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getRoomId())});
            this.lastSelectedOwner.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getOwnerId())});
            this.lastSelectedGroup.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getGroupId())});
        } else {
            this.lastSelectedId.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getId())});
        }
        super.show(handler);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(RoomUploadForm.class, "room-upload.js"))));
    }

    @Override
    protected String uploadLocation() {
        return ".room-file-upload-dlg .modal-content .modal-footer";
    }

    @Override
    protected String extraBindFunc() {
        return "roomUploadExtaBindFunc";
    }

    @Override
    protected String onCompleteFunc() {
        return "roomUploadOnComplete";
    }
}

