/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.activities;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.pages.BasePage;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.activities.Activity;
import org.apache.openmeetings.web.util.CallbackFunctionHelper;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitiesPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ActivitiesPanel.class);
    private static final String PARAM_ID = "id";
    private static final String ACTION = "action";
    private static final String PARAM_ROOM_ID = "roomid";
    private static final String ACTIVITY_FMT = "%s %s [%s]";
    private static final String ACTIVITY_FMT_RTL = "%3$s %2$s [%1$s]";
    private static final FastDateFormat df = FastDateFormat.getInstance((String)"HH:mm:ss");
    private final Map<String, Activity> activities = new LinkedHashMap<String, Activity>();
    private final RoomPanel room;
    private final AbstractDefaultAjaxBehavior actionBehavior = new AbstractDefaultAjaxBehavior(){
        private static final long serialVersionUID = 1L;

        private TextRoomMessage getRemoveMsg(String id) {
            return new TextRoomMessage(ActivitiesPanel.this.room.getRoom().getId(), ActivitiesPanel.this.room.getClient(), RoomMessage.Type.ACTIVITY_REMOVE, id);
        }

        protected void respond(AjaxRequestTarget target) {
            if (!ActivitiesPanel.this.isVisible()) {
                return;
            }
            try {
                String id = ActivitiesPanel.this.getRequest().getRequestParameters().getParameterValue(ActivitiesPanel.PARAM_ID).toString();
                long roomId = ActivitiesPanel.this.getRequest().getRequestParameters().getParameterValue(ActivitiesPanel.PARAM_ROOM_ID).toLong();
                Action act = Action.valueOf(ActivitiesPanel.this.getRequest().getRequestParameters().getParameterValue(ActivitiesPanel.ACTION).toString());
                Activity a = ActivitiesPanel.this.activities.get(id);
                if (a == null || !ActivitiesPanel.this.room.getRoom().getId().equals(roomId)) {
                    log.error("It seems like we are being hacked!!!!");
                    return;
                }
                block1 : switch (act) {
                    case close: {
                        ActivitiesPanel.this.remove((IPartialPageRequestHandler)target, id);
                        break;
                    }
                    case decline: {
                        if (!ActivitiesPanel.this.room.getClient().hasRight(Room.Right.MODERATOR)) break;
                        WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                        break;
                    }
                    case accept: {
                        Client client = ActivitiesPanel.this.cm.get(a.getUid());
                        if (!ActivitiesPanel.this.room.getClient().hasRight(Room.Right.MODERATOR) || client == null || client.getRoom() == null || roomId != client.getRoom().getId()) break;
                        switch (a.getType()) {
                            case reqRightModerator: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.MODERATOR);
                                break block1;
                            }
                            case reqRightAv: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.AUDIO, Room.Right.VIDEO);
                                break block1;
                            }
                            case reqRightPresenter: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.PRESENTER);
                                break block1;
                            }
                            case reqRightWb: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.WHITEBOARD);
                                break block1;
                            }
                            case reqRightShare: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.SHARE);
                                break block1;
                            }
                            case reqRightRemote: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.REMOTE_CONTROL);
                                break block1;
                            }
                            case reqRightA: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.AUDIO);
                                break block1;
                            }
                            case reqRightMuteOthers: {
                                WebSocketHelper.sendRoom((RoomMessage)this.getRemoveMsg(id));
                                ActivitiesPanel.this.room.allowRight(client, Room.Right.MUTE_OTHERS);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("Unexpected exception while processing activity action", (Throwable)e);
            }
        }

        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CallbackFunctionHelper.getNamedFunction("activityAction", this, CallbackParameter.explicit((String)ActivitiesPanel.PARAM_ROOM_ID), CallbackParameter.explicit((String)ActivitiesPanel.ACTION), CallbackParameter.explicit((String)ActivitiesPanel.PARAM_ID))));
        }
    };
    @SpringBean
    private ClientManager cm;

    public ActivitiesPanel(String id, RoomPanel room) {
        super(id);
        this.room = room;
        this.setVisible(!room.getRoom().isHidden(Room.RoomElement.ACTIVITIES));
        this.setOutputMarkupPlaceholderTag(true);
        this.setMarkupId(id);
        this.add(new Behavior[]{this.actionBehavior});
    }

    private boolean shouldSkip(boolean self, Activity a) {
        return !self && a.getType().isAction() && !this.room.getClient().hasRight(Room.Right.MODERATOR);
    }

    public void add(Activity a, IPartialPageRequestHandler handler) {
        if (!this.isVisible()) {
            return;
        }
        boolean self = WebSession.getUserId().equals(a.getSender());
        if (this.shouldSkip(self, a)) {
            return;
        }
        if (a.getType().isAction()) {
            this.remove(handler, (String[])this.activities.entrySet().parallelStream().filter(e -> a.getSender().equals(((Activity)e.getValue()).getSender()) && a.getType() == ((Activity)e.getValue()).getType()).map(e -> ((Activity)e.getValue()).getId()).toArray(String[]::new));
        }
        this.activities.put(a.getId(), a);
        String text = "";
        String name = self ? this.getString("1362") : a.getName();
        String fmt = ((BasePage)this.getPage()).isRtl() ? ACTIVITY_FMT_RTL : ACTIVITY_FMT;
        switch (a.getType()) {
            case roomEnter: {
                text = String.format(fmt, name, this.getString("activities.msg.enter"), df.format(a.getCreated()));
                break;
            }
            case roomExit: {
                text = String.format(fmt, name, this.getString("activities.msg.exit"), df.format(a.getCreated()));
                break;
            }
            case reqRightModerator: {
                text = String.format(fmt, name, this.getString("activities.request.right.moderator"), df.format(a.getCreated()));
                break;
            }
            case reqRightPresenter: {
                text = String.format(fmt, name, this.getString("activities.request.right.presenter"), df.format(a.getCreated()));
                break;
            }
            case reqRightWb: {
                text = String.format(fmt, name, this.getString("activities.request.right.wb"), df.format(a.getCreated()));
                break;
            }
            case reqRightShare: {
                text = String.format(fmt, name, this.getString("activities.request.right.share"), df.format(a.getCreated()));
                break;
            }
            case reqRightRemote: {
                text = String.format(fmt, name, this.getString("activities.request.right.remote"), df.format(a.getCreated()));
                break;
            }
            case reqRightA: {
                text = String.format(fmt, name, this.getString("activities.request.right.audio"), df.format(a.getCreated()));
                break;
            }
            case reqRightAv: {
                text = String.format(fmt, name, this.getString("activities.request.right.video"), df.format(a.getCreated()));
                break;
            }
            case reqRightMuteOthers: {
                text = String.format(fmt, name, this.getString("activities.request.right.muteothers"), df.format(a.getCreated()));
                break;
            }
            case haveQuestion: {
                text = String.format(fmt, name, this.getString("activities.ask.question"), df.format(a.getCreated()));
            }
        }
        JSONObject aobj = new JSONObject().put(PARAM_ID, (Object)a.getId()).put("uid", (Object)a.getUid()).put("cssClass", (Object)ActivitiesPanel.getClass(a)).put("text", (Object)text).put(ACTION, a.getType().isAction()).put("find", false);
        switch (a.getType()) {
            case reqRightModerator: 
            case reqRightAv: 
            case reqRightPresenter: 
            case reqRightWb: 
            case reqRightShare: 
            case reqRightRemote: 
            case reqRightA: 
            case reqRightMuteOthers: {
                aobj.put("accept", this.room.getClient().hasRight(Room.Right.MODERATOR));
                aobj.put("decline", this.room.getClient().hasRight(Room.Right.MODERATOR));
                break;
            }
            case haveQuestion: {
                aobj.put("find", !self);
            }
            case roomEnter: 
            case roomExit: {
                aobj.put("accept", false);
                aobj.put("decline", false);
            }
        }
        handler.appendJavaScript((CharSequence)new StringBuilder("Activities.add(").append(aobj.toString()).append(");"));
    }

    public void remove(IPartialPageRequestHandler handler, String ... ids) {
        if (ids.length < 1) {
            return;
        }
        JSONArray arr = new JSONArray();
        for (String id : ids) {
            arr.put((Object)id);
            this.activities.remove(id);
        }
        handler.appendJavaScript((CharSequence)String.format("Activities.remove(%s);", arr));
    }

    private static CharSequence getClass(Activity a) {
        StringBuilder cls = new StringBuilder();
        switch (a.getType()) {
            case reqRightModerator: 
            case reqRightAv: 
            case reqRightPresenter: 
            case reqRightWb: 
            case reqRightShare: 
            case reqRightRemote: 
            case reqRightA: 
            case reqRightMuteOthers: 
            case haveQuestion: {
                cls.append("bg-warning");
                break;
            }
            case roomEnter: 
            case roomExit: {
                cls.append("bg-white auto-clean");
            }
        }
        return cls;
    }

    private static enum Action {
        accept,
        decline,
        close;

    }
}

