/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.upload;

import com.github.openjson.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.fileupload.FileItem;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UploadResourceReference.class);
    private static final String PARAM_FILE_NAME = "omws-upload-file";
    private static final String PARAM_SID_NAME = "omws-upload-sid";
    @SpringBean
    private ClientManager cm;

    protected UploadResourceReference(Class<?> scope, String name) {
        super(scope, name);
        Injector.get().inject((Object)this);
    }

    public IResource getResource() {
        return new AbstractResource(){
            private static final long serialVersionUID = 1L;

            protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
                AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
                ServletWebRequest webRequest = (ServletWebRequest)attributes.getRequest();
                try {
                    MultipartServletWebRequest multiPartRequest = webRequest.newMultipartWebRequest(Bytes.bytes((long)OpenmeetingsVariables.getMaxUploadSize()), "ignored");
                    multiPartRequest.parseFileParts();
                    String sid = multiPartRequest.getPostParameters().getParameterValue(UploadResourceReference.PARAM_SID_NAME).toString();
                    Client c = UploadResourceReference.this.cm.getBySid(sid);
                    long langId = UploadResourceReference.getLangId(c);
                    if (UploadResourceReference.this.isUploadAllowed(c)) {
                        Map files = multiPartRequest.getFiles();
                        List fileItems = (List)files.get(UploadResourceReference.PARAM_FILE_NAME);
                        String uuid = UUID.randomUUID().toString();
                        UploadResourceReference.this.processFiles(c, fileItems, uuid, multiPartRequest);
                        UploadResourceReference.prepareResponse(response, Status.SUCCESS, uuid, Application.getString("54", langId));
                    } else {
                        UploadResourceReference.prepareResponse(response, Status.ERROR, null, Application.getString("access.denied.header", langId));
                    }
                }
                catch (Exception e) {
                    log.error("An error occurred while uploading a file", (Throwable)e);
                    UploadResourceReference.prepareResponse(response, Status.ERROR, null, e.getMessage());
                }
                return response;
            }
        };
    }

    protected abstract boolean isUploadAllowed(Client var1);

    protected abstract void processFiles(Client var1, List<FileItem> var2, String var3, MultipartServletWebRequest var4);

    protected static long getLangId(Client c) {
        return c == null || c.getUser() == null ? 1L : c.getUser().getLanguageId();
    }

    private static void prepareResponse(AbstractResource.ResourceResponse response, final Status status, final String uuid, final String msg) {
        response.setContentType("application/json");
        response.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                attributes.getResponse().write((CharSequence)new JSONObject().put("status", (Object)status.name()).put("message", (Object)msg).put("uuid", (Object)uuid).toString());
            }
        });
    }

    protected JSONObject getBaseMessage(String uuid) {
        return new JSONObject().put("uuid", (Object)uuid).put("type", (Object)"omws-upload");
    }

    protected void sendError(Client c, String uuid, String msg) {
        WebSocketHelper.sendClient((IWsClient)c, (JSONObject)this.getBaseMessage(uuid).put("status", (Object)Status.ERROR.name()).put("message", (Object)msg));
    }

    protected void sendProgress(Client c, String uuid, AtomicInteger progress, int cur) {
        if (cur > progress.get()) {
            progress.set(cur);
            WebSocketHelper.sendClient((IWsClient)c, (JSONObject)this.getBaseMessage(uuid).put("status", (Object)Status.PROGRESS.name()).put("progress", cur));
        }
    }

    private static enum Status {
        SUCCESS,
        PROGRESS,
        ERROR;

    }
}

