/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class OmTreeProvider
implements ITreeProvider<BaseFileItem> {
    private static final long serialVersionUID = 1L;
    private static final List<BaseFileItem.Type> VIDEO_TYPES = List.of(BaseFileItem.Type.FOLDER, BaseFileItem.Type.VIDEO);
    public static final String RECORDINGS_MY = "recordings-my";
    public static final String RECORDINGS_PUBLIC = "recordings-public";
    public static final String RECORDINGS_GROUP = "recordings-group-%s";
    public static final String FILES_MY = "files-my";
    public static final String FILES_ROOM = "files-room";
    public static final String FILES_GROUP = "files-group-%s";
    private final Long roomId;
    private final List<BaseFileItem> roots = new ArrayList<BaseFileItem>();
    private final String lblPublic;
    private final String lblGroupFile;
    private final String lblGroupRec;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private RecordingDao recDao;
    @SpringBean
    private FileItemDao fileDao;

    public OmTreeProvider(Long roomId) {
        Injector.get().inject((Object)this);
        this.roomId = roomId;
        this.lblPublic = Application.getString("861");
        this.lblGroupFile = Application.getString("files.root.group");
        this.lblGroupRec = Application.getString("recordings.root.group");
        this.refreshRoots(true);
    }

    public void refreshRoots(boolean all) {
        BaseFileItem r;
        ArrayList<BaseFileItem> fRoot = new ArrayList<BaseFileItem>();
        ArrayList<BaseFileItem> rRoot = new ArrayList<BaseFileItem>();
        if (all && this.roomId != null) {
            r = OmTreeProvider.createRoot(Application.getString("706"), FILES_MY, false);
            r.setOwnerId(WebSession.getUserId());
            fRoot.add(r);
        }
        if (this.roomId != null) {
            r = OmTreeProvider.createRoot(Application.getString("707"), FILES_ROOM, false);
            r.setRoomId(this.roomId);
            fRoot.add(r);
        }
        if (all && OpenmeetingsVariables.isRecordingsEnabled()) {
            BaseFileItem my = OmTreeProvider.createRoot(Application.getString("860"), RECORDINGS_MY, true);
            my.setOwnerId(WebSession.getUserId());
            rRoot.add(my);
            BaseFileItem pub = OmTreeProvider.createRoot(this.lblPublic, RECORDINGS_PUBLIC, true);
            rRoot.add(pub);
        }
        for (GroupUser gu : this.userDao.get(WebSession.getUserId()).getGroupUsers()) {
            BaseFileItem r2;
            boolean readOnly;
            Group g = gu.getGroup();
            boolean bl = readOnly = g.isRestricted() && !AuthLevelUtil.hasAdminLevel(WebSession.getRights()) && !gu.isModerator();
            if (all && OpenmeetingsVariables.isRecordingsEnabled()) {
                r2 = OmTreeProvider.createRoot(String.format("%s (%s)", this.lblGroupRec, g.getName()), String.format(RECORDINGS_GROUP, g.getId()), true);
                r2.setReadOnly(readOnly);
                r2.setGroupId(g.getId());
                rRoot.add(r2);
            }
            r2 = OmTreeProvider.createRoot(String.format("%s (%s)", this.lblGroupFile, g.getName()), String.format(FILES_GROUP, g.getId()), false);
            r2.setGroupId(g.getId());
            r2.setReadOnly(this.roomId == null || readOnly);
            fRoot.add(r2);
        }
        this.roots.clear();
        if (this.roomId == null) {
            this.roots.addAll(rRoot);
            this.roots.addAll(fRoot);
        } else {
            this.roots.addAll(fRoot);
            this.roots.addAll(rRoot);
        }
    }

    static BaseFileItem createRoot(String name, String hash, boolean rec) {
        Recording f = rec ? new Recording() : new FileItem();
        f.setType(BaseFileItem.Type.FOLDER);
        f.setName(name);
        f.setHash(hash);
        return f;
    }

    public BaseFileItem getRoot() {
        return this.roots.get(0);
    }

    public Iterator<BaseFileItem> getRoots() {
        return this.roots.iterator();
    }

    public List<BaseFileItem> getByParent(BaseFileItem node, Long id) {
        ArrayList<BaseFileItem> list = new ArrayList<BaseFileItem>();
        if (node instanceof Recording) {
            Recording rec = (Recording)node;
            List recList = id == null ? (node.getOwnerId() == null ? this.recDao.getRootByPublic(rec.getGroupId()) : this.recDao.getRootByOwner(node.getOwnerId())) : this.recDao.getByParent(id);
            list.addAll(recList);
        } else {
            List fileList = id == null ? (node.getRoomId() != null ? this.fileDao.getByRoom(node.getRoomId()) : (node.getGroupId() != null ? this.fileDao.getByGroup(node.getGroupId(), this.roomId == null ? VIDEO_TYPES : null) : this.fileDao.getByOwner(node.getOwnerId()))) : this.fileDao.getByParent(id, this.roomId == null ? VIDEO_TYPES : null);
            list.addAll(fileList);
        }
        if (node.isReadOnly()) {
            for (BaseFileItem f : list) {
                f.setReadOnly(true);
            }
        }
        return list;
    }

    public Iterator<BaseFileItem> getChildren(BaseFileItem node) {
        return this.getByParent(node, node.getId()).iterator();
    }

    public boolean hasChildren(BaseFileItem node) {
        return node.getId() == null || BaseFileItem.Type.FOLDER == node.getType();
    }

    public IModel<BaseFileItem> model(BaseFileItem object) {
        return Model.of((Serializable)object);
    }

    public void detach() {
    }
}

