/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.File;
import java.util.Optional;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.web.common.ImagePanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.util.upload.BootstrapFileUploadBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadProgressBar;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadableImagePanel
extends ImagePanel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UploadableImagePanel.class);
    private final FileUploadField fileUploadField = new FileUploadField("image", (IModel)new ListModel());
    private final Form<Void> form = new Form("form");
    private final boolean delayed;

    protected UploadableImagePanel(String id, boolean delayed) {
        super(id);
        this.delayed = delayed;
    }

    protected abstract void processImage(StoredFile var1, File var2) throws Exception;

    protected abstract void deleteImage() throws Exception;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.form.setMultiPart(true);
        this.form.setMaxSize(Bytes.bytes((long)OpenmeetingsVariables.getMaxUploadSize()));
        this.form.add(new Component[]{this.fileUploadField});
        this.form.add(new Component[]{new UploadProgressBar("progress", this.form, this.fileUploadField)});
        this.form.addOrReplace(new Component[]{this.getImage()});
        if (this.delayed) {
            this.add(new Component[]{new WebMarkupContainer("remove")});
        } else {
            BootstrapAjaxLink<String> remove = new BootstrapAjaxLink<String>("remove", Buttons.Type.Outline_Secondary){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    try {
                        UploadableImagePanel.this.deleteImage();
                    }
                    catch (Exception e) {
                        log.error("Error", (Throwable)e);
                    }
                    UploadableImagePanel.this.update(Optional.of(target));
                }
            };
            this.add(new Component[]{remove.setIconType((IconType)FontAwesome5IconType.times_s).add(new Behavior[]{ConfirmationHelper.newOkCancelConfirm((Component)this, this.getString("833"))})});
            this.fileUploadField.add(new Behavior[]{new AjaxFormSubmitBehavior(this.form, "change"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    UploadableImagePanel.this.process(Optional.of(target));
                }
            }});
        }
        this.add(new Component[]{this.form.setOutputMarkupId(true)});
        this.add(new Behavior[]{BootstrapFileUploadBehavior.INSTANCE});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.delayed) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('#" + this.form.getOutputMarkupId() + " .remove').click(function() {$(this).parent().find('.fileinput').fileinput('clear');})")));
        }
    }

    @Override
    public void update() {
        this.profile.addOrReplace(new Component[]{new WebMarkupContainer("img").setVisible(false)});
        this.form.addOrReplace(new Component[]{this.getImage()});
    }

    private void update(Optional<AjaxRequestTarget> target) {
        this.update();
        target.ifPresent(t -> t.add(new Component[]{this.profile, this.form}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Optional<AjaxRequestTarget> target) {
        FileUpload fu = this.fileUploadField.getFileUpload();
        if (fu != null) {
            File temp = null;
            try {
                temp = fu.writeToTempFile();
                StoredFile sf = new StoredFile(fu.getClientFileName(), temp);
                if (sf.isImage()) {
                    this.processImage(sf, temp);
                }
            }
            catch (Exception e) {
                log.error("Error", (Throwable)e);
            }
            finally {
                if (temp != null && temp.exists()) {
                    log.debug("Temp file was deleted ? {}", (Object)temp.delete());
                }
                fu.closeStreams();
                fu.delete();
            }
        }
        this.update(target);
    }
}

