/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import com.github.openjson.JSONObject;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openmeetings.core.remote.KurentoHandler;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.ws.api.WebSocketBehavior;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.message.AbortedMessage;
import org.apache.wicket.protocol.ws.api.message.AbstractClientMessage;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.ErrorMessage;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OmWebSocketPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(OmWebSocketPanel.class);
    public static final String CONNECTED_MSG = "socketConnected";
    private final AtomicBoolean connected = new AtomicBoolean();
    @SpringBean
    private KurentoHandler kHandler;
    private boolean pingable = false;

    protected OmWebSocketPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{this.newWsBehavior(), new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                if (!OmWebSocketPanel.this.pingable) {
                    log.debug("pingTimer is attached");
                    OmWebSocketPanel.this.pingable = true;
                    super.renderHead(component, response);
                    response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"OmUtil.ping();"));
                }
            }
        }});
    }

    private WebSocketBehavior newWsBehavior() {
        return new WebSocketBehavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)String.format("Wicket.Event.subscribe(Wicket.Event.Topic.WebSocket.Opened, function() {Wicket.WebSocket.send('%s');});", OmWebSocketPanel.CONNECTED_MSG), (String)"ws-connected-script"));
            }

            protected void onConnect(ConnectedMessage message) {
                super.onConnect(message);
                OmWebSocketPanel.this.onConnect(message);
            }

            protected void onMessage(WebSocketRequestHandler handler, TextMessage msg) {
                if (OmWebSocketPanel.CONNECTED_MSG.equals(msg.getText())) {
                    if (OmWebSocketPanel.this.connected.compareAndSet(false, true)) {
                        OmWebSocketPanel.this.onConnect(handler);
                    }
                } else {
                    try {
                        JSONObject m = new JSONObject(msg.getText());
                        switch (m.optString("type", "")) {
                            case "kurento": {
                                OmWebSocketPanel.this.kHandler.onMessage(OmWebSocketPanel.this.getWsClient(), m);
                                break;
                            }
                            case "mic": {
                                this.micMessage(m);
                                break;
                            }
                            case "ping": {
                                log.trace("Sending WebSocket PING");
                                handler.appendJavaScript((CharSequence)"OmUtil.ping();");
                                WebSocketHelper.sendClient((IWsClient)OmWebSocketPanel.this.getWsClient(), (byte[])new byte[]{WebSession.getUserId() == null ? (byte)0 : WebSession.getUserId().byteValue()});
                                break;
                            }
                            default: {
                                OmWebSocketPanel.this.onMessage(handler, m);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Error while processing incoming message", (Throwable)e);
                    }
                }
            }

            protected void onAbort(AbortedMessage msg) {
                OmWebSocketPanel.this.closeHandler((AbstractClientMessage)msg);
            }

            protected void onClose(ClosedMessage msg) {
                OmWebSocketPanel.this.closeHandler((AbstractClientMessage)msg);
            }

            protected void onError(WebSocketRequestHandler handler, ErrorMessage msg) {
                OmWebSocketPanel.this.closeHandler((AbstractClientMessage)msg);
            }

            private void micMessage(JSONObject m) {
                IWsClient curClient = OmWebSocketPanel.this.getWsClient();
                if (!(curClient instanceof Client)) {
                    return;
                }
                Client c = (Client)curClient;
                if (c.getRoomId() == null) {
                    return;
                }
                WebSocketHelper.sendRoomOthers((Long)c.getRoomId(), (String)c.getUid(), (JSONObject)m.put("uid", (Object)c.getUid()));
            }
        };
    }

    protected abstract IWsClient getWsClient();

    protected void onConnect(ConnectedMessage message) {
    }

    protected void onConnect(WebSocketRequestHandler handler) {
    }

    protected void closeHandler(AbstractClientMessage msg) {
        log.debug("WebSocketBehavior::closeHandler {}", (Object)msg);
        this.kHandler.remove(this.getWsClient());
    }

    protected void onMessage(WebSocketRequestHandler handler, JSONObject m) throws IOException {
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return null;
    }
}

