/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class FormActionsPanel<T>
extends Panel {
    private static final long serialVersionUID = 1L;
    private final Form<T> form;
    protected final NotificationPanel feedback = new NotificationPanel("feedback");
    private AjaxButton saveBtn;
    private AjaxLink<Void> purgeBtn;

    protected FormActionsPanel(String id, Form<T> form) {
        super(id);
        this.form = form;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        this.add(new Component[]{this.feedback.setOutputMarkupId(true)});
        Component[] componentArray = new Component[1];
        this.saveBtn = new AjaxButton("btn-save", this.form){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                target.add(new Component[]{FormActionsPanel.this.feedback});
                FormActionsPanel.this.onSaveSubmit(target, FormActionsPanel.this.form);
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{FormActionsPanel.this.feedback});
                FormActionsPanel.this.onError(target, FormActionsPanel.this.form);
            }
        };
        componentArray[0] = this.saveBtn;
        this.add(componentArray);
        this.add(new Component[]{new AjaxLink<Void>("btn-refresh"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{FormActionsPanel.this.feedback});
                FormActionsPanel.this.setNewRecordVisible(false);
                FormActionsPanel.this.onRefreshSubmit(target, FormActionsPanel.this.form);
            }
        }});
        this.purgeBtn = new AjaxLink<Void>("btn-purge"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                target.add(new Component[]{FormActionsPanel.this.feedback});
                FormActionsPanel.this.setNewRecordVisible(false);
                FormActionsPanel.this.onPurgeSubmit(target, FormActionsPanel.this.form);
            }
        };
        this.purgeBtn.add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("admin.purge.desc"))});
        this.add(new Component[]{this.purgeBtn.setOutputMarkupPlaceholderTag(true).setVisible(false)});
        super.onInitialize();
    }

    public void setSaveVisible(boolean visible) {
        this.saveBtn.setVisible(visible);
    }

    public void setNewRecordVisible(boolean visible) {
    }

    public void setPurgeVisible(boolean visible) {
        this.purgeBtn.setVisible(visible);
    }

    protected abstract void onSaveSubmit(AjaxRequestTarget var1, Form<?> var2);

    protected abstract void onRefreshSubmit(AjaxRequestTarget var1, Form<?> var2);

    protected abstract void onPurgeSubmit(AjaxRequestTarget var1, Form<?> var2);

    protected void onError(AjaxRequestTarget target, Form<?> form) {
    }
}

