/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Locale;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.label.OmLanguage;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.captcha.CaptchaImageResource;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class Captcha
extends Panel {
    private static final long serialVersionUID = 1L;
    private OmLanguage lang;
    private String randomText;
    private final CaptchaImageResource captchaImageResource = new CaptchaImageResource(){
        private static final long serialVersionUID = 1L;
        private SecureRandom rnd = new SecureRandom();

        protected byte[] render() {
            Captcha.this.randomText = this.randomString(6, 8);
            this.getChallengeIdModel().setObject((Object)Captcha.this.randomText);
            return super.render();
        }

        private int randomInt(int min, int max) {
            return this.rnd.nextInt(max - min) + min;
        }

        private String randomString(int min, int max) {
            int num = this.randomInt(min, max);
            char[] b = new char[num];
            for (int i = 0; i < num; ++i) {
                b[i] = (char)this.randomInt(Captcha.this.lang.getRangeStart(), Captcha.this.lang.getRangeEnd());
            }
            return new String(b);
        }
    };
    private Image captcha = new Image("captcha", (IResource)this.captchaImageResource, new IResource[0]);
    private final RequiredTextField<String> captchaText = new RequiredTextField("captchaText", (IModel)Model.of((Serializable)((Object)"")));

    public Captcha(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.lang = LabelDao.getOmLanguage((Locale)WebSession.get().getLocale(), (Long)OpenmeetingsVariables.getDefaultLang());
        this.add(new Component[]{this.captcha.setOutputMarkupId(true)});
        this.add(new Component[]{this.captchaText.setLabel((IModel)new ResourceModel("captcha.text")).add((IValidator)new IValidator<String>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<String> validatable) {
                if (!Captcha.this.randomText.equals(validatable.getValue())) {
                    validatable.error((IValidationError)new ValidationError(Captcha.this.getString("bad.captcha.text")));
                }
            }
        }).setOutputMarkupId(true).add(new Behavior[]{AttributeModifier.append((String)"placeholder", (Serializable)((Object)this.lang.getTip()))})});
        this.add(new Component[]{new BootstrapAjaxLink<String>("refresh", (IModel)Model.of((Serializable)((Object)"")), Buttons.Type.Outline_Info, (IModel)new ResourceModel("lbl.refresh")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                Captcha.this.captchaImageResource.invalidate();
                target.add(new Component[]{Captcha.this.captcha});
            }

            protected Icon newIcon(String markupId) {
                return new Icon(markupId, (IconType)FontAwesome5IconType.sync_s);
            }
        }});
    }

    public Image refresh(IPartialPageRequestHandler handler) {
        this.captchaImageResource.invalidate();
        this.captchaText.setModelObject((Object)"");
        if (handler != null) {
            handler.add(new Component[]{this.captchaText, this.captcha});
        }
        return this.captcha;
    }
}

