/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.configurations;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.configurations.ConfigForm;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.danekja.java.util.function.serializable.SerializableConsumer;

@AuthorizeInstantiation(value={"ADMIN", "ADMIN_CONFIG"})
public class ConfigsPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    private ConfigForm form;
    private final WebMarkupContainer listContainer = new WebMarkupContainer("listContainer");
    @SpringBean
    private ConfigurationDao cfgDao;

    public ConfigsPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        SearchableDataView<Configuration> dataView = new SearchableDataView<Configuration>("configList", new SearchableDataProvider(ConfigurationDao.class)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<Configuration> item) {
                Configuration c = (Configuration)item.getModelObject();
                item.add(new Component[]{new Label("id")});
                item.add(new Component[]{new Label("key")});
                item.add(new Component[]{new Label("value")});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    ConfigsPanel.this.form.setNewRecordVisible(false);
                    ConfigsPanel.this.form.setModelObject(ConfigsPanel.this.cfgDao.get(c.getId()));
                    target.add(new Component[]{ConfigsPanel.this.form, ConfigsPanel.this.listContainer});
                })});
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)ConfigsPanel.this.getRowClass(c.getId(), ((Configuration)ConfigsPanel.this.form.getModelObject()).getId()))});
            }
        };
        this.add(new Component[]{this.listContainer.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{ConfigsPanel.this.listContainer});
            }
        };
        DataViewContainer<Configuration> container = new DataViewContainer<Configuration>(this.listContainer, dataView, navigator);
        container.addLink(new OmOrderByBorder<Configuration>("orderById", "id", container)).addLink(new OmOrderByBorder<Configuration>("orderByKey", "key", container)).addLink(new OmOrderByBorder<Configuration>("orderByValue", "value", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator});
        this.form = new ConfigForm("form", this.listContainer, new Configuration());
        this.add(new Component[]{this.form});
        super.onInitialize();
    }
}

