/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import com.github.openjson.JSONArray;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.manager.IWhiteboardManager;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wbWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.WbWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="WbService")
@Path(value="/wb")
public class WbWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(WbWebService.class);
    @Autowired
    private IWhiteboardManager wbManager;
    @Autowired
    private IClientManager cm;

    @WebMethod
    @GET
    @Path(value="/resetwb/{id}")
    @Operation(description="This method will remove all whiteboards from given room\n and create empty one(s) for room files specified", responses={@ApiResponse(responseCode="200", description="serviceResult object with the result", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult resetWb(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="id of the room to clean") @WebParam(name="id") @PathParam(value="id") long id) throws ServiceException {
        log.debug("[resetWb] room id {}", (Object)id);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            this.wbManager.reset(Long.valueOf(id), sd.getUserId());
            return new ServiceResult("", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/cleanwb/{roomid}/{wbid}")
    @Operation(description="This method will do the same as clean WB in the room (except for there will be no UNDO)", responses={@ApiResponse(responseCode="200", description="serviceResult object with the result", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult cleanWb(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="id of the room to clean") @WebParam(name="roomid") @PathParam(value="roomid") long roomId, @Parameter(required=true, description="id of the white board to clean") @WebParam(name="wbid") @PathParam(value="wbid") long wbId) throws ServiceException {
        log.debug("[cleanWb] room id {}, wb id {}", (Object)roomId, (Object)wbId);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            this.wbManager.clearAll(Long.valueOf(roomId), wbId, null);
            return new ServiceResult("", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/cleanslide/{roomid}/{wbid}/{slide}")
    @Operation(description="This method will do the same as clean slide in the room (except for there will be no UNDO)", responses={@ApiResponse(responseCode="200", description="serviceResult object with the result", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult cleanSlide(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="id of the room to clean") @WebParam(name="roomid") @PathParam(value="roomid") long roomId, @Parameter(required=true, description="id of the white board to clean") @WebParam(name="wbid") @PathParam(value="wbid") long wbId, @Parameter(required=true, description="slide number (zero based)") @WebParam(name="slide") @PathParam(value="slide") int slide) throws ServiceException {
        log.debug("[cleanSlide] room id {}, wb id {}, slide {}", new Object[]{roomId, wbId, slide});
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            this.wbManager.cleanSlide(Long.valueOf(roomId), wbId, slide, null);
            return new ServiceResult("", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @POST
    @Path(value="/uploadwb/{type}")
    @Operation(description="This method will receive WB as binary data (png) and store it to temporary PDF/PNG file", responses={@ApiResponse(responseCode="200", description="serviceResult object with the result", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult uploadWb(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the type of document being saved PNG/PDF") @WebParam(name="type") @PathParam(value="type") String type, @Parameter(required=true, description="binary data") @WebParam(name="data") @FormParam(value="data") String data) throws ServiceException {
        log.debug("[uploadwb] type {}", (Object)type);
        Client c = this.cm.getBySid(sid);
        boolean allowed = c != null && c.getRoom() != null && c.hasRight(Room.Right.MODERATOR) && !c.getRoom().isHidden(Room.RoomElement.ACTION_MENU);
        return this.performCall(null, (Sessiondata sd) -> allowed, (Sessiondata sd) -> {
            try {
                String fuid;
                block20: {
                    String tDir = System.getProperty("java.io.tmpdir");
                    fuid = UUID.randomUUID().toString();
                    if ("pdf".equals(type)) {
                        try (PDDocument doc = new PDDocument();
                             FileOutputStream os = new FileOutputStream(Paths.get(tDir, fuid).toFile());){
                            JSONArray arr = new JSONArray(data);
                            for (int i = 0; i < arr.length(); ++i) {
                                String base64Image = arr.getString(i).split(",")[1];
                                byte[] bb = Base64.decodeBase64((String)base64Image);
                                BufferedImage img = ImageIO.read(new ByteArrayInputStream(bb));
                                float width = img.getWidth();
                                float height = img.getHeight();
                                PDPage page = new PDPage(new PDRectangle(width, height));
                                PDImageXObject pdImageXObject = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)img);
                                try (PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, false);){
                                    contentStream.drawImage(pdImageXObject, 0.0f, 0.0f, width, height);
                                }
                                doc.addPage(page);
                            }
                            doc.save((OutputStream)os);
                            break block20;
                        }
                    }
                    JSONArray arr = new JSONArray(data);
                    String base64Image = arr.getString(0).split(",")[1];
                    byte[] bb = Base64.decodeBase64((String)base64Image);
                    FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(bb), (File)Paths.get(tDir, fuid).toFile());
                }
                return new ServiceResult(fuid, ServiceResult.Type.SUCCESS);
            }
            catch (Exception e) {
                return new ServiceResult(e.getMessage(), ServiceResult.Type.ERROR);
            }
        });
    }
}

