/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import oracle.jdbc.OracleXAConnectionBuilder;
import oracle.jdbc.datasource.OracleXAConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public abstract class OracleXADataSource
extends OracleConnectionPoolDataSource
implements oracle.jdbc.datasource.OracleXADataSource {
    protected boolean useNativeXA = false;

    public OracleXADataSource() throws SQLException {
        this.dataSourceName = "OracleXADataSource";
    }

    @Override
    public abstract XAConnection getXAConnection() throws SQLException;

    @Override
    public abstract XAConnection getXAConnection(String var1, @Blind String var2) throws SQLException;

    public abstract XAConnection getXAConnection(Properties var1) throws SQLException;

    @Override
    public synchronized void setURL(String string) {
        super.setURL(string);
        if (string != null) {
            if (string.startsWith("jdbc:oracle:thin")) {
                this.useNativeXA = true;
            } else if (string.startsWith("jdbc:oracle:oci") || string.startsWith("jdbc:oracle:oci8")) {
                this.useNativeXA = false;
            }
        }
    }

    public synchronized void setNativeXA(boolean bl) {
        this.useNativeXA = bl;
    }

    public synchronized boolean getNativeXA() {
        return this.useNativeXA;
    }

    @Override
    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        super.copy(oracleDataSource);
        ((OracleXADataSource)oracleDataSource).useNativeXA = this.useNativeXA;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public OracleXAConnectionBuilder createXAConnectionBuilder() {
        return new OracleXAConnectionBuilderImpl(){

            @Override
            public OracleXAConnection build() throws SQLException {
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = OracleXADataSource.this.createConnectionBuilder().user(this.user).password(this.password).instanceName(this.instanceName).serviceName(this.serviceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey);
                if (this.sslContext != null) {
                    oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.sslContext(this.sslContext);
                }
                if (this.gssCredential != null) {
                    oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.gssCredential(this.gssCredential);
                }
                if (oracleConnectionBuilderImpl.getGSSCredential() != null && (oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null)) {
                    throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                }
                return (OracleXAConnection)((Object)OracleXADataSource.this.getPooledConnection(oracleConnectionBuilderImpl));
            }
        };
    }
}

