/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.jquery.util.Generics2;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public final class CssClassNames {
    public static ICssClassNameProvider newProvider(final IModel<String> model) {
        Args.notNull(model, (String)"model");
        return new ICssClassNameProvider(){

            @Override
            public String cssClassName() {
                return (String)model.getObject();
            }
        };
    }

    private CssClassNames() {
        throw new UnsupportedOperationException();
    }

    public static String join(Iterable<String> classNames) {
        return StringUtils.join(classNames, (String)" ");
    }

    public static Set<String> split(CharSequence classValue) {
        String clazzes;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String string = clazzes = classValue != null ? classValue.toString() : null;
        if (StringUtils.isNotBlank((CharSequence)clazzes)) {
            for (String clazz : StringUtils.split((String)clazzes, (String)" ")) {
                if ((clazz = StringUtils.trimToNull((String)clazz)) == null) continue;
                result.add(clazz);
            }
        }
        return result;
    }

    public static Builder newBuilder() {
        return new Builder("");
    }

    public static Builder parse(String classValue) {
        return new Builder(classValue);
    }

    public static final class Typography {
        public static final String lead = "lead";
        public static final String lowercase = "text-lowercase";
        public static final String uppercase = "text-uppercase";
        public static final String capitalize = "text-capitalize";
        public static final String initialism = "initialism";
        public static final String textLeft = "text-left";
        public static final String textCenter = "text-center";
        public static final String textRight = "text-right";
        public static final String textJustify = "text-justify";
        public static final String textNowrap = "text-nowrap";
        public static final String listInline = "list-inline";
    }

    public static final class Grid {
        public static final String container = "container";
        public static final String containerFluid = "container-fluid";
        public static final String row = "row";
        public static final String colLarge = "col-lg";
        public static final String colSmall = "col-sm";
        public static final String colMedium = "col-md";
        public static final String colXtraSmall = "col-xs";
        public static final String visibleLargeBlock = "visible-lg-block";
        public static final String visibleSmallBlock = "visible-sm-block";
        public static final String visibleMediumBlock = "visible-md-block";
        public static final String visibleXtraSmallBlock = "visible-xs-block";
    }

    public static final class Table {
        public static final String table = "table";
        public static final String striped = "table-striped";
        public static final String bordered = "table-bordered";
        public static final String hover = "table-hover";
        public static final String sm = "table-sm";
        public static final String responsive = "table-responsive";
        public static final String dark = "table-dark";
        public static final String light = "table-light";
    }

    public static final class Form {
        public static final String form = "form";
        public static final String formRow = "form-row";
        public static final String control = "form-control";
        public static final String label = "col-form-label";
        public static final String staticControl = "form-control-static";
        public static final String feedbackControl = "form-control-feedback";
        public static final String group = "form-group";
        public static final String groupLarge = "form-control-lg";
        public static final String groupSmall = "form-control-sm";
        public static final String horizontal = "form-horizontal";
        public static final String help = "form-text";
        public static final String inline = "form-inline";
        public static final String disabled = "disabled";
        public static final String formCheck = "form-check";
        public static final String hasSuccess = "has-success";
        public static final String hasWarning = "has-warning";
        public static final String hasFeedback = "has-feedback";
        public static final String hasError = "has-error";
        public static final String large = "form-control-lg";
        public static final String small = "form-control-sm";
    }

    public static final class Helper {
        public static final String clearfix = "clearfix";
        public static final String screenReaderOnly = "sr-only";
    }

    public static final class Builder {
        private final Set<String> classValues = Generics2.newLinkedHashSet(Collections.emptySet());

        private Builder(String classValue) {
            this.addRaw(classValue);
        }

        public Builder addRaw(String rawCssString) {
            this.add(CssClassNames.split(Strings2.nullToEmpty((String)rawCssString)));
            return this;
        }

        public Builder remove(Builder builder) {
            Args.notNull((Object)builder, (String)"builder");
            return this.remove(builder.asSet());
        }

        public Builder remove(String ... classNames) {
            Args.notNull((Object)classNames, (String)"classNames");
            return this.remove(Set.of(classNames));
        }

        public Builder remove(Set<String> classNames) {
            Args.notNull(classNames, (String)"classNames");
            this.classValues.removeAll(classNames);
            return this;
        }

        public Builder add(Builder builder) {
            Args.notNull((Object)builder, (String)"builder");
            return this.add(builder.asSet());
        }

        public Builder add(String ... classNames) {
            Args.notNull((Object)classNames, (String)"classNames");
            return this.add(Generics2.newLinkedHashSet(List.of(classNames)));
        }

        public Builder add(Set<String> classNames) {
            Args.notNull(classNames, (String)"classNames");
            this.classValues.addAll(classNames);
            return this;
        }

        public String asString() {
            return CssClassNames.join(this.classValues);
        }

        public List<String> asList() {
            return Generics2.newArrayList(this.classValues);
        }

        public Set<String> asSet() {
            return Generics2.newLinkedHashSet(this.classValues);
        }

        public boolean contains(String className) {
            return this.classValues.contains(className);
        }
    }
}

