/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.remote;

import com.github.openjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openmeetings.core.remote.AbstractStream;
import org.apache.openmeetings.core.remote.IStreamProcessor;
import org.apache.openmeetings.core.remote.KTestStream;
import org.apache.openmeetings.core.remote.KurentoHandler;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.kurento.client.IceCandidate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class TestStreamProcessor
implements IStreamProcessor {
    private final Map<String, KTestStream> streamByUid = new ConcurrentHashMap<String, KTestStream>();
    @Autowired
    private KurentoHandler kHandler;

    TestStreamProcessor() {
    }

    void onMessage(IWsClient c, String cmdId, JSONObject msg) {
        KTestStream user = this.getByUid(c.getUid());
        switch (cmdId) {
            case "wannaRecord": {
                WebSocketHelper.sendClient(c, TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"canRecord").put("iceServers", (Object)this.kHandler.getTurnServers(null, true)));
                break;
            }
            case "record": {
                if (user != null) {
                    user.release();
                }
                user = new KTestStream(c, msg);
                this.streamByUid.put(c.getUid(), user);
                break;
            }
            case "iceCandidate": {
                JSONObject candidate = msg.getJSONObject("candidate");
                if (user == null) break;
                IceCandidate cand = new IceCandidate(candidate.getString("candidate"), candidate.getString("sdpMid"), candidate.getInt("sdpMLineIndex"));
                user.addCandidate(cand);
                break;
            }
            case "wannaPlay": {
                WebSocketHelper.sendClient(c, TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"canPlay").put("iceServers", (Object)this.kHandler.getTurnServers(null, true)));
                break;
            }
            case "play": {
                if (user == null) break;
                user.play(c, msg);
                break;
            }
        }
    }

    private KTestStream getByUid(String uid) {
        return uid == null ? null : this.streamByUid.get(uid);
    }

    static JSONObject newTestKurentoMsg() {
        return KurentoHandler.newKurentoMsg().put("mode", (Object)"test");
    }

    void remove(IWsClient c) {
        KTestStream s = this.getByUid(c.getUid());
        if (s != null) {
            s.release();
        }
    }

    @Override
    public void release(AbstractStream stream, boolean releaseStream) {
        this.streamByUid.remove(stream.getUid());
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, KTestStream> e : this.streamByUid.entrySet()) {
            e.getValue().release();
            this.streamByUid.remove(e.getKey());
        }
        this.streamByUid.clear();
    }
}

