/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.remote;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.openmeetings.core.converter.BaseConverter;
import org.apache.openmeetings.core.converter.IRecordingConverter;
import org.apache.openmeetings.core.converter.InterviewConverter;
import org.apache.openmeetings.core.converter.RecordingConverter;
import org.apache.openmeetings.core.remote.AbstractStream;
import org.apache.openmeetings.core.remote.IStreamProcessor;
import org.apache.openmeetings.core.remote.KRoom;
import org.apache.openmeetings.core.remote.KStream;
import org.apache.openmeetings.core.remote.KurentoHandler;
import org.apache.openmeetings.core.remote.StreamProcessorActions;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.logging.TimedApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class StreamProcessor
implements IStreamProcessor {
    private static final Logger log = LoggerFactory.getLogger(StreamProcessor.class);
    private final Map<String, KStream> streamByUid = new ConcurrentHashMap<String, KStream>();
    @Autowired
    private IClientManager cm;
    @Autowired
    private RecordingDao recDao;
    @Autowired
    private KurentoHandler kHandler;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private RecordingConverter recordingConverter;
    @Autowired
    private InterviewConverter interviewConverter;
    @Autowired
    private StreamProcessorActions streamProcessorActions;

    @TimedApplication
    void onMessage(Client c, String cmdId, JSONObject msg) {
        String uid = msg.optString("uid");
        log.debug("Incoming message from user with ID '{}': {}", (Object)c.getUserId(), (Object)msg);
        switch (cmdId) {
            case "devicesAltered": {
                Client.StreamDesc sd = c.getStream(uid);
                if (sd == null) break;
                if (!msg.getBoolean("audio") && c.hasActivity(Client.Activity.AUDIO)) {
                    c.remove(Client.Activity.AUDIO);
                }
                if (!msg.getBoolean("video") && c.hasActivity(Client.Activity.VIDEO)) {
                    c.remove(Client.Activity.VIDEO);
                }
                sd.setActivities();
                WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoomId(), this.cm.update(c), RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
                break;
            }
            case "toggleActivity": {
                this.toggleActivity(c, Client.Activity.valueOf((String)msg.getString("activity")));
                break;
            }
            case "broadcastStarted": {
                this.streamProcessorActions.handleBroadcastStarted(c, uid, msg);
                break;
            }
            case "broadcastRestarted": {
                this.streamProcessorActions.handleBroadcastRestarted(c, uid);
                break;
            }
            case "onIceCandidate": {
                this.streamProcessorActions.addIceCandidate(msg);
                break;
            }
            case "addListener": {
                this.streamProcessorActions.addListener(c, msg);
                break;
            }
            case "wannaShare": {
                Optional osd = c.getScreenStream();
                if (!this.screenShareAllowed(c) && (!osd.isPresent() || ((Client.StreamDesc)osd.get()).hasActivity(Client.Activity.SCREEN))) break;
                this.startSharing(c, osd, msg, Client.Activity.SCREEN);
                break;
            }
            case "wannaRecord": {
                Optional osd = c.getScreenStream();
                if (!this.recordingAllowed(c)) break;
                Room r = c.getRoom();
                if (Room.Type.INTERVIEW == r.getType()) {
                    log.warn("This shouldn't be called for interview room");
                    break;
                }
                boolean sharing = this.isSharing(r.getId());
                this.startSharing(c, osd, msg, Client.Activity.RECORD);
                if (!sharing) break;
                this.startRecording(c);
                break;
            }
            case "pauseSharing": {
                this.pauseSharing(c, uid);
                break;
            }
            case "stopRecord": {
                this.stopRecording(c);
                break;
            }
            case "errorSharing": {
                this.errorSharing(c);
                break;
            }
        }
    }

    void startBroadcast(KStream stream, Client.StreamDesc sd, String sdpOffer, Runnable then) {
        stream.startBroadcast(sd, sdpOffer, then);
    }

    private static boolean isBroadcasting(Client c) {
        return c.hasAnyActivity(new Client.Activity[]{Client.Activity.AUDIO, Client.Activity.VIDEO});
    }

    private Set<String> cleanWebCams(Client c, List<Client.StreamDesc> streams) {
        HashSet<String> closed = new HashSet<String>();
        streams.stream().filter(lsd -> Client.StreamType.WEBCAM == lsd.getType()).forEach(lsd -> {
            KStream s = this.getByUid(lsd.getUid());
            if (s != null) {
                s.stopBroadcast();
            }
            c.removeStream(lsd.getUid());
            closed.add(lsd.getUid());
        });
        return closed;
    }

    @TimedApplication
    public void toggleActivity(Client c, Client.Activity a) {
        log.info("PARTICIPANT {}: trying to toggle activity {}", (Object)c, (Object)a);
        if (!this.kHandler.isConnected()) {
            return;
        }
        if (KurentoHandler.activityAllowed(c, a, c.getRoom())) {
            boolean wasBroadcasting = StreamProcessor.isBroadcasting(c);
            if (a == Client.Activity.AUDIO && !c.isMicEnabled()) {
                return;
            }
            if (a == Client.Activity.VIDEO && !c.isCamEnabled()) {
                return;
            }
            if (a == Client.Activity.AUDIO_VIDEO && !c.isMicEnabled() && !c.isCamEnabled()) {
                return;
            }
            c.toggle(a);
            List streams = c.getStreams();
            if (!StreamProcessor.isBroadcasting(c)) {
                Set<String> closed = this.cleanWebCams(c, streams);
                if (!closed.isEmpty()) {
                    this.cm.update(c);
                    this.checkStreams(c.getRoomId());
                    WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
                }
            } else {
                Client.StreamDesc sd = c.addStream(Client.StreamType.WEBCAM, new Client.Activity[0]);
                Set closed = wasBroadcasting ? this.cleanWebCams(c, streams) : Set.of();
                this.cm.update(c.restoreActivities(sd));
                log.debug("User {}: has started broadcast", (Object)sd.getUid());
                this.kHandler.sendClient(sd.getSid(), KurentoHandler.newKurentoMsg().put("id", (Object)"broadcast").put("stream", (Object)sd.toJson(true)).put("cleanup", (Object)new JSONArray(closed)).put("iceServers", (Object)this.kHandler.getTurnServers(c, false)));
            }
        }
    }

    private void constraintsChanged(Client c) {
        c.getStreams().stream().filter(sd -> Client.StreamType.WEBCAM == sd.getType()).findFirst().ifPresent(sd -> {
            sd.setActivities();
            this.cm.update(c);
        });
    }

    public void rightsUpdated(Client c) {
        Optional osd = c.getScreenStream();
        if (osd.isPresent() && !this.hasRightsToShare(c)) {
            this.stopSharing(c, ((Client.StreamDesc)osd.get()).getUid());
        }
        if (StreamProcessor.isBroadcasting(c)) {
            this.constraintsChanged(c);
        } else {
            c.getStreams().stream().filter(sd -> Client.StreamType.WEBCAM == sd.getType()).forEach(sd -> {
                KStream stream = this.streamByUid.get(sd.getUid());
                if (stream != null) {
                    KRoom room = this.kHandler.getRoom(c.getRoomId());
                    room.onStopBroadcast(stream);
                }
            });
        }
        WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
    }

    private void checkStreams(Long roomId) {
        if (!this.kHandler.isConnected()) {
            return;
        }
        KRoom kRoom = this.kHandler.getRoom(roomId);
        if (kRoom.isSharing() && this.cm.streamByRoom(roomId).flatMap(c -> c.getStreams().stream()).filter(sd -> Client.StreamType.SCREEN == sd.getType()).findAny().isEmpty()) {
            log.info("No more screen streams in the room, stopping sharing");
            kRoom.stopSharing();
            if (Room.Type.INTERVIEW != kRoom.getRoom().getType() && kRoom.isRecording()) {
                log.info("No more screen streams in the non-interview room, stopping recording");
                kRoom.stopRecording(null);
            }
        }
        if (kRoom.isRecording() && this.cm.streamByRoom(roomId).flatMap(c -> c.getStreams().stream()).findAny().isEmpty()) {
            log.info("No more streams in the room, stopping recording");
            kRoom.stopRecording(null);
        }
    }

    public boolean hasRightsToShare(Client c) {
        if (!this.kHandler.isConnected()) {
            return false;
        }
        Room r = c.getRoom();
        return r != null && Room.Type.INTERVIEW != r.getType() && !r.isHidden(Room.RoomElement.SCREEN_SHARING) && c.hasRight(Room.Right.SHARE);
    }

    public boolean screenShareAllowed(Client c) {
        Room r = c.getRoom();
        return this.hasRightsToShare(c) && !this.isSharing(r.getId());
    }

    private void errorSharing(Client c) {
        if (!this.kHandler.isConnected()) {
            return;
        }
        KRoom room = this.kHandler.getRoom(c.getRoomId());
        if (!room.isSharing() || !c.getSid().equals(room.getSharingUser().getString("sid"))) {
            return;
        }
        Optional osd = c.getScreenStream();
        if (osd.isPresent()) {
            this.stopSharing(c, ((Client.StreamDesc)osd.get()).getUid());
        } else {
            room.stopSharing();
        }
        this.stopRecording(c);
    }

    private void startSharing(Client c, Optional<Client.StreamDesc> osd, JSONObject msg, Client.Activity a) {
        if (this.kHandler.isConnected() && c.getRoomId() != null) {
            this.kHandler.getRoom(c.getRoomId()).startSharing(c, osd, msg, a);
        }
    }

    void pauseSharing(Client c, String uid) {
        if (!this.hasRightsToShare(c)) {
            return;
        }
        if (!this.isSharing(c.getRoomId())) {
            return;
        }
        if (this.isRecording(c.getRoomId())) {
            Client.StreamDesc sd = c.getStream(uid);
            sd.removeActivity(Client.Activity.SCREEN);
            this.cm.update(c);
            KStream sender = this.getByUid(uid);
            sender.pauseSharing();
            this.kHandler.sendShareUpdated(sd);
            WebSocketHelper.sendRoomOthers(c.getRoomId(), c.getUid(), StreamProcessor.newStoppedMsg(sd));
        } else {
            this.stopSharing(c, uid);
        }
    }

    private void stopSharing(Client c, String uid) {
        KStream sender = this.getByUid(uid);
        Client.StreamDesc sd = this.doStopSharing(c.getSid(), uid);
        if (sender != null && sd != null) {
            sender.stopBroadcast();
        } else {
            log.warn("Could not stop broadcast - could be a KStream leak and lead to ghost KStream, client: {}, uid: {} ", (Object)c, (Object)uid);
        }
    }

    Client.StreamDesc doStopSharing(String sid, String uid) {
        return this.doStopSharing(this.getBySid(sid), uid);
    }

    private Client.StreamDesc doStopSharing(Client c, String uid) {
        Client.StreamDesc sd = null;
        if (c.getRoomId() != null && (sd = c.getStream(uid)) != null && Client.StreamType.SCREEN == sd.getType()) {
            c.removeStream(uid);
            this.cm.update(c);
            this.checkStreams(c.getRoomId());
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
            this.kHandler.sendShareUpdated(sd.removeActivity(Client.Activity.SCREEN).removeActivity(Client.Activity.RECORD));
        }
        return sd;
    }

    public boolean isSharing(Long roomId) {
        if (!this.kHandler.isConnected()) {
            return false;
        }
        return this.kHandler.getRoom(roomId).isSharing();
    }

    public boolean hasRightsToRecord(Client c) {
        Room r = c.getRoom();
        return OpenmeetingsVariables.isRecordingsEnabled() && r != null && r.isAllowRecording() && c.hasRight(Room.Right.MODERATOR);
    }

    public boolean recordingAllowed(Client c) {
        if (!this.kHandler.isConnected() || !OpenmeetingsVariables.isRecordingsEnabled()) {
            return false;
        }
        Room r = c.getRoom();
        return this.hasRightsToRecord(c) && !this.isRecording(r.getId());
    }

    public void startRecording(Client c) {
        if (!this.kHandler.isConnected() || !this.hasRightsToRecord(c)) {
            return;
        }
        this.kHandler.getRoom(c.getRoomId()).startRecording(c);
    }

    public void stopRecording(Client c) {
        if (!this.kHandler.isConnected() || !this.hasRightsToRecord(c)) {
            return;
        }
        this.kHandler.getRoom(c.getRoomId()).stopRecording(c);
        c.getScreenStream().ifPresent(sd -> {
            if (!sd.hasActivity(Client.Activity.SCREEN)) {
                this.pauseSharing(c, sd.getUid());
            }
        });
    }

    boolean startConvertion(Recording rec) {
        BaseConverter conv = rec.isInterview() ? this.interviewConverter : this.recordingConverter;
        this.taskExecutor.execute(() -> StreamProcessor.lambda$startConvertion$10((IRecordingConverter)((Object)conv), rec));
        return true;
    }

    public boolean isRecording(Long roomId) {
        if (!this.kHandler.isConnected()) {
            return false;
        }
        return this.kHandler.getRoom(roomId).isRecording();
    }

    void remove(Client c) {
        for (Client.StreamDesc sd : c.getStreams()) {
            KStream s = this.getByUid(sd.getUid());
            if (s == null) continue;
            s.release();
            WebSocketHelper.sendRoomOthers(c.getRoomId(), c.getUid(), StreamProcessor.newStoppedMsg(sd));
        }
        if (c.getRoomId() != null) {
            this.getByRoom(c.getRoomId()).forEach(stream -> stream.remove(c));
            this.checkStreams(c.getRoomId());
        }
    }

    void addStream(KStream stream) {
        this.streamByUid.put(stream.getUid(), stream);
    }

    public Collection<KStream> getStreams() {
        return this.streamByUid.values();
    }

    Stream<KStream> getByRoom(Long roomId) {
        return this.streamByUid.values().stream().filter(stream -> stream.getRoomId().equals(roomId));
    }

    Client getBySid(String sid) {
        return this.cm.getBySid(sid);
    }

    public boolean hasStream(String uid) {
        return this.streamByUid.get(uid) != null;
    }

    KStream getByUid(String uid) {
        return uid == null ? null : this.streamByUid.get(uid);
    }

    KurentoHandler getHandler() {
        return this.kHandler;
    }

    IClientManager getClientManager() {
        return this.cm;
    }

    RecordingDao getRecordingDao() {
        return this.recDao;
    }

    @Override
    public void release(AbstractStream stream, boolean releaseStream) {
        Client.StreamDesc sd;
        Client c;
        String uid = stream.getUid();
        if (releaseStream) {
            stream.release();
        }
        if ((c = this.cm.getBySid(stream.getSid())) != null && (sd = c.getStream(uid)) != null) {
            c.removeStream(uid);
            if (Client.StreamType.WEBCAM == sd.getType()) {
                for (Client.Activity a : sd.getActivities()) {
                    c.remove(a);
                }
            }
            this.cm.update(c);
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
        }
        this.streamByUid.remove(uid);
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, KStream> e : this.streamByUid.entrySet()) {
            this.release(e.getValue(), true);
        }
    }

    protected static JSONObject newStoppedMsg(Client.StreamDesc sd) {
        return KurentoHandler.newKurentoMsg().put("id", (Object)"broadcastStopped").put("uid", (Object)sd.getUid());
    }

    private static /* synthetic */ void lambda$startConvertion$10(IRecordingConverter conv, Recording rec) {
        conv.startConversion(rec);
    }
}

