/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.common;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class SessionQuotaManagingDataStore
extends DelegatingPageStore {
    private static final MetaDataKey<SessionData> KEY = new MetaDataKey<SessionData>(){
        private static final long serialVersionUID = 1L;
    };
    private final Supplier<SessionData> dataCreator;

    public SessionQuotaManagingDataStore(IPageStore delegate, int maxPages) {
        this(delegate, () -> new CountLimitedData(maxPages));
    }

    public SessionQuotaManagingDataStore(IPageStore delegate, Bytes maxBytes) {
        this(delegate, () -> new SizeLimitedData(maxBytes));
    }

    SessionQuotaManagingDataStore(IPageStore delegate, Supplier<SessionData> dataCreator) {
        super(delegate);
        this.dataCreator = dataCreator;
    }

    private SessionData getSessionData(IPageContext context, boolean create) {
        return (SessionData)context.getSessionData(KEY, () -> {
            if (create) {
                return this.dataCreator.get();
            }
            return null;
        });
    }

    public boolean canBeAsynchronous(IPageContext context) {
        this.getSessionData(context, true);
        return this.getDelegate().canBeAsynchronous(context);
    }

    public void removeAllPages(IPageContext context) {
        SessionData sessionData = this.getSessionData(context, false);
        if (sessionData != null) {
            sessionData.removeAllPages(context, this.getDelegate());
        }
    }

    public void addPage(IPageContext context, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("SessionQuotaDataStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        SessionData sessionData = this.getSessionData(context, true);
        sessionData.addPage(context, this.getDelegate(), serializedPage);
    }

    public void removePage(IPageContext context, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("SessionQuotaDataStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        SessionData sessionData = this.getSessionData(context, false);
        if (sessionData != null) {
            sessionData.removePage(context, this.getDelegate(), serializedPage);
        }
    }

    static class DelegatedPage
    implements Serializable {
        public final int pageId;
        public final long pageSize;

        public DelegatedPage(int pageId, long pageSize) {
            this.pageId = pageId;
            this.pageSize = pageSize;
        }
    }

    static class SizeLimitedData
    extends SessionData {
        private final Bytes maxBytes;
        private int size;

        public SizeLimitedData(Bytes maxBytes) {
            this.maxBytes = maxBytes;
        }

        @Override
        synchronized void addPage(IPageContext context, IPageStore delegate, SerializedPage page) {
            super.addPage(context, delegate, page);
            this.size += page.getData().length;
            while ((long)this.size > this.maxBytes.bytes()) {
                DelegatedPage polled = (DelegatedPage)this.pages.peek();
                this.removePage(context, delegate, new SerializedPage(polled.pageId, new byte[0]));
            }
        }

        @Override
        synchronized void removeAllPages(IPageContext context, IPageStore delegate) {
            super.removeAllPages(context, delegate);
            this.size = 0;
        }

        @Override
        synchronized DelegatedPage removePage(IPageContext context, IPageStore delegate, SerializedPage page) {
            DelegatedPage removedPage = super.removePage(context, delegate, page);
            if (removedPage != null) {
                this.size = (int)((long)this.size - removedPage.pageSize);
            }
            return removedPage;
        }
    }

    static class CountLimitedData
    extends SessionData {
        private final int maxPages;

        public CountLimitedData(int maxPages) {
            this.maxPages = maxPages;
        }

        @Override
        synchronized void addPage(IPageContext context, IPageStore delegate, SerializedPage page) {
            super.addPage(context, delegate, page);
            while (this.pages.size() > this.maxPages) {
                DelegatedPage polled = (DelegatedPage)this.pages.poll();
                this.removePage(context, delegate, new SerializedPage(polled.pageId, new byte[0]));
            }
        }
    }

    static abstract class SessionData
    implements Serializable {
        final ConcurrentLinkedQueue<DelegatedPage> pages = new ConcurrentLinkedQueue();

        SessionData() {
        }

        synchronized void addPage(IPageContext context, IPageStore delegate, SerializedPage page) {
            Args.notNull((Object)page, (String)"page");
            this.removePage(context, delegate, page);
            this.pages.add(new DelegatedPage(page.getPageId(), page.getData().length));
            delegate.addPage(context, (IManageablePage)page);
        }

        synchronized void removeAllPages(IPageContext context, IPageStore delegate) {
            this.pages.clear();
            delegate.removeAllPages(context);
        }

        synchronized DelegatedPage removePage(IPageContext context, IPageStore delegate, SerializedPage page) {
            DelegatedPage delegatedPage = null;
            Iterator<DelegatedPage> pageIterator = this.pages.iterator();
            while (pageIterator.hasNext()) {
                DelegatedPage candidate = pageIterator.next();
                if (candidate.pageId != page.getPageId()) continue;
                pageIterator.remove();
                delegatedPage = candidate;
                break;
            }
            delegate.removePage(context, (IManageablePage)page);
            return delegatedPage;
        }
    }
}

