/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.scheduler;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.openmeetings.core.rss.LoadAtomRssFeed;
import org.apache.openmeetings.db.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomReader {
    private static final Logger log = LoggerFactory.getLogger(AtomReader.class);
    private static final String ATTR_CONTENT = "content";
    private static final String ATTR_PUBLISHED = "published";
    private static final int MAX_ITEM_COUNT = 5;
    private static final Map<String, Spec> specs = new HashMap<String, Spec>();
    private static final XMLInputFactory inputFactory = XmlHelper.createInputFactory();

    private AtomReader() {
    }

    private static Spec add(String name) {
        Spec s = new Spec(name);
        specs.put(name, s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String url, JSONArray feed) {
        HttpURLConnection con = null;
        try {
            con = LoadAtomRssFeed.getFeedConnection((String)url);
            try (InputStream is = con.getInputStream();){
                XMLEventReader reader = inputFactory.createXMLEventReader(is);
                int i = 0;
                JSONObject obj = null;
                StringBuilder val = null;
                Spec spec = null;
                Field f = null;
                while (reader.hasNext()) {
                    String name;
                    StartElement start;
                    XMLEvent evt = reader.nextEvent();
                    if (obj == null && evt.isStartElement()) {
                        start = (StartElement)evt;
                        name = start.getName().getLocalPart();
                        if (specs.containsKey(name)) {
                            spec = specs.get(name);
                            obj = new JSONObject();
                            ++i;
                        }
                    } else if (obj != null) {
                        if (evt.isStartElement()) {
                            start = (StartElement)evt;
                            name = start.getName().getLocalPart();
                            if (spec.contains(name)) {
                                Attribute a;
                                f = spec.get(name);
                                val = new StringBuilder();
                                if (f.getAttr() != null && (a = start.getAttributeByName(new QName(f.getAttr()))) != null) {
                                    val.append(a.getValue());
                                }
                            }
                        } else if (f != null && evt.isCharacters()) {
                            val.append(StringEscapeUtils.escapeXml11((String)((Characters)evt).getData()));
                        } else if (f != null && evt.isEndElement() && f.getName().equals(((EndElement)evt).getName().getLocalPart())) {
                            if (!obj.has(f.getAlias())) {
                                obj.put(f.getAlias(), (Object)val.toString());
                            }
                            f = null;
                        } else if (evt.isEndElement() && spec.getName().equals(((EndElement)evt).getName().getLocalPart())) {
                            feed.put((Object)obj);
                            obj = null;
                        }
                    }
                    if (i <= 5) continue;
                    break;
                }
            }
        }
        catch (IOException | XMLStreamException e) {
            log.error("Unexpected error while getting RSS", (Throwable)e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    static {
        AtomReader.add("item").add(new Field("title")).add(new Field("link")).add(new Field("description", ATTR_CONTENT, true)).add(new Field("pubDate", ATTR_PUBLISHED)).add(new Field("author"));
        AtomReader.add("entry").add(new Field("title")).add(new Field("link", "link", "href", false)).add(new Field(ATTR_CONTENT, ATTR_CONTENT, true)).add(new Field("updated", ATTR_PUBLISHED)).add(new Field(ATTR_PUBLISHED)).add(new Field("author"));
    }

    public static class Field {
        private final String name;
        private final String alias;
        private final String attr;
        private final boolean xml;

        public Field(String name) {
            this(name, name);
        }

        public Field(String name, String alias) {
            this(name, alias, false);
        }

        public Field(String name, String alias, boolean xml) {
            this(name, alias, null, xml);
        }

        public Field(String name, String alias, String attr, boolean xml) {
            this.name = name;
            this.alias = alias;
            this.attr = attr;
            this.xml = xml;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getAttr() {
            return this.attr;
        }

        public boolean isXml() {
            return this.xml;
        }
    }

    public static class Spec {
        private final String name;
        private final Map<String, Field> fields = new LinkedHashMap<String, Field>();

        public Spec(String name) {
            this.name = name;
        }

        public Spec add(Field f) {
            this.fields.put(f.getName(), f);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public boolean contains(String f) {
            return this.fields.containsKey(f);
        }

        public Field get(String f) {
            return this.fields.get(f);
        }
    }
}

