/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.scheduler;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.BiConsumer;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJob {
    private static Logger log = LoggerFactory.getLogger(AbstractJob.class);
    @Autowired
    GroupDao groupDao;
    @Autowired
    RecordingDao recordingDao;

    void processExpiringRecordings(boolean notified, BiConsumer<Recording, Long> consumer) {
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        for (Group g : this.groupDao.getLimited()) {
            for (Recording rec : this.recordingDao.getExpiring(g.getId(), g.getReminderDays(), notified)) {
                try {
                    long days = (long)g.getRecordingTtl() - ChronoUnit.DAYS.between(rec.getInserted().toInstant(), Instant.now());
                    consumer.accept(rec, days);
                }
                catch (Exception e) {
                    log.error("Uexpected exception while processing expiring recordings emails", (Throwable)e);
                }
            }
        }
    }
}

