/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav.methods;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.XmlEntity;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.apache.openmeetings.service.calendar.caldav.methods.SyncReportInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SyncMethod
extends BaseDavRequest {
    private static final Logger log = LoggerFactory.getLogger(SyncMethod.class);
    private MultiStatus multiStatus = null;
    private String synctoken = null;
    private boolean processedResponse = false;

    public SyncMethod(URI uri, SyncReportInfo reportInfo) throws IOException {
        super(uri);
        this.setEntity(XmlEntity.create((XmlSerializable)reportInfo));
        if (reportInfo.getDepth() >= 0) {
            this.parseDepth(reportInfo.getDepth());
        }
        log.info("Using the WEBDAV-SYNC method for syncing.");
    }

    public SyncMethod(String uri, SyncReportInfo reportInfo) throws IOException {
        this(URI.create(uri), reportInfo);
    }

    private void parseDepth(int depth) {
        DepthHeader dh = new DepthHeader(depth);
        this.setHeader(dh.getHeaderName(), dh.getHeaderValue());
    }

    public void setDepth(int depth) {
        this.parseDepth(depth);
    }

    public String getMethod() {
        return "REPORT";
    }

    public boolean succeeded(HttpResponse response) {
        return response.getStatusLine().getStatusCode() == 207;
    }

    public String getResponseSynctoken(HttpResponse response) {
        if (!this.processedResponse) {
            this.processResponseBody(response);
        }
        return this.synctoken;
    }

    public MultiStatus getResponseBodyAsMultiStatus(HttpResponse response) throws DavException {
        if (!this.processedResponse) {
            this.processResponseBody(response);
        }
        if (this.multiStatus != null) {
            return this.multiStatus;
        }
        DavException dx = this.getResponseException(response);
        if (dx != null) {
            throw dx;
        }
        throw new DavException(response.getStatusLine().getStatusCode(), this.getMethod() + " resulted with unexpected status: " + response.getStatusLine());
    }

    protected void processResponseBody(HttpResponse response) {
        if (!this.processedResponse && this.succeeded(response)) {
            try {
                Document document = this.getResponseBodyAsDocument(response.getEntity());
                if (document != null) {
                    this.synctoken = DomUtil.getChildText((Element)document.getDocumentElement(), (String)"sync-token", (Namespace)DavConstants.NAMESPACE);
                    log.info("Sync-Token for REPORT: {}", (Object)this.synctoken);
                    this.multiStatus = MultiStatus.createFromXml((Element)document.getDocumentElement());
                }
            }
            catch (IOException e) {
                log.error("Error while parsing sync-token.", (Throwable)e);
            }
            this.processedResponse = true;
        }
    }

    public void reset() {
        super.reset();
        this.processedResponse = false;
    }
}

