/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.Prop;
import org.kurento.jsonrpc.Props;

class JsonPropsAdapter
implements JsonDeserializer<Props>,
JsonSerializer<Props> {
    JsonPropsAdapter() {
    }

    public Props deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonObject)) {
            throw new JsonParseException("Cannot convert " + json + " to Props object");
        }
        JsonObject jObject = (JsonObject)json;
        Props props = new Props();
        for (Map.Entry e : jObject.entrySet()) {
            Object value = this.deserialize((JsonElement)e.getValue(), context);
            props.add((String)e.getKey(), value);
        }
        return props;
    }

    private Object deserialize(JsonElement value, JsonDeserializationContext context) {
        if (value instanceof JsonObject) {
            return this.deserialize(value, null, context);
        }
        if (value instanceof JsonPrimitive) {
            return this.toPrimitiveObject(value);
        }
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonElement element : array) {
                result.add(this.deserialize(element, context));
            }
            return result;
        }
        if (value instanceof JsonNull) {
            return null;
        }
        throw new JsonRpcException("Unrecognized Json element: " + value);
    }

    public Object toPrimitiveObject(JsonElement element) {
        JsonPrimitive primitive = (JsonPrimitive)element;
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            Number number = primitive.getAsNumber();
            double value = number.doubleValue();
            if ((double)((int)value) == value) {
                return (int)value;
            }
            if ((double)((long)value) == value) {
                return (long)value;
            }
            if ((double)((float)value) == value) {
                return Float.valueOf((float)value);
            }
            return value;
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        throw new JsonRpcException("Unrecognized JsonPrimitive: " + primitive);
    }

    public JsonElement serialize(Props props, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        for (Prop prop : props) {
            jsonObject.add(prop.getName(), context.serialize(prop.getValue()));
        }
        return jsonObject;
    }
}

