/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.basic;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.IDataProviderEntity;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.wicket.util.string.Strings;

public class Client
implements IDataProviderEntity,
IWsClient {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final int pageId;
    private User user;
    private Room room;
    private final String uid;
    private final String sid;
    private String remoteAddress;
    private final Set<Room.Right> rights = ConcurrentHashMap.newKeySet();
    private final Set<Activity> activities = ConcurrentHashMap.newKeySet();
    private final Map<String, StreamDesc> streams = new ConcurrentHashMap<String, StreamDesc>();
    private final Date connectedSince;
    private int cam = -1;
    private int mic = -1;
    private int width = 0;
    private int height = 0;
    private String serverId = null;
    private final String pictureUri;

    public Client(String sessionId, int pageId, User u, String pictureUri) {
        this.sessionId = sessionId;
        this.pageId = pageId;
        this.user = u;
        this.connectedSince = new Date();
        this.pictureUri = pictureUri;
        this.uid = UUID.randomUUID().toString();
        this.sid = UUID.randomUUID().toString();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public int getPageId() {
        return this.pageId;
    }

    public User getUser() {
        return this.user;
    }

    public Client updateUser(UserDao dao) {
        this.user = dao.get(this.user.getId());
        return this;
    }

    public Long getUserId() {
        return this.user == null ? null : this.user.getId();
    }

    public boolean sameUserId(Long userId) {
        return this.getUserId() != null && this.getUserId().equals(userId);
    }

    public String getPictureUri() {
        return this.pictureUri;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    public String getSid() {
        return this.sid;
    }

    public boolean isSip() {
        return OmFileHelper.SIP_USER_ID.equals(this.getUserId());
    }

    public void clear() {
        this.activities.clear();
        this.rights.clear();
        this.streams.clear();
    }

    public boolean hasRight(Room.Right right) {
        if (Room.Right.SUPER_MODERATOR == right) {
            return this.rights.contains((Object)right);
        }
        return this.rights.contains((Object)Room.Right.SUPER_MODERATOR) || this.rights.contains((Object)Room.Right.MODERATOR) || this.rights.contains((Object)right);
    }

    public Client allow(Room.Right ... inRights) {
        this.allow(List.of(inRights));
        return this;
    }

    public void allow(Iterable<Room.Right> inRights) {
        for (Room.Right right : inRights) {
            if (this.hasRight(right)) continue;
            this.rights.add(right);
        }
    }

    public void deny(Room.Right ... inRights) {
        for (Room.Right right : inRights) {
            this.rights.remove((Object)right);
        }
    }

    public void clearActivities() {
        this.activities.clear();
    }

    public boolean hasAnyActivity(Activity ... aa) {
        boolean res = false;
        if (aa != null) {
            for (Activity a : aa) {
                res |= this.activities.contains((Object)a);
            }
        }
        return res;
    }

    public boolean hasActivity(Activity a) {
        return this.activities.contains((Object)a);
    }

    public Client toggle(Activity a) {
        if (this.hasActivity(a)) {
            this.remove(a);
        } else {
            this.set(a);
        }
        return this;
    }

    public Client set(Activity a) {
        this.activities.add(a);
        switch (a) {
            case VIDEO: 
            case AUDIO: {
                if (!this.hasActivity(Activity.AUDIO) || !this.hasActivity(Activity.VIDEO)) break;
                this.activities.add(Activity.AUDIO_VIDEO);
                break;
            }
            case AUDIO_VIDEO: {
                this.activities.add(Activity.AUDIO);
                this.activities.add(Activity.VIDEO);
                break;
            }
        }
        return this;
    }

    public Client remove(Activity a) {
        this.activities.remove((Object)a);
        switch (a) {
            case VIDEO: 
            case AUDIO: {
                this.activities.remove((Object)Activity.AUDIO_VIDEO);
                break;
            }
            case AUDIO_VIDEO: {
                this.activities.remove((Object)Activity.AUDIO);
                this.activities.remove((Object)Activity.VIDEO);
                break;
            }
        }
        return this;
    }

    public StreamDesc addStream(StreamType stype, Activity ... inActivities) {
        StreamDesc sd = new StreamDesc(stype, inActivities);
        this.streams.put(sd.getUid(), sd);
        return sd;
    }

    public StreamDesc removeStream(String inUid) {
        return this.streams.remove(inUid);
    }

    public List<StreamDesc> getStreams() {
        return new ArrayList<StreamDesc>(this.streams.values());
    }

    public StreamDesc getStream(String inUid) {
        return this.streams.get(inUid);
    }

    public Optional<StreamDesc> getScreenStream() {
        return this.streams.values().stream().filter(sd -> StreamType.SCREEN == sd.getType()).findFirst();
    }

    public Stream<StreamDesc> getCamStreams() {
        return this.streams.values().stream().filter(sd -> StreamType.WEBCAM == sd.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client restoreActivities(StreamDesc sd) {
        Set<Activity> set = this.activities;
        synchronized (set) {
            HashSet<Activity> aa = new HashSet<Activity>(sd.sactivities);
            this.activities.clear();
            this.activities.addAll(aa);
        }
        return this;
    }

    public Date getConnectedSince() {
        return this.connectedSince;
    }

    @Override
    public Long getId() {
        return null;
    }

    @Override
    public void setId(Long id) {
    }

    public Room getRoom() {
        return this.room;
    }

    public Client setRoom(Room room) {
        this.room = room;
        return this;
    }

    public boolean isCamEnabled() {
        return this.cam > -1;
    }

    public int getCam() {
        return this.cam;
    }

    public Client setCam(int cam) {
        this.cam = cam;
        return this;
    }

    public boolean isMicEnabled() {
        return this.mic > -1;
    }

    public int getMic() {
        return this.mic;
    }

    public Client setMic(int mic) {
        this.mic = mic;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public Client setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public Client setHeight(int height) {
        this.height = height;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Client setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public Long getRoomId() {
        return this.room == null ? null : this.room.getId();
    }

    private JSONObject addUserJson(JSONObject o) {
        JSONObject u = new JSONObject();
        if (this.user != null) {
            JSONObject a = new JSONObject();
            u.put("id", (Object)this.user.getId()).put("firstName", (Object)this.user.getFirstname()).put("lastName", (Object)this.user.getLastname()).put("displayName", (Object)this.user.getDisplayName()).put("address", (Object)a).put("pictureUri", (Object)this.pictureUri);
            if (this.user.getAddress() != null) {
                if (Strings.isEmpty((String)this.user.getFirstname()) && Strings.isEmpty((String)this.user.getLastname())) {
                    a.put("email", (Object)this.user.getAddress().getEmail());
                }
                a.put("country", (Object)this.user.getAddress().getCountry());
            }
        }
        return o.put("user", (Object)u).put("level", this.hasRight(Room.Right.MODERATOR) ? 5 : (this.hasRight(Room.Right.WHITEBOARD) ? 3 : 1));
    }

    public JSONObject toJson(boolean self) {
        JSONArray streamArr = new JSONArray();
        for (Map.Entry<String, StreamDesc> e : this.streams.entrySet()) {
            streamArr.put((Object)e.getValue().toJson());
        }
        JSONObject json = new JSONObject().put("cuid", (Object)this.uid).put("uid", (Object)this.uid).put("rights", (Object)new JSONArray(this.rights)).put("activities", (Object)new JSONArray(this.activities)).put("streams", (Object)streamArr).put("width", this.width).put("height", this.height).put("self", self);
        if (self) {
            json.put("cam", this.cam).put("mic", this.mic);
        }
        return this.addUserJson(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Client c) {
        this.user = c.user;
        this.room = c.room;
        Object object = this.rights;
        synchronized (object) {
            HashSet<Room.Right> rr = new HashSet<Room.Right>(c.rights);
            this.rights.clear();
            this.rights.addAll(rr);
        }
        object = this.activities;
        synchronized (object) {
            HashSet<Activity> aa = new HashSet<Activity>(c.activities);
            this.activities.clear();
            this.activities.addAll(aa);
        }
        object = this.streams;
        synchronized (object) {
            HashMap<String, StreamDesc> ss = new HashMap<String, StreamDesc>(c.streams);
            this.streams.clear();
            for (Map.Entry e : ss.entrySet()) {
                this.streams.put((String)e.getKey(), new StreamDesc((StreamDesc)e.getValue()));
            }
        }
        this.cam = c.cam;
        this.mic = c.mic;
        this.width = c.width;
        this.height = c.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Client)) {
            return false;
        }
        Client other = (Client)obj;
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }

    public String toString() {
        return "Client [uid=" + this.uid + ", sessionId=" + this.sessionId + ", pageId=" + this.pageId + ", userId=" + this.getUserId() + ", room=" + this.getRoomId() + ", rights=" + this.rights + ", sactivities=" + this.activities + ", connectedSince=" + this.connectedSince + "]";
    }

    public class StreamDesc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<Activity> sactivities = ConcurrentHashMap.newKeySet();
        private final String uuid;
        private final StreamType type;
        private int swidth;
        private int sheight;

        public StreamDesc(StreamDesc sd) {
            this.uuid = sd.uuid;
            this.type = sd.type;
            this.swidth = sd.swidth;
            this.sheight = sd.sheight;
            this.sactivities.addAll(sd.sactivities);
        }

        public StreamDesc(StreamType type, Activity ... activities) {
            this.uuid = UUID.randomUUID().toString();
            this.type = type;
            if (activities == null || activities.length == 0) {
                this.setActivities();
            } else {
                this.sactivities.addAll(List.of(activities));
            }
            if (StreamType.SCREEN == type) {
                this.swidth = 800;
                this.sheight = 600;
            } else if (StreamType.WEBCAM == type) {
                boolean interview = Client.this.room != null && Room.Type.INTERVIEW == Client.this.room.getType();
                this.swidth = interview ? 320 : Client.this.width;
                this.sheight = interview ? 260 : Client.this.height;
            }
        }

        public String getSid() {
            return Client.this.sid;
        }

        public String getUid() {
            return this.uuid;
        }

        public StreamType getType() {
            return this.type;
        }

        public int getWidth() {
            return this.swidth;
        }

        public StreamDesc setWidth(int width) {
            this.swidth = width;
            return this;
        }

        public int getHeight() {
            return this.sheight;
        }

        public StreamDesc setHeight(int height) {
            this.sheight = height;
            return this;
        }

        public StreamDesc setActivities() {
            this.sactivities.clear();
            if (StreamType.WEBCAM == this.type) {
                if (Client.this.hasActivity(Activity.AUDIO)) {
                    this.sactivities.add(Activity.AUDIO);
                }
                if (Client.this.hasActivity(Activity.VIDEO)) {
                    this.sactivities.add(Activity.VIDEO);
                }
            }
            if (StreamType.SCREEN == this.type) {
                this.sactivities.add(Activity.SCREEN);
            }
            return this;
        }

        public boolean hasActivity(Activity a) {
            return this.sactivities.contains((Object)a);
        }

        public void addActivity(Activity a) {
            this.sactivities.add(a);
        }

        public StreamDesc removeActivity(Activity a) {
            this.sactivities.remove((Object)a);
            return this;
        }

        public Client getClient() {
            return Client.this;
        }

        public List<Activity> getActivities() {
            return List.copyOf(this.sactivities);
        }

        public JSONObject toJson() {
            return this.toJson(false);
        }

        public JSONObject toJson(boolean self) {
            JSONObject o = new JSONObject().put("uid", (Object)this.uuid).put("type", (Object)this.type.name()).put("width", this.swidth).put("height", this.sheight).put("activities", (Object)new JSONArray(this.sactivities)).put("cuid", (Object)Client.this.uid);
            if (self) {
                o.put("cam", Client.this.cam).put("mic", Client.this.mic);
            }
            return Client.this.addUserJson(o);
        }

        public String toString() {
            return String.format("Stream[uid=%s,type=%s,activities=%s]", new Object[]{Client.this.uid, this.type, this.sactivities});
        }
    }

    public static enum StreamType {
        WEBCAM,
        SCREEN;

    }

    public static enum Activity {
        AUDIO,
        VIDEO,
        AUDIO_VIDEO,
        SCREEN,
        RECORD;

    }
}

