/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.DaoHelper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class GroupUserDao
implements IDataProviderDao<GroupUser> {
    private static final String[] searchFields = new String[]{"user.lastname", "user.firstname", "user.login", "user.address.email"};
    private static final String PARAM_GROUPID = "groupId";
    @PersistenceContext
    private EntityManager em;

    @Override
    public GroupUser get(Long id) {
        return (GroupUser)this.em.createNamedQuery("getGroupUsersById", GroupUser.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<GroupUser> get(long start, long count) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public List<GroupUser> get(String search, long start, long count, String sort) {
        throw DaoHelper.UNSUPPORTED;
    }

    public List<GroupUser> get(long groupId, String search, long start, long count, String sort) {
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery(GroupUser.class.getSimpleName(), "ou", null, search, false, false, "ou.group.id = :groupId", sort, searchFields), GroupUser.class).setParameter(PARAM_GROUPID, (Object)groupId), start, count).getResultList();
    }

    public List<GroupUser> get(long groupId, long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getGroupUsersByGroupId", GroupUser.class).setParameter("id", (Object)groupId), start, count).getResultList();
    }

    public GroupUser getByGroupAndUser(Long groupId, Long userId) {
        return (GroupUser)DaoHelper.single(this.em.createNamedQuery("isUserInGroup", GroupUser.class).setParameter(PARAM_GROUPID, (Object)groupId).setParameter("userId", (Object)userId).getResultList());
    }

    public boolean isUserInGroup(long groupId, long userId) {
        return !this.em.createNamedQuery("isUserInGroup", GroupUser.class).setParameter(PARAM_GROUPID, (Object)groupId).setParameter("userId", (Object)userId).getResultList().isEmpty();
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        return (Long)this.em.createQuery(DaoHelper.getSearchQuery(GroupUser.class.getSimpleName(), "ou", search, false, true, null, searchFields), Long.class).getSingleResult();
    }

    public long count(long groupId) {
        return (Long)this.em.createNamedQuery("countGroupUsers", Long.class).setParameter("id", (Object)groupId).getSingleResult();
    }

    @Override
    public GroupUser update(GroupUser entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public void delete(GroupUser entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    public long getGroupUserCountAddedAfter(Long id, Date date) {
        return (Long)this.em.createNamedQuery("getGroupUserCountAddedAfter", Long.class).setParameter("id", (Object)id).setParameter("inserted", (Object)date).getSingleResult();
    }

    public List<User> getGroupModerators(Long id) {
        return this.em.createNamedQuery("getGroupModerators", User.class).setParameter("id", (Object)id).getResultList();
    }
}

