/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.calendar;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class MeetingMemberDao {
    private static final Logger log = LoggerFactory.getLogger(MeetingMemberDao.class);
    @PersistenceContext
    private EntityManager em;

    public MeetingMember get(Long id) {
        List list = this.em.createNamedQuery("getMeetingMemberById", MeetingMember.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (MeetingMember)list.get(0) : null;
    }

    public List<MeetingMember> get() {
        return this.em.createNamedQuery("getMeetingMembers", MeetingMember.class).getResultList();
    }

    public Set<Long> getMeetingMemberIdsByAppointment(Long appointmentId) {
        log.debug("getMeetingMemberIdsByAppointment: {}", (Object)appointmentId);
        return new HashSet<Long>(this.em.createNamedQuery("getMeetingMemberIdsByAppointment", Long.class).setParameter("id", (Object)appointmentId).getResultList());
    }

    public MeetingMember update(MeetingMember meetingMember) {
        if (meetingMember.getId() == null) {
            this.em.persist((Object)meetingMember);
        } else if (!this.em.contains((Object)meetingMember)) {
            meetingMember = (MeetingMember)this.em.merge((Object)meetingMember);
        }
        return meetingMember;
    }
}

