/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.bind.adapter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class LocalDateAdapter
extends XmlAdapter<String, LocalDate> {
    public String marshal(LocalDate v) throws Exception {
        return v.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public LocalDate unmarshal(String v) throws Exception {
        if (v == null || "null".equals(v)) {
            return null;
        }
        try {
            return LocalDate.parse(v, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (Exception exception) {
            try {
                Long t = Long.valueOf(v);
                if (t != null) {
                    return Instant.ofEpochMilli(t).atZone(ZoneOffset.UTC).toLocalDate();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }
}

