/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.bind.adapter;

import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.IDataProviderEntity;

public abstract class EntityAdapter<E extends IDataProviderEntity>
extends XmlAdapter<String, E> {
    private final IDataProviderDao<E> dao;
    private final Map<Long, Long> idMap;

    protected EntityAdapter() {
        this(null, null);
    }

    protected EntityAdapter(IDataProviderDao<E> dao, Map<Long, Long> idMap) {
        this.dao = dao;
        this.idMap = idMap;
    }

    public String marshal(E v) throws Exception {
        return "" + v.getId();
    }

    public E unmarshal(String v) throws Exception {
        long oldId = NumberUtils.toLong((String)v);
        Long newId = this.idMap.containsKey(oldId) ? this.idMap.get(oldId) : oldId;
        E r = this.dao.get(newId);
        return r == null ? this.newEntity() : r;
    }

    protected abstract E newEntity();
}

