/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.settings;

import de.agilecoders.wicket.core.markup.html.themes.bootstrap.BootstrapTheme;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;

public class DefaultThemeProvider
implements ThemeProvider {
    private final List<ITheme> themes = Generics2.newArrayList((Object[])new ITheme[0]);
    private ITheme defaultTheme;

    public DefaultThemeProvider() {
        this.addDefaultTheme(new BootstrapTheme());
    }

    public DefaultThemeProvider add(ITheme ... themes) {
        this.assertNoDuplicateNames(themes);
        this.themes.addAll(List.of(themes));
        return this;
    }

    private void assertNoDuplicateNames(ITheme ... themes) {
        if (themes == null) {
            throw new WicketRuntimeException("list of themes is null");
        }
        for (ITheme newTheme : themes) {
            if (newTheme == null) {
                throw new WicketRuntimeException("theme is null");
            }
            for (ITheme existingTheme : this.themes) {
                if (existingTheme.equals(newTheme)) {
                    throw new WicketRuntimeException("duplicated theme entry: " + newTheme.name());
                }
                if (!newTheme.name().equalsIgnoreCase(existingTheme.name())) continue;
                throw new WicketRuntimeException("duplicated theme name: " + newTheme.name());
            }
        }
    }

    public DefaultThemeProvider addDefaultTheme(ITheme theme) {
        this.add(theme);
        return this.defaultTheme(theme);
    }

    public DefaultThemeProvider defaultTheme(ITheme newDefaultTheme) {
        if (newDefaultTheme != null && !newDefaultTheme.equals(this.defaultTheme)) {
            this.defaultTheme = newDefaultTheme;
        }
        return this;
    }

    public DefaultThemeProvider defaultTheme(String themeName) {
        ITheme newDefaultTheme = this.byName(themeName);
        return this.defaultTheme(newDefaultTheme);
    }

    @Override
    public ITheme byName(String name) {
        if (!Strings.isEmpty((CharSequence)name)) {
            for (ITheme theme : this.themes) {
                if (!name.equalsIgnoreCase(theme.name())) continue;
                return theme;
            }
        }
        throw new WicketRuntimeException("theme does not exists: " + name);
    }

    @Override
    public List<ITheme> available() {
        return Collections.unmodifiableList(this.themes);
    }

    @Override
    public ITheme defaultTheme() {
        return this.defaultTheme;
    }
}

