/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.record;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.record.RecordingChunkDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class VideoInfo
extends Panel {
    private static final long serialVersionUID = 1L;
    private final Form<Void> form = new Form("form");
    private final Label dateLbl = new Label("recordEnd", (IModel)Model.of((Serializable)((Object)"")));
    private final Label roomNameLbl = new Label("roomName", (IModel)Model.of((Serializable)((Object)"")));
    @SpringBean
    private RoomDao roomDao;
    @SpringBean
    private RecordingChunkDao chunkDao;

    public VideoInfo(String id) {
        super(id);
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)new Recording()));
    }

    public VideoInfo update(AjaxRequestTarget target, BaseFileItem file) {
        if (file instanceof Recording) {
            Recording r = (Recording)file;
            this.setDefaultModelObject(file);
            try {
                Room room;
                String name = null;
                if (r.getRoomId() != null && (room = this.roomDao.get(r.getRoomId())) != null) {
                    name = room.getName();
                }
                this.dateLbl.setDefaultModelObject((Object)WebSession.getDateFormat().format(r.getRecordEnd()));
                this.roomNameLbl.setDefaultModelObject((Object)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (target != null) {
            target.add(new Component[]{this.form});
        }
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.form.setOutputMarkupId(true)});
        this.form.add(new Component[]{new Label("name"), new Label("duration"), this.dateLbl, this.roomNameLbl});
        this.update(null, null);
    }
}

