/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import java.io.Serializable;
import java.util.Locale;
import org.apache.openmeetings.db.dao.user.UserContactDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.LocaleHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.ProfileImagePanel;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class UserProfilePanel
extends UserBasePanel {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer address = new WebMarkupContainer("address");
    private final Label addressDenied = new Label("addressDenied", (Serializable)((Object)""));
    private final WebMarkupContainer infoPanel = new WebMarkupContainer("info-panel");
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private UserContactDao contactDao;

    public UserProfilePanel(String id, long userId) {
        super(id);
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)((User)this.userDao.get(userId))));
    }

    protected void onInitialize() {
        User u = (User)this.getDefaultModelObject();
        this.infoPanel.add(new Component[]{new ProfileImagePanel("img", u.getId())});
        this.infoPanel.add(new Component[]{new Label("firstname")});
        this.infoPanel.add(new Component[]{new Label("lastname")});
        this.infoPanel.add(new Component[]{new Label("timeZoneId")});
        this.infoPanel.add(new Component[]{new Label("regdate")});
        this.infoPanel.add(new Component[]{new TextArea("userOffers").setEnabled(false)});
        this.infoPanel.add(new Component[]{new TextArea("userSearchs").setEnabled(false)});
        if (WebSession.getUserId().equals(u.getId()) || u.isShowContactData() || u.isShowContactDataToContacts() && this.contactDao.isContact(u.getId(), WebSession.getUserId())) {
            this.addressDenied.setVisible(false);
            this.address.add(new Component[]{new Label("address.phone")});
            this.address.add(new Component[]{new Label("address.street")});
            this.address.add(new Component[]{new Label("address.additionalname")});
            this.address.add(new Component[]{new Label("address.zip")});
            this.address.add(new Component[]{new Label("address.town")});
            this.address.add(new Component[]{new Label("country", (Serializable)((Object)LocaleHelper.getCountryName((String)u.getAddress().getCountry(), (Locale)this.getLocale())))});
            this.address.add(new Component[]{new Label("address.comment")});
        } else {
            this.address.setVisible(false);
            this.addressDenied.setDefaultModelObject((Object)this.getString(u.isShowContactDataToContacts() ? "1269" : "1268"));
        }
        this.infoPanel.add(new Component[]{this.address.setDefaultModel(this.getDefaultModel())});
        this.infoPanel.add(new Component[]{this.addressDenied});
        this.add(new Component[]{this.infoPanel.setOutputMarkupId(true)});
        super.onInitialize();
    }
}

