/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.wb;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.github.openjson.JSONStringer;
import com.github.openjson.JSONTokener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dto.room.Whiteboard;
import org.apache.openmeetings.db.dto.room.Whiteboards;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.util.NullStringer;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.WhiteboardManager;
import org.apache.openmeetings.web.common.NameDialog;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.wb.AbstractWbPanel;
import org.apache.openmeetings.web.room.wb.UndoObject;
import org.apache.openmeetings.web.room.wb.WbAction;
import org.apache.openmeetings.web.room.wb.WbWebSocketHelper;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WbPanel
extends AbstractWbPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WbPanel.class);
    private static final String PARAM_UPDATED = "updated";
    private static final int UPLOAD_WB_LEFT = 0;
    private static final int UPLOAD_WB_TOP = 0;
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private static final int UNDO_SIZE = 20;
    public static final ResourceReference WB_JS_REFERENCE = new JavaScriptResourceReference(WbPanel.class, "wb.js");
    private final Long roomId;
    private long wb2save = -1L;
    private final Map<Long, Deque<UndoObject>> undoList = new HashMap<Long, Deque<UndoObject>>();
    private final NameDialog fileName = new NameDialog("filename"){
        private static final long serialVersionUID = 1L;

        @Override
        protected void onSubmit(AjaxRequestTarget target) {
            String res = WbPanel.this.saveWb(WbPanel.this.roomId, WbPanel.this.wb2save, (String)this.getModelObject());
            if (!Strings.isEmpty((String)res)) {
                this.error((Serializable)((Object)("Unexpected error while saving WB: " + res)));
                target.add(new Component[]{this.feedback});
            } else {
                super.onSubmit(target);
            }
        }

        @Override
        protected IModel<String> getTitle() {
            return new ResourceModel("199");
        }

        @Override
        protected IModel<String> getLabel() {
            return new ResourceModel("200");
        }

        @Override
        protected IModel<String> getAddBtnLabel() {
            return new ResourceModel("144");
        }
    };
    private final SerializableConsumer<Whiteboard> addUndo = (SerializableConsumer & Serializable)wb -> {
        JSONArray arr = WbPanel.getArray(wb.toJson(), null);
        if (arr.length() != 0) {
            this.addUndo(wb.getId(), new UndoObject(UndoObject.Type.remove, arr));
        }
    };
    @SpringBean
    private WhiteboardManager wbm;
    @SpringBean
    private FileItemDao fileDao;

    public WbPanel(String id, RoomPanel rp) {
        super(id, rp);
        this.roomId = rp.getRoom().getId();
        if (rp.getRoom().isHidden(Room.RoomElement.WHITEBOARD)) {
            this.setVisible(false);
        } else {
            this.add(new Component[]{new ListView<String>("clipart", List.of(OmFileHelper.getPublicClipartsDir().list()).stream().sorted().collect(Collectors.toList())){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<String> item) {
                    String cls = String.format("clipart-%s", item.getIndex());
                    item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)cls)), AttributeModifier.append((String)"data-mode", (Serializable)((Object)cls)), AttributeModifier.append((String)"data-image", (Serializable)((Serializable)item.getModelObject())).setSeparator("")});
                }
            }, this.fileName});
        }
    }

    @Override
    void internalWbLoad(StringBuilder sb) {
        Long langId = this.rp.getClient().getUser().getLanguageId();
        Map<Long, List<BaseFileItem>> files = this.wbm.get(this.rp.getRoom(), langId);
        for (Map.Entry<Long, List<BaseFileItem>> e : files.entrySet()) {
            for (BaseFileItem fi : e.getValue()) {
                this.sendFileToWb(e.getKey(), fi, false);
            }
        }
        Whiteboards wbs = this.wbm.get(this.roomId, langId);
        this.loadWhiteboards(sb, this.rp.getClient(), wbs, this.wbm.list(this.roomId));
        JSONObject wbj = WbWebSocketHelper.getWbJson(wbs.getActiveWb());
        sb.append("WbArea.activateWb(").append(wbj).append(");");
        Whiteboard wb = wbs.get(Long.valueOf(wbs.getActiveWb()));
        if (wb != null) {
            sb.append("WbArea.setSlide(").append(wbj.put("slide", wb.getSlide())).append(");");
        }
        sb.append("WbArea.loadVideos();");
    }

    @Override
    public void reloadWb(IPartialPageRequestHandler handler) {
        StringBuilder sb = new StringBuilder("WbArea.doCleanAll();");
        this.internalWbLoad(sb);
        handler.appendJavaScript((CharSequence)sb);
    }

    @Override
    public void processWbAction(WbAction a, JSONObject obj, IPartialPageRequestHandler handler) throws IOException {
        Client c = this.rp.getClient();
        if (c == null) {
            return;
        }
        switch (a) {
            case CREATE_OBJ: 
            case MODIFY_OBJ: {
                JSONObject o = obj.optJSONObject("obj");
                if (o == null || !"pointer".equals(o.getString("omType"))) break;
                this.sendWbOthers(a, obj);
                return;
            }
            case DOWNLOAD: {
                boolean moder = c.hasRight(Room.Right.MODERATOR);
                Room r = this.rp.getRoom();
                if (moder && !r.isHidden(Room.RoomElement.ACTION_MENU)) {
                    this.rp.startDownload(handler, obj.getString("type"), obj.getString("fuid"));
                }
                return;
            }
            case LOAD_VIDEOS: {
                StringBuilder sb = new StringBuilder("WbArea.initVideos(");
                JSONArray arr2 = new JSONArray();
                for (Map.Entry<Long, Whiteboard> entry : this.wbm.list(this.roomId)) {
                    Whiteboard wb2 = entry.getValue();
                    for (JSONObject o : wb2.list()) {
                        JSONObject status;
                        String ft = o.optString("fileType");
                        if (!BaseFileItem.Type.RECORDING.name().equals(ft) && !BaseFileItem.Type.VIDEO.name().equals(ft) || (status = o.optJSONObject("status")) == null) continue;
                        JSONObject sts = new JSONObject(status.toString());
                        sts.put("pos", sts.getDouble("pos") + (double)(System.currentTimeMillis() - sts.getLong(PARAM_UPDATED)) * 1.0 / 1000.0);
                        arr2.put((Object)new JSONObject().put("wbId", wb2.getId()).put("uid", (Object)o.getString("uid")).put("slide", (Object)o.getString("slide")).put("status", (Object)sts));
                    }
                }
                sb.append(arr2.toString()).append(");");
                handler.appendJavaScript((CharSequence)sb);
                return;
            }
        }
        if (c.hasRight(Room.Right.PRESENTER)) {
            switch (a) {
                case CREATE_WB: {
                    Whiteboard wb3 = this.wbm.add(this.roomId, c.getUser().getLanguageId());
                    this.sendWbAll(WbAction.CREATE_WB, wb3.getAddJson());
                    break;
                }
                case REMOVE_WB: {
                    long id = obj.optLong("wbId", -1L);
                    if (id <= -1L) break;
                    long prevId = obj.optLong("prevWbId", -1L);
                    this.wbm.remove(this.roomId, id, prevId);
                    this.sendWbAll(WbAction.REMOVE_WB, obj);
                    break;
                }
                case ACTIVATE_WB: {
                    long wbId = obj.optLong("wbId", -1L);
                    if (wbId <= -1L) break;
                    this.wbm.activate(this.roomId, wbId);
                    this.sendWbAll(WbAction.ACTIVATE_WB, obj);
                    break;
                }
                case RENAME_WB: {
                    Whiteboard wb3 = this.wbm.get(this.roomId).get(Long.valueOf(obj.optLong("wbId", -1L)));
                    if (wb3 == null) break;
                    this.wbm.update(this.roomId, wb3.setName(obj.getString("name")));
                    this.sendWbAll(WbAction.RENAME_WB, obj);
                    break;
                }
                case SET_SLIDE: {
                    Whiteboard wb3 = this.wbm.get(this.roomId).get(Long.valueOf(obj.optLong("wbId", -1L)));
                    if (wb3 == null) break;
                    wb3.setSlide(obj.optInt("slide", 0));
                    this.wbm.update(this.roomId, wb3);
                    this.sendWbOthers(WbAction.SET_SLIDE, obj);
                    break;
                }
                case CLEAR_ALL: {
                    this.wbm.clearAll(this.roomId, obj.getLong("wbId"), (Consumer<Whiteboard>)this.addUndo);
                    break;
                }
                case SET_SIZE: {
                    Whiteboard wb3 = this.wbm.get(this.roomId).get(Long.valueOf(obj.getLong("wbId")));
                    wb3.setWidth(obj.getInt("width"));
                    wb3.setHeight(obj.getInt("height"));
                    wb3.setZoom(obj.getDouble("zoom"));
                    wb3.setZoomMode(Whiteboard.ZoomMode.valueOf((String)obj.getString("zoomMode")));
                    this.wbm.update(this.roomId, wb3);
                    this.sendWbOthers(WbAction.SET_SIZE, wb3.getAddJson());
                    break;
                }
            }
        }
        if (c.hasRight(Room.Right.PRESENTER) || c.hasRight(Room.Right.WHITEBOARD)) {
            switch (a) {
                case CREATE_OBJ: {
                    Whiteboard wb4 = this.wbm.get(this.roomId).get(Long.valueOf(obj.getLong("wbId")));
                    JSONObject o = obj.getJSONObject("obj");
                    wb4.put(o.getString("uid"), o);
                    this.wbm.update(this.roomId, wb4);
                    this.addUndo(wb4.getId(), new UndoObject(UndoObject.Type.add, o));
                    this.sendWbOthers(WbAction.CREATE_OBJ, obj);
                    break;
                }
                case MODIFY_OBJ: {
                    Whiteboard wb5 = this.wbm.get(this.roomId).get(Long.valueOf(obj.getLong("wbId")));
                    JSONArray arr3 = obj.getJSONArray("obj");
                    JSONArray undo = new JSONArray();
                    for (int i = 0; i < arr3.length(); ++i) {
                        JSONObject oi = arr3.getJSONObject(i);
                        String uid = oi.getString("uid");
                        JSONObject po = wb5.get(uid);
                        if (po == null) continue;
                        undo.put((Object)po);
                        wb5.put(uid, oi);
                    }
                    if (arr3.length() != 0) {
                        this.wbm.update(this.roomId, wb5);
                        this.addUndo(wb5.getId(), new UndoObject(UndoObject.Type.modify, undo));
                    }
                    this.sendWbOthers(WbAction.MODIFY_OBJ, obj);
                    break;
                }
                case DELETE_OBJ: {
                    Whiteboard wb6 = this.wbm.get(this.roomId).get(Long.valueOf(obj.getLong("wbId")));
                    JSONArray arr4 = obj.getJSONArray("obj");
                    JSONArray undo = new JSONArray();
                    for (int i = 0; i < arr4.length(); ++i) {
                        JSONObject oi = arr4.getJSONObject(i);
                        JSONObject u = wb6.remove((Object)oi.getString("uid"));
                        if (u == null) continue;
                        undo.put((Object)u);
                    }
                    if (undo.length() != 0) {
                        this.wbm.update(this.roomId, wb6);
                        this.addUndo(wb6.getId(), new UndoObject(UndoObject.Type.remove, undo));
                    }
                    this.sendWbAll(WbAction.DELETE_OBJ, obj);
                    break;
                }
                case CLEAR_SLIDE: {
                    this.wbm.cleanSlide(this.roomId, obj.getLong("wbId"), obj.getInt("slide"), (wb, arr) -> this.addUndo(wb.getId(), new UndoObject(UndoObject.Type.remove, (JSONArray)arr)));
                    break;
                }
                case SAVE: {
                    this.wb2save = obj.getLong("wbId");
                    this.fileName.show(handler);
                    break;
                }
                case UNDO: {
                    Long wbId = obj.getLong("wbId");
                    UndoObject uo = this.getUndo(wbId);
                    if (uo != null) {
                        Whiteboard wb7 = this.wbm.get(this.roomId).get(wbId);
                        switch (uo.getType()) {
                            case add: {
                                JSONObject o = new JSONObject(uo.getObject());
                                wb7.remove((Object)o.getString("uid"));
                                this.wbm.update(this.roomId, wb7);
                                this.sendWbAll(WbAction.DELETE_OBJ, obj.put("obj", (Object)new JSONArray().put((Object)o)));
                                break;
                            }
                            case remove: {
                                JSONArray arr5 = new JSONArray(uo.getObject());
                                for (int i = 0; i < arr5.length(); ++i) {
                                    JSONObject o = arr5.getJSONObject(i);
                                    wb7.put(o.getString("uid"), o);
                                }
                                this.wbm.update(this.roomId, wb7);
                                this.sendWbAll(WbAction.CREATE_OBJ, obj.put("obj", (Object)new JSONArray(uo.getObject())));
                                break;
                            }
                            case modify: {
                                JSONArray arr6 = new JSONArray(uo.getObject());
                                for (int i = 0; i < arr6.length(); ++i) {
                                    JSONObject o = arr6.getJSONObject(i);
                                    wb7.put(o.getString("uid"), o);
                                }
                                this.wbm.update(this.roomId, wb7);
                                this.sendWbAll(WbAction.MODIFY_OBJ, obj.put("obj", (Object)arr6));
                            }
                        }
                    }
                    break;
                }
                case VIDEO_STATUS: {
                    Whiteboard wb8 = this.wbm.get(this.roomId).get(Long.valueOf(obj.getLong("wbId")));
                    String uid = obj.getString("uid");
                    JSONObject po = wb8.get(uid);
                    if (po == null || !"Video".equals(po.getString("omType"))) break;
                    JSONObject ns = obj.getJSONObject("status");
                    po.put("status", (Object)ns.put(PARAM_UPDATED, System.currentTimeMillis()));
                    this.wbm.update(this.roomId, wb8.put(uid, po));
                    obj.put("slide", po.getInt("slide"));
                    this.sendWbAll(WbAction.VIDEO_STATUS, obj);
                    break;
                }
            }
        }
    }

    @Override
    protected String getRole() {
        String role = "NONE";
        if (this.rp.getClient().hasRight(Room.Right.PRESENTER)) {
            role = Room.Right.PRESENTER.name();
        } else if (this.rp.getClient().hasRight(Room.Right.WHITEBOARD)) {
            role = Room.Right.WHITEBOARD.name();
        }
        return role;
    }

    private JSONObject addFileUrl(Client cl, String ruid, JSONObject file) {
        return this.addFileUrl(cl, ruid, file, null);
    }

    private JSONObject addFileUrl(Client cl, String ruid, JSONObject file, Consumer<BaseFileItem> consumer) {
        try {
            BaseFileItem fi;
            long fid = file.optLong("fileId", -1L);
            if (fid > 0L && (fi = this.fileDao.getAny(Long.valueOf(fid))) != null) {
                if (consumer != null) {
                    consumer.accept(fi);
                }
                return WbWebSocketHelper.addFileUrl(ruid, file, fi, cl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    private static JSONArray getArray(JSONObject wb, Function<JSONObject, JSONObject> postprocess) {
        JSONObject items = wb.getJSONObject("roomItems");
        JSONArray arr = new JSONArray();
        for (String uid : items.keySet()) {
            JSONObject o = items.getJSONObject(uid);
            if (postprocess != null) {
                o = postprocess.apply(o);
            }
            arr.put((Object)o);
        }
        return arr;
    }

    private static void updateWbSize(Whiteboard wb, BaseFileItem fi) {
        int w = fi.getWidth() == null ? 640 : fi.getWidth();
        int h = fi.getHeight() == null ? 480 : fi.getHeight();
        double scale = 1.0 * (double)wb.getWidth() / (double)w;
        scale = scale < 1.0 ? 1.0 : scale;
        wb.setWidth(Math.max(wb.getWidth(), (int)((double)w * scale)));
        wb.setHeight(Math.max(wb.getHeight(), (int)((double)h * scale)));
    }

    private void sendFileToWb(Long wbId, BaseFileItem fi, boolean clean) {
        if (this.isVisible() && fi.getId() != null) {
            Whiteboards wbs = this.wbm.get(this.roomId);
            String wuid = UUID.randomUUID().toString();
            Whiteboard wb = wbs.get(Long.valueOf(wbId == null ? wbs.getActiveWb() : wbId.longValue()));
            if (wb == null) {
                return;
            }
            switch (fi.getType()) {
                case FOLDER: {
                    break;
                }
                case WML_FILE: {
                    File f = fi.getFile();
                    if (!f.exists() || !f.isFile()) break;
                    try (BufferedReader br = Files.newBufferedReader(f.toPath());){
                        boolean[] updated = new boolean[]{false};
                        JSONArray arr = WbPanel.getArray(new JSONObject(new JSONTokener((Reader)br)), o -> {
                            wb.put(o.getString("uid"), o);
                            updated[0] = true;
                            return this.addFileUrl(this.rp.getClient(), wbs.getUid(), (JSONObject)o, bf -> WbPanel.updateWbSize(wb, bf));
                        });
                        if (updated[0]) {
                            this.wbm.update(this.roomId, wb);
                        }
                        this.sendWbAll(WbAction.SET_SIZE, wb.getAddJson());
                        this.sendWbAll(WbAction.LOAD, WbWebSocketHelper.getObjWbJson(wb.getId(), arr));
                    }
                    catch (Exception e) {
                        log.error("Unexpected error while loading WB", (Throwable)e);
                    }
                    break;
                }
                case POLL_CHART: {
                    break;
                }
                default: {
                    JSONObject file = new JSONObject().put("fileId", (Object)fi.getId()).put("fileType", (Object)fi.getType().name()).put("count", fi.getCount()).put("type", (Object)"image").put("left", 0).put("top", 0).put("width", fi.getWidth() == null ? 640 : fi.getWidth()).put("height", fi.getHeight() == null ? 480 : fi.getHeight()).put("uid", (Object)wuid).put("slide", wb.getSlide());
                    if (BaseFileItem.Type.VIDEO == fi.getType() || BaseFileItem.Type.RECORDING == fi.getType()) {
                        file.put("omType", (Object)"Video");
                        file.put("status", (Object)new JSONObject().put("paused", true).put("pos", 0.0).put(PARAM_UPDATED, System.currentTimeMillis()));
                    }
                    String ruid = wbs.getUid();
                    if (clean) {
                        this.wbm.clearAll(this.roomId, wb.getId(), (Consumer<Whiteboard>)this.addUndo);
                    }
                    wb.put(wuid, file);
                    WbPanel.updateWbSize(wb, fi);
                    this.wbm.update(this.roomId, wb);
                    this.sendWbAll(WbAction.SET_SIZE, wb.getAddJson());
                    WbWebSocketHelper.sendWbFile(this.roomId, wb.getId(), ruid, file, fi);
                }
            }
        }
    }

    @Override
    public void sendFileToWb(BaseFileItem fi, boolean clean) {
        this.sendFileToWb(null, fi, clean);
    }

    private void sendWbOthers(WbAction a, JSONObject obj) {
        WbWebSocketHelper.sendWbOthers(this.roomId, a, obj, this.rp.getClient().getUid());
    }

    private void sendWbAll(WbAction a, JSONObject obj) {
        WbWebSocketHelper.sendWbAll(this.roomId, a, obj);
    }

    private void addUndo(Long wbId, UndoObject u) {
        if (wbId == null) {
            return;
        }
        this.undoList.computeIfAbsent(wbId, id -> new LimitedLinkedList()).push(u);
    }

    private UndoObject getUndo(Long wbId) {
        if (wbId == null || !this.undoList.containsKey(wbId)) {
            return null;
        }
        Deque<UndoObject> deq = this.undoList.get(wbId);
        return deq.isEmpty() ? null : deq.pop();
    }

    public String saveWb(Long roomId, Long wbId, String name) {
        Whiteboard wb = this.wbm.get(roomId).get(wbId);
        FileItem f = new FileItem();
        f.setType(BaseFileItem.Type.WML_FILE);
        f.setRoomId(roomId);
        f.setHash(UUID.randomUUID().toString());
        f.setName(name);
        f = this.fileDao.update(f);
        return wb.save(f.getFile().toPath());
    }

    private StringBuilder loadWhiteboards(StringBuilder sb, Client cl, Whiteboards wbs, Set<Map.Entry<Long, Whiteboard>> boardSet) {
        for (Map.Entry<Long, Whiteboard> entry : boardSet) {
            Whiteboard wb = entry.getValue();
            sb.append((CharSequence)new StringBuilder("WbArea.create(").append(wb.getAddJson()).append(");"));
            JSONArray arr = new JSONArray();
            for (JSONObject o : wb.list()) {
                arr.put((Object)this.addFileUrl(cl, wbs.getUid(), o));
            }
            sb.append("WbArea.load(").append(WbWebSocketHelper.getObjWbJson(entry.getKey(), arr).toString((JSONStringer)new NullStringer())).append(");");
        }
        return sb;
    }

    private static class LimitedLinkedList<T>
    extends LinkedList<T> {
        private static final long serialVersionUID = 1L;

        private LimitedLinkedList() {
        }

        @Override
        public void push(T e) {
            super.push(e);
            while (this.size() > 20) {
                this.removeLast();
            }
        }
    }
}

