/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.sidebar;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dto.record.RecordingContainerData;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.NameDialog;
import org.apache.openmeetings.web.common.tree.FileTreePanel;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class RoomFilePanel
extends FileTreePanel {
    private static final long serialVersionUID = 1L;
    private final RoomPanel room;
    @SpringBean
    private FileItemDao fileDao;
    @SpringBean
    private RecordingDao recDao;

    public RoomFilePanel(String id, RoomPanel room, NameDialog addFolder) {
        super(id, room.getRoom().getId(), addFolder);
        this.room = room;
    }

    @Override
    public void updateSizes() {
        RecordingContainerData sizeData = this.recDao.getContainerData(WebSession.getUserId().longValue());
        long userSize = this.fileDao.getOwnSize(WebSession.getUserId());
        long roomSize = this.fileDao.getRoomSize(this.room.getRoom().getId());
        if (sizeData != null) {
            userSize += sizeData.getUserHomeSize();
            roomSize += sizeData.getPublicFileSize();
        }
        this.homeSize.setObject((Object)OmFileHelper.getHumanSize((long)userSize));
        this.publicSize.setObject((Object)OmFileHelper.getHumanSize((long)roomSize));
    }

    @Override
    protected void update(AjaxRequestTarget target, BaseFileItem f) {
    }

    @Override
    protected String getContainment() {
        return "";
    }

    @Override
    protected Component getUpload() {
        return super.getUpload().setVisible(true).add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> this.room.getSidebar().showUpload((IPartialPageRequestHandler)target))});
    }
}

