/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.poll;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.room.PollDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.RoomPoll;
import org.apache.openmeetings.db.entity.room.RoomPollAnswer;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class VoteDialog
extends Modal<RoomPollAnswer> {
    private static final long serialVersionUID = 1L;
    private static final List<Integer> answers = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10));
    private PollAnswerForm form;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final Label userLbl = new Label("user", (IModel)Model.of((Serializable)((Object)"")));
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private PollDao pollDao;

    public VoteDialog(String id) {
        super(id);
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("18"));
        this.setCloseOnEscapeKey(false);
        this.setBackdrop(Modal.Backdrop.STATIC);
        Component[] componentArray = new Component[1];
        this.form = new PollAnswerForm("form", (IModel<RoomPollAnswer>)new CompoundPropertyModel((Object)new RoomPollAnswer()));
        componentArray[0] = this.form;
        this.add(componentArray);
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("32"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                RoomPollAnswer a = (RoomPollAnswer)VoteDialog.this.form.getModelObject();
                Long roomId = a.getRoomPoll().getRoom().getId();
                if (VoteDialog.this.pollDao.notVoted(roomId, WebSession.getUserId())) {
                    a.setVoteDate(new Date());
                    a.getRoomPoll().getAnswers().add(a);
                    VoteDialog.this.pollDao.update(a.getRoomPoll());
                }
                WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(roomId, ((MainPanel)((Object)this.findParent(MainPanel.class))).getClient(), RoomMessage.Type.POLL_UPDATED));
                VoteDialog.this.close((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{VoteDialog.this.feedback});
            }
        });
        this.addButton((Component)OmModalCloseButton.of());
        super.onInitialize();
    }

    static String getName(Component c, User u) {
        return u == null ? "" : (WebSession.getUserId().equals(u.getId()) ? c.getString("1411") : u.getDisplayName());
    }

    public void updateModel(IPartialPageRequestHandler target, RoomPoll rp) {
        RoomPollAnswer a = new RoomPollAnswer();
        a.setRoomPoll(rp);
        User u = this.userDao.get(WebSession.getUserId());
        a.setVotedUser(u);
        this.userLbl.setDefaultModelObject((Object)VoteDialog.getName((Component)this, a.getRoomPoll().getCreator()));
        this.form.setModelObject(a);
        boolean typeNum = a.getRoomPoll() != null && RoomPoll.Type.NUMERIC == a.getRoomPoll().getType();
        this.form.typeBool.setVisible(!typeNum);
        this.form.typeInt.setVisible(typeNum);
        target.add(new Component[]{this.form});
    }

    private class PollAnswerForm
    extends Form<RoomPollAnswer> {
        private static final long serialVersionUID = 1L;
        private final WebMarkupContainer typeBool;
        private final WebMarkupContainer typeInt;

        PollAnswerForm(String id, IModel<RoomPollAnswer> model) {
            super(id, model);
            this.typeBool = new WebMarkupContainer("typeBool");
            this.typeInt = new WebMarkupContainer("typeInt");
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{VoteDialog.this.feedback.setOutputMarkupId(true)});
            this.add(new Component[]{VoteDialog.this.userLbl});
            this.add(new Component[]{new Label("roomPoll.question")});
            this.add(new Component[]{this.typeBool.add(new Component[]{new RadioGroup("answer").setRequired(true).add(new Component[]{new Radio("true", (IModel)Model.of((Serializable)Boolean.TRUE))}).add(new Component[]{new Radio("false", (IModel)Model.of((Serializable)Boolean.FALSE))})}).setOutputMarkupPlaceholderTag(true).setVisible(false)});
            this.add(new Component[]{this.typeInt.add(new Component[]{new DropDownChoice("pointList", answers).setRequired(true)}).setOutputMarkupPlaceholderTag(true).setVisible(false)});
        }
    }
}

