/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages;

import java.io.Serializable;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.basic.WsClient;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.db.util.LocaleHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.IUpdatable;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.common.OmAjaxClientInfoBehavior;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.common.OmWebSocketPanel;
import org.apache.openmeetings.web.pages.BaseInitedPage;
import org.apache.openmeetings.web.pages.InvitationPasswordDialog;
import org.apache.openmeetings.web.room.IconTextModal;
import org.apache.openmeetings.web.room.NetTestPanel;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.VideoSettings;
import org.apache.openmeetings.web.user.record.VideoInfo;
import org.apache.openmeetings.web.user.record.VideoPlayer;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValue;

public class HashPage
extends BaseInitedPage
implements IUpdatable {
    private static final long serialVersionUID = 1L;
    public static final String APP = "app";
    public static final String APP_TYPE_NETWORK = "network";
    public static final String APP_TYPE_SETTINGS = "settings";
    public static final String SWF = "swf";
    public static final String PANEL_MAIN = "panel-main";
    public static final String PANEL_RECORDING = "panel-recording";
    public static final String INVITATION_HASH = "invitation";
    static final String HASH = "secure";
    static final String LANG = "language";
    private final WebMarkupContainer recContainer = new WebMarkupContainer("panel-recording");
    private final VideoInfo vi = new VideoInfo("info");
    private final VideoPlayer vp = new VideoPlayer("player");
    private boolean error = true;
    private MainPanel mp = null;
    private RoomPanel rp = null;
    private final PageParameters p;
    @SpringBean
    private RoomDao roomDao;
    @SpringBean
    private RecordingDao recDao;

    public HashPage(PageParameters p) {
        this.p = p;
    }

    private void createRoom(Long roomId) {
        this.getLoader().setVisible(true);
        this.getHeader().setVisible(false);
        Room room = this.roomDao.get(roomId);
        if (room != null && !room.isDeleted()) {
            this.error = false;
            this.rp = new RoomPanel("child", room);
            this.mp = new MainPanel(PANEL_MAIN, this.rp);
            this.replace((Component)this.mp);
        }
    }

    @Override
    protected void onInitialize() {
        StringValue app;
        super.onInitialize();
        StringValue secure = this.p.get(HASH);
        StringValue invitation = this.p.get(INVITATION_HASH);
        WebSession ws = WebSession.get();
        ws.checkHashes(secure, invitation);
        long lang = this.p.get(LANG).toLong(-1L);
        if (lang > -1L) {
            ws.setLanguage(lang);
            ws.setLocale(LocaleHelper.getLocale((Long)lang));
        }
        String errorMsg = this.getString("invalid.hash");
        this.recContainer.setVisible(false);
        this.add(new Component[]{new EmptyPanel(PANEL_MAIN).setVisible(false)});
        if (!invitation.isEmpty()) {
            Invitation i = ws.getInvitation();
            if (i == null) {
                errorMsg = this.getString("error.hash.invalid");
            } else if (!i.isAllowEntry()) {
                FastDateFormat sdf = FormatHelper.getDateTimeFormat((User)i.getInvitee());
                errorMsg = Invitation.Valid.ONE_TIME == i.getValid() ? this.getString("error.hash.used") : String.format("%s %s - %s, %s", this.getString("error.hash.period"), sdf.format(i.getValidFrom()), sdf.format(i.getValidTo()), i.getInvitee().getTimeZoneId());
            } else {
                Room r;
                Recording rec = i.getRecording();
                if (rec != null) {
                    this.vi.setVisible(!i.isPasswordProtected());
                    this.vp.setVisible(!i.isPasswordProtected());
                    if (!i.isPasswordProtected()) {
                        this.vi.update(null, (BaseFileItem)rec);
                        this.vp.update(null, (BaseFileItem)rec);
                    }
                    this.recContainer.setVisible(true);
                    this.error = false;
                }
                if ((r = i.getRoom()) != null && !r.isDeleted()) {
                    this.createRoom(r.getId());
                    if (i.isPasswordProtected() && this.rp != null) {
                        this.mp.getChat().setVisible(false);
                        this.rp.setOutputMarkupPlaceholderTag(true).setVisible(false);
                    }
                }
            }
        } else if (!secure.isEmpty()) {
            Long recId = WebSession.getRecordingId();
            Long roomId = ws.getRoomId();
            if (recId == null && roomId == null) {
                errorMsg = this.getString("1599");
            } else if (recId != null) {
                this.recContainer.setVisible(true);
                Recording rec = this.recDao.get(recId);
                this.vi.update(null, (BaseFileItem)rec);
                this.vp.update(null, (BaseFileItem)rec);
                this.error = false;
            } else {
                this.createRoom(roomId);
            }
        }
        StringValue swf = this.p.get(SWF);
        StringValue stringValue = app = swf.isEmpty() ? this.p.get(APP) : swf;
        if (!app.isEmpty()) {
            if (APP_TYPE_NETWORK.equals(app.toString())) {
                this.replace(new NetTestPanel(PANEL_MAIN).add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)APP))}));
                this.error = false;
            }
            if (APP_TYPE_SETTINGS.equals(app.toString())) {
                this.replace(new VideoSettings(PANEL_MAIN).replace((Component)new OmWebSocketPanel("ws-panel"){
                    private static final long serialVersionUID = 1L;
                    private WsClient c;
                    {
                        this.c = null;
                    }

                    @Override
                    protected void onConnect(ConnectedMessage message) {
                        this.c = new WsClient(message.getSessionId(), message.getKey().hashCode());
                    }

                    @Override
                    protected void onConnect(WebSocketRequestHandler handler) {
                        super.onConnect(handler);
                        handler.appendJavaScript((CharSequence)String.format("VideoSettings.init(%s);VideoSettings.open();", VideoSettings.getInitJson("noclient").put("infoMsg", (Object)this.getString("close.settings.tab"))));
                    }

                    @Override
                    protected IWsClient getWsClient() {
                        return this.c;
                    }
                }).add(new Behavior[]{new OmAjaxClientInfoBehavior()}));
                this.error = false;
            }
        }
        this.add(new Component[]{this.recContainer.add(new Component[]{this.vi.setOutputMarkupPlaceholderTag(true), this.vp.setOutputMarkupPlaceholderTag(true)}), new InvitationPasswordDialog("i-pass", this)});
        this.remove(new Behavior[]{this.urlParametersReceivingBehavior});
        this.add(new Component[]{new IconTextModal("access-denied").withLabel(errorMsg).withErrorIcon().addButton((Component)OmModalCloseButton.of("54")).header((IModel)new ResourceModel("invalid.hash")).show(this.error)});
    }

    protected void onParameterArrival(IRequestParameters requestParameters, AjaxRequestTarget target) {
    }

    @Override
    public void update(AjaxRequestTarget target) {
        Invitation i = WebSession.get().getInvitation();
        if (i.getRoom() != null && this.rp != null) {
            this.rp.show((IPartialPageRequestHandler)target);
        } else if (i.getRecording() != null) {
            target.add(new Component[]{this.vi.update(target, (BaseFileItem)i.getRecording()).setVisible(true), this.vp.update(target, (BaseFileItem)i.getRecording()).setVisible(true)});
        }
    }
}

