/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.menu;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuDivider;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.Navbar;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarDropDownButton;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class OmMenuItem
implements INavbarComponent {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String desc;
    private final IconType icon;
    private final List<INavbarComponent> items = new ArrayList<INavbarComponent>(0);
    private boolean visible = true;

    public OmMenuItem(String title, String desc) {
        this(title, desc, null, List.of());
    }

    public OmMenuItem(String title, String desc, boolean visible) {
        this(title, desc);
        this.visible = visible;
    }

    public OmMenuItem(String title, List<INavbarComponent> items) {
        this(title, null, null, items);
    }

    public OmMenuItem(String title, String desc, IconType icon) {
        this(title, desc, icon, List.of());
    }

    public OmMenuItem(String title, String desc, IconType icon, List<INavbarComponent> items) {
        this.title = title;
        this.desc = desc;
        this.icon = icon;
        this.items.addAll(items);
    }

    public OmMenuItem add(INavbarComponent item) {
        this.items.add(item);
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public AbstractLink create(String markupId) {
        Object item;
        if (this.items.isEmpty()) {
            item = this.createLink(markupId, true);
        } else {
            item = new NavbarDropDownButton((IModel)Model.of((Serializable)((Object)this.title)), (IModel)Model.of((Serializable)this.icon)){
                private static final long serialVersionUID = 1L;

                protected List<AbstractLink> newSubMenuButtons(String markupId) {
                    return OmMenuItem.this.items.stream().map(mItem -> ((OmMenuItem)mItem).createLink(markupId, false)).collect(Collectors.toList());
                }
            };
            this.setAttributes((Component)item);
        }
        return item;
    }

    private AbstractLink createLink(String markupId, boolean topLevel) {
        if (Strings.isEmpty((String)this.title)) {
            return new MenuDivider();
        }
        NavbarAjaxLink<String> link = new NavbarAjaxLink<String>(markupId, (IModel)Model.of((Serializable)((Object)this.title))){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                OmMenuItem.this.onClick(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                OmMenuItem.this.updateAjaxAttributes(attributes);
            }
        };
        if (topLevel) {
            link.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"nav-link"))});
        }
        this.setAttributes((Component)link);
        return link.setIconType(this.icon);
    }

    private void setAttributes(Component comp) {
        comp.add(new Behavior[]{AttributeModifier.append((String)"title", (Serializable)((Object)this.desc))});
        comp.setVisible(this.visible);
    }

    public Navbar.ComponentPosition getPosition() {
        return Navbar.ComponentPosition.LEFT;
    }

    protected void onClick(AjaxRequestTarget target) {
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }
}

