/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import com.googlecode.wicket.jquery.ui.plugins.wysiwyg.settings.WysiwygLibrarySettings;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.NoopThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import java.io.File;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.websocket.WebSocketContainer;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.core.sip.SipManager;
import org.apache.openmeetings.core.util.ChatWebSocketHelper;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OmVersion;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.ws.IClusterWsMessage;
import org.apache.openmeetings.web.admin.backup.BackupUploadResourceReference;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.LabelResourceLoader;
import org.apache.openmeetings.web.app.OmAuthenticationStrategy;
import org.apache.openmeetings.web.app.UserManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.app.WhiteboardManager;
import org.apache.openmeetings.web.common.PingResourceReference;
import org.apache.openmeetings.web.pages.AccessDeniedPage;
import org.apache.openmeetings.web.pages.ActivatePage;
import org.apache.openmeetings.web.pages.HashPage;
import org.apache.openmeetings.web.pages.InternalErrorPage;
import org.apache.openmeetings.web.pages.MainPage;
import org.apache.openmeetings.web.pages.NotInitedPage;
import org.apache.openmeetings.web.pages.PrivacyPage;
import org.apache.openmeetings.web.pages.ResetPage;
import org.apache.openmeetings.web.pages.auth.SignInPage;
import org.apache.openmeetings.web.pages.install.InstallWizardPage;
import org.apache.openmeetings.web.room.GroupCustomCssResourceReference;
import org.apache.openmeetings.web.room.RoomPreviewResourceReference;
import org.apache.openmeetings.web.room.RoomResourceReference;
import org.apache.openmeetings.web.room.sidebar.RoomFileUploadResourceReference;
import org.apache.openmeetings.web.room.wb.WbWebSocketHelper;
import org.apache.openmeetings.web.user.dashboard.MyRoomsWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.RecentRoomsWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.RssWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.StartWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.WelcomeWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.admin.AdminWidgetDescriptor;
import org.apache.openmeetings.web.user.record.Mp4RecordingResourceReference;
import org.apache.openmeetings.web.user.record.PngRecordingResourceReference;
import org.apache.openmeetings.web.user.rooms.RoomEnterBehavior;
import org.apache.openmeetings.web.util.GroupLogoResourceReference;
import org.apache.openmeetings.web.util.OmUrlFragment;
import org.apache.openmeetings.web.util.ProfileImageResourceReference;
import org.apache.openmeetings.web.util.UserDashboardPersister;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.Localizer;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.core.request.handler.BookmarkableListenerRequestHandler;
import org.apache.wicket.core.request.handler.ListenerRequestHandler;
import org.apache.wicket.core.request.mapper.MountedMapper;
import org.apache.wicket.markup.head.filter.FilteringHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.SerializingPageStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.WebSocketAwareResourceIsolationRequestCycleListener;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.ExceptionSettings;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.validator.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.wicketstuff.dashboard.DashboardContextInitializer;
import org.wicketstuff.dashboard.DashboardPersister;
import org.wicketstuff.dashboard.WidgetDescriptor;
import org.wicketstuff.dashboard.WidgetRegistry;
import org.wicketstuff.dashboard.web.DashboardContext;
import org.wicketstuff.dashboard.web.DashboardSettings;
import org.wicketstuff.datastores.hazelcast.HazelcastDataStore;

@Component
public class Application
extends AuthenticatedWebApplication
implements IApplication {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private static boolean isInstalled;
    private static final String INVALID_SESSIONS_KEY = "INVALID_SESSIONS_KEY";
    private static final String SERVER_CONTAINER_SERVLET_CONTEXT_ATTRIBUTE = "javax.websocket.server.ServerContainer";
    public static final String NAME_ATTR_KEY = "name";
    public static final String SERVER_URL_ATTR_KEY = "server.url";
    static final Set<String> STRINGS_WITH_APP;
    private static String appName;
    public static final String HASH_MAPPING = "/hash";
    public static final String SIGNIN_MAPPING = "/signin";
    public static final String NOTINIT_MAPPING = "/notinited";
    HazelcastInstance hazelcast;
    private ITopic<IClusterWsMessage> hazelWsTopic;
    private String serverId;
    private final Set<String> wsUrls = new HashSet<String>();
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    private ConfigurationDao cfgDao;
    @Autowired
    private RecordingDao recordingDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserManager userManager;
    @Autowired
    private ClientManager cm;
    @Autowired
    private WhiteboardManager wbManager;
    @Autowired
    private AppointmentDao appointmentDao;
    @Autowired
    private SipManager sipManager;
    @Value(value="${remember.me.encryption.key}")
    private String rememberMeKey;
    @Value(value="${remember.me.encryption.salt}")
    private String rememberMeSalt;

    protected void init() {
        OpenmeetingsVariables.setWicketApplicationName((String)super.getName());
        this.getSecuritySettings().setAuthenticationStrategy((IAuthenticationStrategy)new OmAuthenticationStrategy(this.rememberMeKey, this.rememberMeSalt));
        this.getApplicationSettings().setAccessDeniedPage(AccessDeniedPage.class);
        this.getApplicationSettings().setInternalErrorPage(InternalErrorPage.class);
        this.getExceptionSettings().setUnexpectedExceptionDisplay(ExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this, this.ctx, true));
        Config cfg = new XmlConfigBuilder().build();
        cfg.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.hazelcast = Hazelcast.getOrCreateHazelcastInstance((Config)cfg);
        this.serverId = this.hazelcast.getName();
        this.hazelcast.getCluster().getMembers().forEach(m -> this.cm.serverAdded(m.getAttribute(NAME_ATTR_KEY), m.getAttribute(SERVER_URL_ATTR_KEY)));
        this.hazelWsTopic = this.hazelcast.getTopic("default");
        this.hazelWsTopic.addMessageListener(msg -> {
            String mServerId = msg.getPublishingMember().getAttribute(NAME_ATTR_KEY);
            if (mServerId.equals(this.serverId)) {
                return;
            }
            IClusterWsMessage wsMsg = (IClusterWsMessage)msg.getMessageObject();
            if (WbWebSocketHelper.send(wsMsg)) {
                return;
            }
            if (ChatWebSocketHelper.send((IClusterWsMessage)((IClusterWsMessage)msg.getMessageObject()))) {
                return;
            }
            WebSocketHelper.send((IClusterWsMessage)((IClusterWsMessage)msg.getMessageObject()));
        });
        this.hazelcast.getCluster().addMembershipListener(new MembershipListener(){

            public void memberRemoved(MembershipEvent evt) {
                String downId = evt.getMember().getAttribute(Application.NAME_ATTR_KEY);
                Application.this.cm.serverRemoved(downId);
                Application.this.updateJpaAddresses();
            }

            public void memberAdded(MembershipEvent evt) {
                Application.this.updateJpaAddresses();
                HashSet<String> names = new HashSet<String>();
                for (Member m : evt.getMembers()) {
                    if (evt.getMember().getUuid().equals(m.getUuid())) continue;
                    String duplicateId = m.getAttribute(Application.NAME_ATTR_KEY);
                    names.add(duplicateId);
                }
                String newServerId = evt.getMember().getAttribute(Application.NAME_ATTR_KEY);
                log.warn("Name added: {}", (Object)newServerId);
                Application.this.cm.serverAdded(newServerId, evt.getMember().getAttribute(Application.SERVER_URL_ATTR_KEY));
                if (names.contains(newServerId)) {
                    log.warn("Duplicate cluster instance with name {} found {}", (Object)newServerId, (Object)evt.getMember());
                }
            }
        });
        this.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((org.apache.wicket.Application)this){

            protected IPageStore newAsynchronousStore(IPageStore pageStore) {
                return new SerializingPageStore((IPageStore)new HazelcastDataStore(Application.this.getName(), Application.this.hazelcast), Application.this.getFrameworkSettings().getSerializer());
            }
        });
        this.getResourceSettings().getStringResourceLoaders().add(0, new LabelResourceLoader());
        this.getRequestCycleListeners().add((Object)new WebSocketAwareResourceIsolationRequestCycleListener(){

            public void onBeginRequest(RequestCycle cycle) {
                String wsUrl = Application.getWsUrl(cycle.getRequest().getUrl());
                if (wsUrl != null && !Application.this.wsUrls.contains(wsUrl)) {
                    Application.this.wsUrls.add(wsUrl);
                    Application.this.cfgDao.updateCsp();
                }
            }

            public void onEndRequest(RequestCycle cycle) {
                WebResponse wresp;
                Response resp = cycle.getResponse();
                if (resp instanceof WebResponse && (wresp = (WebResponse)resp).isHeaderSupported()) {
                    wresp.setHeader("X-XSS-Protection", "1; mode=block");
                    wresp.setHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains; preload");
                    wresp.setHeader("X-Content-Type-Options", "nosniff");
                }
            }
        });
        WebSocketContainer sc = (WebSocketContainer)this.getServletContext().getAttribute(SERVER_CONTAINER_SERVLET_CONTEXT_ATTRIBUTE);
        if (sc != null) {
            sc.setDefaultMaxSessionIdleTimeout(60000L);
        }
        this.getHeaderResponseDecorators().add(FilteringHeaderResponse::new);
        super.init();
        BootstrapSettings settings = new BootstrapSettings();
        Bootstrap.builder().withBootstrapSettings((IBootstrapSettings)settings).install((org.apache.wicket.Application)this);
        WysiwygLibrarySettings.get().setBootstrapCssReference(null);
        WysiwygLibrarySettings.get().setBootstrapDropDownJavaScriptReference(null);
        DashboardContext dashboardContext = Application.getDashboardContext();
        dashboardContext.setDashboardPersister((DashboardPersister)new UserDashboardPersister());
        WidgetRegistry widgetRegistry = dashboardContext.getWidgetRegistry();
        widgetRegistry.registerWidget((WidgetDescriptor)new MyRoomsWidgetDescriptor());
        widgetRegistry.registerWidget((WidgetDescriptor)new RecentRoomsWidgetDescriptor());
        widgetRegistry.registerWidget((WidgetDescriptor)new WelcomeWidgetDescriptor());
        widgetRegistry.registerWidget((WidgetDescriptor)new StartWidgetDescriptor());
        widgetRegistry.registerWidget((WidgetDescriptor)new RssWidgetDescriptor());
        widgetRegistry.registerWidget((WidgetDescriptor)new AdminWidgetDescriptor());
        DashboardSettings dashboardSettings = DashboardSettings.get();
        dashboardSettings.setIncludeJQueryUI(false);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new NoVersionMapper(this.getHomePage()));
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new NoVersionMapper(NOTINIT_MAPPING, NotInitedPage.class));
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new NoVersionMapper("denied", AccessDeniedPage.class));
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new NoVersionMapper(HASH_MAPPING, HashPage.class));
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new NoVersionMapper(SIGNIN_MAPPING, this.getSignInPageClass()));
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new NoVersionMapper("oauth/${oauthid}", this.getSignInPageClass()));
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new NoVersionMapper("privacy", PrivacyPage.class));
        this.mountPage("install", InstallWizardPage.class);
        this.mountPage("activate", ActivatePage.class);
        this.mountPage("reset", ResetPage.class);
        this.mountPage("error", InternalErrorPage.class);
        this.mountResource("/recordings/mp4/${id}", (ResourceReference)new Mp4RecordingResourceReference());
        this.mountResource("/recordings/png/${id}", (ResourceReference)new PngRecordingResourceReference());
        this.mountResource("/room/file/${id}", (ResourceReference)new RoomResourceReference());
        this.mountResource("/room/preview/${id}", (ResourceReference)new RoomPreviewResourceReference());
        this.mountResource("/room/file/upload", new RoomFileUploadResourceReference());
        this.mountResource("/admin/backup/upload", new BackupUploadResourceReference());
        this.mountResource("/profile/${id}", new ProfileImageResourceReference());
        this.mountResource("/group/${id}", (ResourceReference)new GroupLogoResourceReference());
        this.mountResource("/group/customcss/${id}", (ResourceReference)new GroupCustomCssResourceReference());
        this.mountResource("/ping", new PingResourceReference());
        log.debug("Application::init");
        try {
            if (OmFileHelper.getOmHome() == null) {
                OmFileHelper.setOmHome((File)new File(this.getServletContext().getRealPath("/")));
            }
            LabelDao.initLanguageMap();
            log.debug("webAppPath : {}", (Object)OmFileHelper.getOmHome());
            this.cfgDao.reinit();
            this.wbManager.init();
            this.cm.init();
            this.updateJpaAddresses();
            OpenmeetingsVariables.setExtProcessTtl((int)this.cfgDao.getInt("external.process.ttl", OpenmeetingsVariables.getExtProcessTtl()));
            OmVersion.logOMStarted();
            this.recordingDao.resetProcessingStatus();
            this.userManager.initHttpClient();
            OpenmeetingsVariables.setInitComplete((boolean)true);
            CompletableFuture.runAsync(() -> {
                ThreadContext.setApplication((org.apache.wicket.Application)this);
                ApplicationHelper.ensureRequestCycle((IApplication)this);
                this.sipManager.setUserPicture(u -> ProfileImageResourceReference.getUrl(RequestCycle.get(), u));
            });
        }
        catch (Exception err) {
            log.error("[appStart]", (Throwable)err);
        }
    }

    public static OmAuthenticationStrategy getAuthenticationStrategy() {
        return (OmAuthenticationStrategy)Application.get().getSecuritySettings().getAuthenticationStrategy();
    }

    public Class<? extends Page> getHomePage() {
        return MainPage.class;
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return WebSession.class;
    }

    public Class<? extends WebPage> getSignInPageClass() {
        return SignInPage.class;
    }

    public static Application get() {
        return (Application)org.apache.wicket.Application.get((String)OpenmeetingsVariables.getWicketApplicationName());
    }

    public static DashboardContext getDashboardContext() {
        return (DashboardContext)Application.get().getMetaData(DashboardContextInitializer.DASHBOARD_CONTEXT_KEY);
    }

    static HazelcastInstance getHazelcast() {
        return Application.get().hazelcast;
    }

    Map<String, String> getInvalidSessions() {
        return this.hazelcast.getMap(INVALID_SESSIONS_KEY);
    }

    public static void kickUser(Client client) {
        if (client != null) {
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(client.getRoom().getId(), client, RoomMessage.Type.KICK, client.getUid()));
        }
    }

    public static boolean isInvaldSession(String sessionId) {
        return sessionId != null && Application.get().getInvalidSessions().containsKey(sessionId);
    }

    public static void removeInvalidSession(String sessionId) {
        if (sessionId != null) {
            Application.get().getInvalidSessions().remove(sessionId);
        }
    }

    public <T> T getBean(Class<T> clazz) {
        return (T)(this.ctx == null ? null : this.ctx.getBean(clazz));
    }

    public static String getString(String id) {
        return Application.getString(id, WebSession.getLanguage());
    }

    public static Locale getLocale(long languageId) {
        Locale loc = LabelDao.getLocale((Long)languageId);
        if (loc == null) {
            loc = Session.exists() ? WebSession.get().getLocale() : Locale.ENGLISH;
        }
        return loc;
    }

    public static String getString(String key, long languageId) {
        return Application.getString(key, Application.getLocale(languageId), new String[0]);
    }

    public static String getString(String key, Locale loc, String ... inParams) {
        String[] params;
        if (!Application.exists()) {
            ThreadContext.setApplication((org.apache.wicket.Application)org.apache.wicket.Application.get((String)appName));
        }
        if (((params = inParams) == null || params.length == 0) && STRINGS_WITH_APP.contains(key)) {
            params = new String[]{OpenmeetingsVariables.getApplicationName()};
        }
        Localizer l = Application.get().getResourceSettings().getLocalizer();
        Object value = l.getStringIgnoreSettings(key, null, null, loc, null, "[Missing]");
        if (params != null && params.length > 0) {
            MessageFormat format = new MessageFormat((String)value, loc);
            value = format.format(params);
        }
        if (RuntimeConfigurationType.DEVELOPMENT == Application.get().getConfigurationType()) {
            value = (String)value + String.format(" [%s]", key);
        }
        return value;
    }

    public static boolean isInstalled() {
        boolean result = isInstalled;
        if (!isInstalled && OpenmeetingsVariables.isInitComplete()) {
            result = Application.get().userDao.count() > 0L;
            isInstalled = result;
        }
        return result;
    }

    public static String getContactsLink() {
        return OmUrlFragment.PROFILE_MESSAGES.getLink();
    }

    public String getOmContactsLink() {
        return Application.getContactsLink();
    }

    public String getOmInvitationLink(Invitation i, String baseUrl) {
        return Application.getInvitationLink(i, baseUrl);
    }

    public String urlForActivatePage(PageParameters pp) {
        return Application.urlForPage(ActivatePage.class, pp, null);
    }

    public static String getInvitationLink(Invitation i, String baseUrl) {
        Recording rec;
        String link = "";
        Room r = i.getRoom();
        User u = i.getInvitee();
        if (r != null) {
            if (i.isPasswordProtected() && !r.isOwner(u.getId()) || User.Type.CONTACT == u.getType() || User.Type.EXTERNAL == u.getType() || !Application.get().isRoomAllowedToUser(r, u)) {
                PageParameters pp = new PageParameters();
                pp.add("invitation", (Object)i.getHash());
                if (u.getLanguageId() > 0L) {
                    pp.add("language", (Object)u.getLanguageId());
                }
                link = Application.urlForPage(HashPage.class, pp, baseUrl);
            } else {
                link = RoomEnterBehavior.getRoomUrlFragment(r.getId()).getLink();
            }
        }
        if ((rec = i.getRecording()) != null) {
            link = Application.urlForPage(HashPage.class, new PageParameters().add("invitation", (Object)i.getHash()), baseUrl);
        }
        return link;
    }

    private static boolean checkAppointment(Appointment a, User u) {
        if (a == null || a.isDeleted()) {
            return false;
        }
        if (a.isOwner(u.getId())) {
            log.debug("[isRoomAllowedToUser] appointed room, Owner entered");
            return true;
        }
        return a.getMeetingMembers().stream().map(MeetingMember::getUser).map(User::getId).anyMatch(userId -> userId.equals(u.getId()));
    }

    private static boolean checkGroups(Room r, User u) {
        if (null == r.getGroups()) {
            return false;
        }
        Set roomGroups = r.getGroups().stream().map(RoomGroup::getGroup).map(Group::getId).collect(Collectors.toSet());
        return u.getGroupUsers().stream().map(GroupUser::getGroup).map(Group::getId).anyMatch(roomGroups::contains);
    }

    public boolean isRoomAllowedToUser(Room r, User u) {
        if (r == null) {
            return false;
        }
        if (r.isAppointment()) {
            Appointment a = this.appointmentDao.getByRoom(r.getId());
            return Application.checkAppointment(a, u);
        }
        if (r.getIspublic() || r.isOwner(u.getId())) {
            log.debug("[isRoomAllowedToUser] public ? {} , ownedId ? {} ALLOWED", (Object)r.getIspublic(), (Object)r.getOwnerId());
            return true;
        }
        return Application.checkGroups(r, u);
    }

    public static boolean isUrlValid(String url) {
        return new UrlValidator(new String[]{"http", "https"}).isValid(url);
    }

    public static String urlForPage(Class<? extends Page> clazz, PageParameters pp, String inBaseUrl) {
        Object baseUrl;
        RequestCycle rc = RequestCycle.get();
        Object object = Application.isUrlValid(inBaseUrl) ? inBaseUrl : (baseUrl = Application.isUrlValid(OpenmeetingsVariables.getBaseUrl()) ? OpenmeetingsVariables.getBaseUrl() : "");
        if (!Strings.isEmpty((String)baseUrl) && !((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        return rc.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)((String)baseUrl + rc.mapUrlFor(clazz, pp))));
    }

    public String getOmString(String key, long languageId) {
        return Application.getString(key, languageId);
    }

    public String getOmString(String key) {
        return Application.getString(key);
    }

    public String getOmString(String key, Locale loc, String ... params) {
        return Application.getString(key, loc, params);
    }

    public String getServerId() {
        return this.serverId;
    }

    public void updateJpaAddresses() {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (Member m : this.hazelcast.getCluster().getMembers()) {
            sb.append(delim).append(m.getAddress().getHost());
            delim = ";";
        }
        if (Strings.isEmpty((String)delim)) {
            sb.append("localhost");
        }
        try {
            this.cfgDao.updateClusterAddresses(sb.toString());
        }
        catch (UnknownHostException e) {
            log.error("Uexpected exception while updating JPA addresses", (Throwable)e);
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public void publishWsTopic(IClusterWsMessage msg) {
        this.hazelWsTopic.publish((Object)msg);
    }

    public Set<String> getWsUrls() {
        return Set.copyOf(this.wsUrls);
    }

    public void updateTheme() {
        BootswatchTheme theme = Stream.of(BootswatchTheme.values()).filter(v -> v.name().equalsIgnoreCase(OpenmeetingsVariables.getTheme())).findFirst().orElse(null);
        IBootstrapSettings settings = Bootstrap.getSettings((org.apache.wicket.Application)this);
        settings.setThemeProvider((ThemeProvider)(theme == null ? new NoopThemeProvider() : new BootswatchThemeProvider(theme)));
        if (Session.exists()) {
            settings.getActiveThemeProvider().setActiveTheme(theme == null ? settings.getThemeProvider().defaultTheme() : settings.getThemeProvider().byName(theme.name()));
        }
    }

    static String getWsUrl(Url reqUrl) {
        String port;
        if (!reqUrl.isFull()) {
            return null;
        }
        boolean insecure = "http".equalsIgnoreCase(reqUrl.getProtocol());
        String delim = ":";
        if (reqUrl.getPort() == null || reqUrl.getPort() < 0 || insecure && 80 == reqUrl.getPort() || !insecure && 443 == reqUrl.getPort()) {
            port = "";
            delim = "";
        } else {
            port = String.valueOf(reqUrl.getPort());
        }
        String url = (insecure ? "ws" : "wss") + "://" + reqUrl.getHost() + delim + port;
        if (log.isTraceEnabled()) {
            log.trace("Getting WS url from '{}', result: '{}'", (Object)reqUrl.toString(Url.StringMode.FULL), (Object)url);
        }
        return url;
    }

    static {
        STRINGS_WITH_APP = Set.of("500", "506", "511", "512", "513", "517", "widget.start.desc", "1151", "1155", "1157", "1158", "1194");
    }

    private static class NoVersionMapper
    extends MountedMapper {
        public NoVersionMapper(Class<? extends IRequestablePage> pageClass) {
            this("/", pageClass);
        }

        public NoVersionMapper(String mountPath, Class<? extends IRequestablePage> pageClass) {
            super(mountPath, pageClass, (IPageParametersEncoder)new PageParametersEncoder());
        }

        protected void encodePageComponentInfo(Url url, PageComponentInfo info) {
        }

        public Url mapHandler(IRequestHandler requestHandler) {
            if (requestHandler instanceof ListenerRequestHandler || requestHandler instanceof BookmarkableListenerRequestHandler) {
                return null;
            }
            return super.mapHandler(requestHandler);
        }
    }
}

