/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.connection;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openmeetings.core.remote.KurentoHandler;
import org.apache.openmeetings.core.remote.StreamProcessor;
import org.apache.openmeetings.db.dao.user.IUserManager;
import org.apache.openmeetings.db.entity.IDataProviderEntity;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.connection.KStreamDto;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.danekja.java.util.function.serializable.SerializableConsumer;

@AuthorizeInstantiation(value={"ADMIN", "ADMIN_CONNECTIONS"})
public class ConnectionsPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private KurentoHandler kHandler;
    @SpringBean
    private StreamProcessor streamProcessor;
    @SpringBean
    private IUserManager userManager;

    public ConnectionsPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        SearchableDataProvider<IDataProviderEntity> sdp = new SearchableDataProvider<IDataProviderEntity>(null){
            private static final long serialVersionUID = 1L;

            private List<IDataProviderEntity> getConnections() {
                return Stream.concat(ConnectionsPanel.this.cm.stream(), ConnectionsPanel.this.streamProcessor.getStreams().stream().map(KStreamDto::new)).collect(Collectors.toList());
            }

            @Override
            public Iterator<? extends IDataProviderEntity> iterator(long first, long count) {
                List<IDataProviderEntity> l = this.getConnections();
                return l.subList((int)Math.max(0L, first), (int)Math.min(first + count, (long)l.size())).iterator();
            }

            @Override
            public long size() {
                return this.getConnections().size();
            }
        };
        final WebMarkupContainer container = new WebMarkupContainer("container");
        final WebMarkupContainer details = new WebMarkupContainer("details");
        SearchableDataView<IDataProviderEntity> dataView = new SearchableDataView<IDataProviderEntity>("clientList", (SearchableDataProvider)sdp){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<IDataProviderEntity> item) {
                if (item.getModelObject() instanceof KStreamDto) {
                    KStreamDto kStream = (KStreamDto)item.getModelObject();
                    item.add(new Component[]{new Label("type", (Serializable)((Object)(kStream.getType() + " " + kStream.getStreamType())))});
                    item.add(new Component[]{new Label("login", (Serializable)((Object)kStream.getUid()))});
                    item.add(new Component[]{new Label("since", (Serializable)((Object)WebSession.getDateFormat().format(kStream.getConnectedSince())))});
                    item.add(new Component[]{new Label("scope", (Serializable)kStream.getRoomId())});
                    item.add(new Component[]{new Label("server", (Serializable)((Object)""))});
                    item.add(new Component[]{new Label("kick", (Serializable)((Object)""))});
                }
                if (item.getModelObject() instanceof Client) {
                    final Client c = (Client)item.getModelObject();
                    item.add(new Component[]{new Label("type", (Serializable)((Object)"html5"))});
                    item.add(new Component[]{new Label("login", (Serializable)((Object)c.getUser().getLogin()))});
                    item.add(new Component[]{new Label("since", (Serializable)((Object)WebSession.getDateFormat().format(c.getConnectedSince())))});
                    item.add(new Component[]{new Label("scope", (Serializable)(c.getRoom() == null ? "html5" : "" + c.getRoom().getId()))});
                    item.add(new Component[]{new Label("server", (Serializable)((Object)c.getServerId()))});
                    item.add(new Component[]{new BootstrapAjaxLink<String>("kick", null, Buttons.Type.Outline_Danger, (IModel)new ResourceModel("603")){
                        private static final long serialVersionUID = 1L;
                        {
                            super(id, model, type, labelModel);
                            this.setSize(Buttons.Size.Small);
                        }

                        public void onClick(AjaxRequestTarget target) {
                            ConnectionsPanel.this.cm.invalidate(c.getUserId(), c.getSessionId());
                            target.add(new Component[]{container, details.setVisible(false)});
                        }
                    }.add(new Behavior[]{ConfirmationHelper.newOkCancelConfirm((Component)this, this.getString("605"))})});
                }
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    Field[] ff = (item.getModelObject() instanceof KStreamDto ? KStreamDto.class : Client.class).getDeclaredFields();
                    RepeatingView lines = new RepeatingView("line");
                    Object c = item.getModelObject();
                    for (Field f : ff) {
                        int mod = f.getModifiers();
                        if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
                        WebMarkupContainer line = new WebMarkupContainer(lines.newChildId());
                        line.add(new Component[]{new Label("name", (Serializable)((Object)f.getName()))});
                        Object val = "";
                        try {
                            f.setAccessible(true);
                            val = "" + f.get(c);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        line.add(new Component[]{new Label("value", (Serializable)val)});
                        lines.add(new Component[]{line});
                    }
                    details.addOrReplace(new Component[]{lines});
                    target.add(new Component[]{details.setVisible(true)});
                })});
                item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"clickable"))});
            }
        };
        this.add(new Component[]{container.add(new Component[]{dataView}).setOutputMarkupId(true), details.setVisible(false).setOutputMarkupPlaceholderTag(true)});
        this.add(new Component[]{new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{container});
            }
        }});
    }
}

