/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.util;

import com.fasterxml.jackson.databind.JsonNode;
import de.agilecoders.wicket.jquery.Attr;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.function.JavaScriptInlineFunction;
import de.agilecoders.wicket.jquery.util.Json;
import org.apache.wicket.util.time.Duration;

public class CharSequenceWrapper
implements CharSequence {
    private CharSequence casted = "";

    public CharSequenceWrapper(Object raw) {
        this.casted = CharSequenceWrapper.toParameterValue(raw);
    }

    @Override
    public int length() {
        return this.casted.length();
    }

    @Override
    public char charAt(int index) {
        return this.casted.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.casted.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.casted.toString();
    }

    public int hashCode() {
        return this.casted.hashCode();
    }

    public boolean equals(Object obj) {
        return this.casted.equals(obj);
    }

    public static CharSequence toParameterValue(Object value) {
        if (value instanceof Long) {
            return CharSequenceWrapper.toParameterValue((Long)value);
        }
        if (value instanceof Integer) {
            return CharSequenceWrapper.toParameterValue((Integer)value);
        }
        if (value instanceof Boolean) {
            return CharSequenceWrapper.toParameterValue((Boolean)value);
        }
        if (value instanceof Float) {
            return CharSequenceWrapper.toParameterValue((Float)value);
        }
        if (value instanceof JavaScriptInlineFunction) {
            return CharSequenceWrapper.toParameterValue((JavaScriptInlineFunction)value);
        }
        if (value instanceof Duration) {
            return String.valueOf(((Duration)value).getMilliseconds());
        }
        if (value instanceof Attr.MarkupId) {
            return ((Attr.MarkupId)value).quoted().toString();
        }
        if (value instanceof Attr) {
            return value.toString();
        }
        if (value instanceof JsonNode) {
            return Json.stringify(value);
        }
        if (value instanceof Config) {
            return ((Config)value).toJsonString();
        }
        return value != null ? "'" + String.valueOf(value) + "'" : Attr.nullValue();
    }

    public static CharSequence toParameterValue(JavaScriptInlineFunction value) {
        return value != null ? value.build() : Attr.nullValue();
    }

    public static CharSequence toParameterValue(Long value) {
        return value != null ? Long.toString(value) : Attr.nullValue();
    }

    public static CharSequence toParameterValue(Integer value) {
        return value != null ? Integer.toString(value) : Attr.nullValue();
    }

    public static CharSequence toParameterValue(Float value) {
        return value != null ? Float.toString(value.floatValue()) : Attr.nullValue();
    }

    public static CharSequence toParameterValue(Boolean value) {
        return value != null ? Boolean.toString(value) : Attr.nullValue();
    }
}

