/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.openmeetings.cli.OmOption;

public class OmHelpFormatter
extends HelpFormatter {
    private static final String GENERAL_OPTION_GROUP = "";
    private int maxPrefixLength = 0;

    private static List<OmOption> getReqOptions(Options opts) {
        OptionGroup g = (OptionGroup)opts.getRequiredOptions().get(0);
        ArrayList<OmOption> result = new ArrayList<OmOption>();
        for (Option o : g.getOptions()) {
            result.add((OmOption)o);
        }
        Collections.sort(result, (o1, o2) -> o1.getOrder() - o2.getOrder());
        return result;
    }

    private Map<String, List<OmOption>> getOptions(Options opts, int leftPad) {
        String longOptSeparator = " ";
        String lpad = this.createPadding(leftPad);
        String lpadParam = this.createPadding(leftPad + 2);
        List<OmOption> reqOptions = OmHelpFormatter.getReqOptions(opts);
        LinkedHashMap<String, List<OmOption>> map = new LinkedHashMap<String, List<OmOption>>(reqOptions.size());
        map.put(GENERAL_OPTION_GROUP, new ArrayList());
        for (OmOption omOption : reqOptions) {
            map.put(omOption.getOpt(), new ArrayList());
        }
        for (Option option : opts.getOptions()) {
            String[] grps;
            OmOption o = (OmOption)option;
            boolean skipOption = map.containsKey(o.getOpt());
            boolean mainOption = skipOption || o.getGroup() == null;
            StringBuilder optBuf = new StringBuilder();
            if (o.getOpt() == null) {
                optBuf.append(mainOption ? lpad : lpadParam).append("   ").append(this.getLongOptPrefix()).append(o.getLongOpt());
            } else {
                optBuf.append(mainOption ? lpad : lpadParam).append(this.getOptPrefix()).append(o.getOpt());
                if (o.hasLongOpt()) {
                    optBuf.append(',').append(this.getLongOptPrefix()).append(o.getLongOpt());
                }
            }
            if (o.hasArg()) {
                String argName = o.getArgName();
                if (argName != null && argName.length() == 0) {
                    optBuf.append(' ');
                } else {
                    optBuf.append(o.hasLongOpt() ? " " : " ");
                    optBuf.append("<").append(argName != null ? o.getArgName() : this.getArgName()).append(">");
                }
            }
            o.setHelpPrefix(optBuf);
            this.maxPrefixLength = Math.max(optBuf.length(), this.maxPrefixLength);
            if (skipOption) continue;
            String grp = o.getGroup();
            grp = grp == null ? GENERAL_OPTION_GROUP : grp;
            for (String g : grps = grp.split(",")) {
                ((List)map.get(g)).add(o);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            List options = (List)entry.getValue();
            Collections.sort(options, (o1, o2) -> {
                boolean o2opt;
                boolean o1opt = !o1.isOptional(key);
                boolean bl = o2opt = !o2.isOptional(key);
                return o1opt && o2opt || !o1opt && !o2opt ? (o1.getOpt() == null ? 1 : -1) : (o1opt ? -1 : 1);
            });
            if (!opts.hasOption(key)) continue;
            options.add(0, (OmOption)opts.getOption(key));
        }
        return map;
    }

    private static StringBuilder getReqOptionsString(Options opts) {
        String delim = GENERAL_OPTION_GROUP;
        StringBuilder result = new StringBuilder();
        for (Option option : OmHelpFormatter.getReqOptions(opts)) {
            result.append(delim).append("-").append(option.getOpt());
            delim = "|";
        }
        return result;
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        String dpad = this.createPadding(descPad);
        String optional = "(optional) ";
        Map<String, List<OmOption>> optList = this.getOptions(options, leftPad);
        char[] delimiter = new char[width - 2];
        Arrays.fill(delimiter, '-');
        for (Map.Entry<String, List<OmOption>> me : optList.entrySet()) {
            if (GENERAL_OPTION_GROUP.equals(me.getKey())) {
                sb.append("General options:").append(this.getNewLine());
            }
            for (OmOption option : me.getValue()) {
                StringBuilder optBuf = new StringBuilder(option.getHelpPrefix());
                if (optBuf.length() < this.maxPrefixLength) {
                    optBuf.append(this.createPadding(this.maxPrefixLength - optBuf.length()));
                }
                optBuf.append(dpad);
                int nextLineTabStop = this.maxPrefixLength + descPad;
                if (option.isOptional(me.getKey())) {
                    optBuf.append("(optional) ");
                }
                if (option.getDescription() != null) {
                    optBuf.append(option.getDescription());
                }
                this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
                sb.append(this.getNewLine());
            }
            sb.append(delimiter).append(this.getNewLine());
        }
        return sb;
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer, boolean autoUsage) {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        this.printUsage(pw, width, cmdLineSyntax, options);
        if (header != null && header.trim().length() > 0) {
            this.printWrapped(pw, width, header);
        }
        this.printOptions(pw, width, options, leftPad, descPad);
        if (footer != null && footer.trim().length() > 0) {
            this.printWrapped(pw, width, footer);
        }
    }

    public void printUsage(PrintWriter pw, int width, String app, Options opts) {
        pw.println(String.format("usage: %1$s [%2$s] [options]", app, OmHelpFormatter.getReqOptionsString(opts)));
    }
}

