/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.backup;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.openmeetings.db.entity.file.BaseFileItem;

class FileTree<T extends BaseFileItem> {
    private final T item;
    private final Map<Long, FileTree<T>> children = new HashMap<Long, FileTree<T>>();

    FileTree() {
        this(null);
    }

    FileTree(T item) {
        this.item = item;
    }

    boolean add(T child) {
        if (child.getParentId() != null && child.getParentId() < 1L) {
            child.setParentId(null);
        }
        if (this.item == null && child.getParentId() == null || this.item != null && this.item.getId().equals(child.getParentId())) {
            this.children.put(child.getId(), new FileTree<T>(child));
            return true;
        }
        for (Map.Entry<Long, FileTree<T>> e : this.children.entrySet()) {
            if (!e.getValue().add(child)) continue;
            return true;
        }
        return false;
    }

    void process(Predicate<T> invalid, Consumer<T> consumer) {
        if (this.item != null) {
            if (invalid.test(this.item)) {
                return;
            }
            consumer.accept(this.item);
        }
        if (!this.children.isEmpty()) {
            this.children.forEach((id, e) -> e.process(invalid, consumer));
        }
    }

    public String toString() {
        String val = "FileTree[type ='" + (Serializable)((Object)(this.item == null ? "root" : this.item.getType())) + "'";
        if (this.item != null) {
            val = val + ", name='" + this.item.getName() + "'";
        }
        if (!this.children.isEmpty()) {
            val = val + ", children='" + this.children + "'";
        }
        return val + "]";
    }
}

