/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.internal.AbstractBuilder;
import org.asteriskjava.manager.internal.ResponseBuilder;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

class ResponseBuilderImpl
extends AbstractBuilder
implements ResponseBuilder {
    private static final Set<String> ignoredAttributes = new HashSet<String>(Arrays.asList("attributes", "proxyresponse", "__result__"));
    private static final String RESPONSE_KEY = "response";
    private static final String PROXY_RESPONSE_KEY = "proxyresponse";
    private static final String RESPONSE_TYPE_ERROR = "error";
    private static final String OUTPUT_RESPONSE_KEY = "output";

    ResponseBuilderImpl() {
    }

    @Override
    public ManagerResponse buildResponse(Class<? extends ManagerResponse> responseClass, Map<String, Object> attributes) {
        ManagerResponse response;
        String responseType = (String)attributes.get(RESPONSE_KEY);
        if (RESPONSE_TYPE_ERROR.equalsIgnoreCase(responseType)) {
            response = new ManagerError();
        } else if (responseClass == null) {
            response = new ManagerResponse();
        } else {
            try {
                response = responseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                this.logger.error("Unable to create new instance of " + responseClass.getName(), ex);
                return null;
            }
        }
        this.setAttributes(response, attributes, ignoredAttributes);
        if (response instanceof CommandResponse) {
            CommandResponse commandResponse = (CommandResponse)response;
            ArrayList<String> result = new ArrayList<String>();
            if (attributes.get(OUTPUT_RESPONSE_KEY) != null) {
                if (attributes.get(OUTPUT_RESPONSE_KEY) instanceof List) {
                    for (String tmp : (List)attributes.get(OUTPUT_RESPONSE_KEY)) {
                        if (tmp == null || tmp.length() == 0) continue;
                        result.add(tmp.trim());
                    }
                } else {
                    result.add((String)attributes.get(OUTPUT_RESPONSE_KEY));
                }
            } else {
                for (String resultLine : ((String)attributes.get("__result__")).split("\n")) {
                    if (resultLine.equals("--END COMMAND--") || resultLine.equals(" --END COMMAND--")) continue;
                    result.add(resultLine);
                }
            }
            commandResponse.setResult(result);
        }
        if (response.getResponse() != null && attributes.get(PROXY_RESPONSE_KEY) != null) {
            response.setResponse((String)attributes.get(PROXY_RESPONSE_KEY));
        }
        response.setAttributes(new HashMap<String, Object>(attributes));
        return response;
    }
}

