/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.transport.serialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kurento.client.KurentoObject;
import org.kurento.client.TransactionNotCommitedException;
import org.kurento.client.internal.ModuleName;
import org.kurento.client.internal.ParamAnnotationUtils;
import org.kurento.client.internal.RemoteClass;
import org.kurento.client.internal.client.RemoteObject;
import org.kurento.client.internal.client.RemoteObjectInvocationHandler;
import org.kurento.client.internal.client.RomManager;
import org.kurento.client.internal.server.ProtocolException;
import org.kurento.client.internal.server.RemoteObjectManager;
import org.kurento.client.internal.transport.serialization.ModuleClassesManager;
import org.kurento.client.internal.transport.serialization.ObjectRefsManager;
import org.kurento.jsonrpc.Prop;
import org.kurento.jsonrpc.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamsFlattener {
    private static final String MODULE_PROPERTY = "__module__";
    private static final String TYPE_PROPERTY = "__type__";
    private static final Logger log = LoggerFactory.getLogger(ParamsFlattener.class);
    private final ModuleClassesManager moduleClassesManager = new ModuleClassesManager();
    private static final ParamsFlattener INSTANCE = new ParamsFlattener();

    public static ParamsFlattener getInstance() {
        return INSTANCE;
    }

    public Props flattenParams(Props params) {
        return this.flattenParams(params, false);
    }

    public Props flattenParams(Props params, boolean inTx) {
        if (params == null) {
            return null;
        }
        Props properties = new Props();
        for (Prop prop : params) {
            properties.add(prop.getName(), this.flattenParam(prop.getValue(), inTx));
        }
        return properties;
    }

    private List<?> flattenParamsList(List<? extends Object> params, boolean inTx) {
        ArrayList<Object> plainParams = new ArrayList<Object>(params.size());
        for (Object object : params) {
            plainParams.add(this.flattenParam(object, inTx));
        }
        return plainParams;
    }

    private Props flattenParamsMap(Map<String, ? extends Object> params, boolean inTx) {
        Props props = new Props();
        for (Map.Entry<String, ? extends Object> e : params.entrySet()) {
            props.add(e.getKey(), this.flattenParam(e.getValue(), inTx));
        }
        return props;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object flattenParam(Object param, boolean inTx) {
        void var3_11;
        if (param == null) {
            return null;
        }
        if (param instanceof RemoteObject) {
            Object object = this.flattenRemoteObject((RemoteObject)param, inTx);
            return var3_11;
        } else if (param instanceof Proxy) {
            InvocationHandler handler = Proxy.getInvocationHandler(param);
            if (!(handler instanceof RemoteObjectInvocationHandler)) throw new ProtocolException("Only proxies from remote objects are allowed, but found one with InvocationHandler " + handler);
            RemoteObjectInvocationHandler roHandler = (RemoteObjectInvocationHandler)handler;
            Object object = this.flattenRemoteObject(roHandler.getRemoteObject(), inTx);
            return var3_11;
        } else if (param instanceof Enum) {
            String string = param.toString();
            return var3_11;
        } else if (this.isPrimitive(param)) {
            Object object = param;
            return var3_11;
        } else if (param instanceof List) {
            List<?> list = this.flattenParamsList((List)param, inTx);
            return var3_11;
        } else if (param instanceof Map) {
            Props props = this.flattenParamsMap((Map)param, inTx);
            return var3_11;
        } else if (param instanceof Props) {
            Props props = this.flattenParams((Props)param, inTx);
            return var3_11;
        } else {
            Object object = this.extractParamAsProps(param, inTx);
        }
        return var3_11;
    }

    private Object flattenRemoteObject(RemoteObject remoteObject, boolean inTx) {
        if (!remoteObject.isCommited() && !inTx) {
            throw new TransactionNotCommitedException("Trying to invoke an operation with a non commited object of type '" + remoteObject.getType() + "' outside a transaction");
        }
        String processedParam = remoteObject.getObjectRef();
        return processedParam;
    }

    public Object flattenResult(Object result, RemoteObjectManager manager) {
        if (result == null) {
            return null;
        }
        if (result instanceof Enum) {
            return result.toString();
        }
        if (this.isPrimitive(result)) {
            return result;
        }
        if (result instanceof List) {
            return this.flattenResultList((List)result, manager);
        }
        if (result instanceof Map) {
            return this.flattenParamsMap((Map)result, false);
        }
        if (result.getClass().getAnnotation(RemoteClass.class) != null) {
            return this.extractObjectRefFromRemoteClass(result, manager);
        }
        return this.extractResultAsProps(result, manager);
    }

    private Object extractObjectRefFromRemoteClass(Object result, RemoteObjectManager manager) {
        return manager.getObjectRefFrom(result);
    }

    private Object extractResultAsProps(Object result, RemoteObjectManager manager) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        for (Method method : result.getClass().getMethods()) {
            String propName = null;
            String methodName = method.getName();
            if (methodName.startsWith("is")) {
                propName = methodName.substring(2, methodName.length());
            } else if (methodName.startsWith("get") && !methodName.equals("getClass")) {
                propName = methodName.substring(3, methodName.length());
            }
            if (propName == null) continue;
            try {
                propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                Object value = this.flattenResult(method.invoke(result, new Object[0]), manager);
                propsMap.put(propName, value);
            }
            catch (Exception e) {
                log.warn("Exception while accessing prop '{}' in param object: {}", new Object[]{propName, result, e});
            }
        }
        propsMap.put(TYPE_PROPERTY, result.getClass().getSimpleName());
        ModuleName name = result.getClass().getAnnotation(ModuleName.class);
        propsMap.put(MODULE_PROPERTY, name.value());
        return new Props(propsMap);
    }

    private Object flattenResultList(List<?> resultList, RemoteObjectManager manager) {
        ArrayList<Object> plainResult = new ArrayList<Object>(resultList.size());
        for (Object result : resultList) {
            plainResult.add(this.flattenResult(result, manager));
        }
        return plainResult;
    }

    private Object extractParamAsProps(Object param, boolean inTx) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        for (Method method : param.getClass().getMethods()) {
            String propName = null;
            String methodName = method.getName();
            if (methodName.startsWith("is")) {
                propName = methodName.substring(2, methodName.length());
            } else if (methodName.startsWith("get") && !methodName.equals("getClass")) {
                propName = methodName.substring(3, methodName.length());
            }
            if (propName == null) continue;
            try {
                propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                Object value = this.flattenParam(method.invoke(param, new Object[0]), inTx);
                propsMap.put(propName, value);
            }
            catch (Exception e) {
                log.warn("Exception while accessing prop '{}' in param object: {}", new Object[]{propName, param, e});
            }
        }
        propsMap.put(TYPE_PROPERTY, param.getClass().getSimpleName());
        ModuleName name = param.getClass().getAnnotation(ModuleName.class);
        propsMap.put(MODULE_PROPERTY, name.value());
        return new Props(propsMap);
    }

    private boolean isPrimitive(Object param) {
        return param instanceof String || param instanceof Boolean || param instanceof Integer || param instanceof Float || param instanceof Double || param instanceof Long;
    }

    public Object[] unflattenParams(Annotation[][] paramAnnotations, Type[] paramTypes, Props params, ObjectRefsManager manager) {
        if (params == null) {
            return null;
        }
        Object[] returnParams = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            String paramName = ParamAnnotationUtils.getParamAnnotation(paramAnnotations[i]).value();
            if ("genericData".equals(paramName)) {
                returnParams[i] = params;
                continue;
            }
            Object value = params.getProp(paramName);
            returnParams[i] = this.unflattenValue(paramName, paramTypes[i], value, manager);
        }
        return returnParams;
    }

    private Class<?> getOrCreateClass(Props props) {
        String typeName = (String)props.getProp(TYPE_PROPERTY);
        String moduleName = (String)props.getProp(MODULE_PROPERTY);
        return this.moduleClassesManager.getClassFor(moduleName, typeName);
    }

    public Class<?> getClassFor(String fullyClassName) {
        return this.moduleClassesManager.getClassFor(fullyClassName);
    }

    public Object unflattenValue(String paramName, Type type, Object value, ObjectRefsManager manager) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (this.isPrimitiveClass(clazz)) {
                return value;
            }
            if (clazz.isEnum()) {
                return this.unflattenEnumConstant(type, value, clazz);
            }
            if (value instanceof String) {
                return this.unflattenRemoteObject(type, (String)value, manager);
            }
            if (value instanceof Props) {
                Props props = (Props)value;
                Class<?> newClazz = this.getOrCreateClass(props);
                if (newClazz != null) {
                    clazz = newClazz;
                }
                return this.unflattedComplexType(clazz, props, manager);
            }
            if (value instanceof List) {
                return this.unflattenList(paramName, (List)value, type, manager);
            }
            if (value == null) {
                return null;
            }
            throw new ProtocolException("A objectRef coded with a String or a Props is expected for param type '" + type + "'");
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (((Class)paramType.getRawType()).isAssignableFrom(List.class)) {
                return this.unflattenList(paramName, (List)value, paramType.getActualTypeArguments()[0], manager);
            }
            if (((Class)paramType.getRawType()).isAssignableFrom(Map.class)) {
                Type typeArgs = paramType.getActualTypeArguments()[1];
                return this.unflattenMap(paramName, (Props)value, typeArgs, manager);
            }
        } else if (type instanceof List) {
            return this.unflattenList(paramName, (List)value, type, manager);
        }
        throw new ProtocolException("Type '" + type + "' is not supported");
    }

    private boolean isPrimitiveClass(Class<?> clazz) {
        return clazz == String.class || clazz == Void.class || clazz == Void.TYPE || clazz == Boolean.class || clazz == Boolean.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == Number.class;
    }

    private Object unflattedComplexType(Class<?> clazz, Props props, ObjectRefsManager manager) {
        Constructor<?> constructor = clazz.getConstructors()[0];
        ArrayList<Type> constClasses = new ArrayList<Type>();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Type[] parameterGenericTypes = constructor.getGenericParameterTypes();
        for (int i = 0; i < parameterGenericTypes.length; ++i) {
            if (parameterGenericTypes[i] instanceof ParameterizedType) {
                constClasses.add(parameterGenericTypes[i]);
                continue;
            }
            constClasses.add(parameterTypes[i]);
        }
        Object[] constParams = new Object[parameterTypes.length];
        List<String> paramNames = ParamAnnotationUtils.getParamNames(constructor);
        for (int i = 0; i < constParams.length; ++i) {
            String paramName = paramNames.get(i);
            constParams[i] = this.unflattenValue(paramName, (Type)constClasses.get(i), props.getProp(paramName), manager);
        }
        try {
            return constructor.newInstance(constParams);
        }
        catch (Exception e) {
            throw new ProtocolException("Exception while creating an object for the class '" + clazz.getSimpleName() + "'", e);
        }
    }

    private Object unflattenList(String paramName, List<?> value, Type type, ObjectRefsManager manager) {
        ArrayList<Object> list = new ArrayList<Object>();
        int counter = 0;
        if (value != null) {
            for (Object object : value) {
                list.add(this.unflattenValue(paramName + "[" + counter + "]", type, object, manager));
                ++counter;
            }
        }
        return list;
    }

    private Object unflattenMap(String paramName, Props value, Type type, ObjectRefsManager manager) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (value != null) {
            for (Prop p : value) {
                map.put(p.getName(), this.unflattenValue(paramName + ".get('" + p.getName() + "')", type, p.getValue(), manager));
            }
        }
        return map;
    }

    private Object unflattenRemoteObject(Type type, String id, ObjectRefsManager manager) {
        Object remoteObject = manager.getObject(id);
        if (remoteObject == null) {
            if (manager instanceof RomManager) {
                RomManager clientManager = (RomManager)manager;
                return clientManager.getById(id, (Class)type);
            }
            throw new ProtocolException("Remote object with objectRef '" + id + "' is not found");
        }
        if (remoteObject instanceof RemoteObject) {
            KurentoObject wrapper = ((RemoteObject)remoteObject).getKurentoObject();
            return wrapper != null ? wrapper : remoteObject;
        }
        return remoteObject;
    }

    private Object unflattenEnumConstant(Type type, Object value, Class<?> clazz) {
        ?[] enumConsts;
        for (Object enumConst : enumConsts = clazz.getEnumConstants()) {
            if (!enumConst.toString().equals(value)) continue;
            return enumConst;
        }
        throw new ProtocolException("Enum '" + value + "' not found in enumType '" + type.toString() + "'");
    }

    public Type calculateFlattenType(Type type) {
        switch (this.getRomType(type)) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case LONG: 
            case STRING: 
            case VOID: {
                return type;
            }
            case CT_ENUM: {
                return String.class;
            }
            case CT_REGISTER: {
                return Props.class;
            }
            case LIST: {
                return new GenericListType(this.calculateFlattenType(this.extractListType(type)));
            }
            case MAP: {
                return Props.class;
            }
            case REMOTE_CLASS: {
                return String.class;
            }
        }
        throw new ProtocolException("Unknown type: " + type);
    }

    private Type extractListType(Type type) {
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    public RomType getRomType(Type type) {
        if (type == String.class) {
            return RomType.STRING;
        }
        if (type == Void.class || type == Void.TYPE) {
            return RomType.VOID;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return RomType.BOOLEAN;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return RomType.INTEGER;
        }
        if (type == Long.class || type == Long.TYPE) {
            return RomType.LONG;
        }
        if (type == Float.class || type == Float.TYPE) {
            return RomType.FLOAT;
        }
        if (type == Double.class || type == Double.TYPE) {
            return RomType.DOUBLE;
        }
        if (this.isEnum(type)) {
            return RomType.CT_ENUM;
        }
        if (this.isComplexTypeRegister(type)) {
            return RomType.CT_REGISTER;
        }
        if (this.isList(type)) {
            return RomType.LIST;
        }
        if (this.isRemoteClass(type)) {
            return RomType.REMOTE_CLASS;
        }
        if (this.isMap(type)) {
            return RomType.MAP;
        }
        throw new ProtocolException("Unknown type: " + type);
    }

    public boolean isRemoteClass(Type type) {
        return type instanceof Class && ((Class)type).getAnnotation(RemoteClass.class) != null;
    }

    public boolean isComplexTypeRegister(Type type) {
        return type instanceof Class && ((Class)type).getAnnotation(RemoteClass.class) == null && !this.isEnum(type) && !this.isList(type);
    }

    public boolean isList(Type type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(List.class) || type instanceof ParameterizedType && this.isList(((ParameterizedType)type).getRawType());
    }

    public boolean isMap(Type type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(Map.class) || type instanceof ParameterizedType && this.isMap(((ParameterizedType)type).getRawType());
    }

    public boolean isEnum(Type type) {
        return type instanceof Class && ((Class)type).isEnum();
    }

    public static class GenericListType
    implements ParameterizedType {
        private final Type[] elementsTypes;

        public GenericListType(Type elementsType) {
            this.elementsTypes = new Type[]{elementsType};
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.elementsTypes;
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    public static enum RomType {
        VOID,
        INTEGER,
        BOOLEAN,
        FLOAT,
        DOUBLE,
        LONG,
        STRING,
        CT_ENUM,
        CT_REGISTER,
        LIST,
        REMOTE_CLASS,
        MAP;

    }
}

