/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office.utils;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Info {
    private static final Logger LOGGER = LoggerFactory.getLogger(Info.class);
    private static final String NODE_PRODUCT = "/org.openoffice.Setup/Product";
    private static final String NODE_L10N = "/org.openoffice.Setup/L10N";
    private static final String[] NODE_PATHS = new String[]{"/org.openoffice.Setup/Product", "/org.openoffice.Setup/L10N"};

    public static int compareVersions(@Nullable String version1, @Nullable String version2, int length) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        String[] numbers1 = Info.normalizeVersion(version1, length).split("\\.");
        String[] numbers2 = Info.normalizeVersion(version2, length).split("\\.");
        for (int i = 0; i < numbers1.length; ++i) {
            if (Integer.parseInt(numbers1[i]) < Integer.parseInt(numbers2[i])) {
                return -1;
            }
            if (Integer.parseInt(numbers1[i]) <= Integer.parseInt(numbers2[i])) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isDocumentType(@NonNull XComponent document, @NonNull String documentType) {
        return Lo.qi(XServiceInfo.class, document).supportsService(documentType);
    }

    public static boolean isOpenOffice(@NonNull XComponentContext context) {
        return "openoffice".equalsIgnoreCase(Info.getOfficeName(context));
    }

    public static boolean isLibreOffice(@NonNull XComponentContext context) {
        return "libreoffice".equalsIgnoreCase(Info.getOfficeName(context));
    }

    public static @Nullable String getOfficeName(@NonNull XComponentContext context) {
        return Info.getConfig(context, "ooName");
    }

    public static @Nullable String getOfficeVersionLong(@NonNull XComponentContext context) {
        return Info.getConfig(context, "ooSetupVersionAboutBox");
    }

    public static @Nullable String getOfficeVersionShort(@NonNull XComponentContext context) {
        return Info.getConfig(context, "ooSetupVersion");
    }

    public static @Nullable String getConfig(@NonNull XComponentContext context, @NonNull String propName) {
        for (String nodePath : NODE_PATHS) {
            Object info = Info.getConfig(context, nodePath, propName);
            if (info == null) continue;
            return (String)info;
        }
        return null;
    }

    public static @Nullable Object getConfig(@NonNull XComponentContext context, @NonNull String nodePath, @NonNull String propName) {
        XPropertySet set = Info.getConfigProperties(context, nodePath);
        if (set == null) {
            return null;
        }
        return Props.getProperty(set, propName);
    }

    public static @Nullable XPropertySet getConfigProperties(@NonNull XComponentContext context, @NonNull String nodePath) {
        Object configAccess = Info.getConfigAccess(context, nodePath);
        if (configAccess == null) {
            LOGGER.debug("Could not create configuration access service");
            return null;
        }
        return Lo.qi(XPropertySet.class, configAccess);
    }

    private static Object getConfigAccess(XComponentContext context, String serviceSpecifier, String nodePath) {
        XMultiServiceFactory provider = Info.getConfigProvider(context);
        if (provider == null) {
            LOGGER.debug("Could not create configuration provider");
            return null;
        }
        try {
            return provider.createInstanceWithArguments(serviceSpecifier, (Object[])Props.makeProperties("nodepath", nodePath));
        }
        catch (Exception ex) {
            LOGGER.debug("Could not access config for: " + nodePath, (Throwable)ex);
            return null;
        }
    }

    public static @Nullable Object getConfigAccess(@NonNull XComponentContext context, @NonNull String nodePath) {
        return Info.getConfigAccess(context, "com.sun.star.configuration.ConfigurationAccess", nodePath);
    }

    public static @Nullable Object getConfigUpdateAccess(@NonNull XComponentContext context, @NonNull String nodePath) {
        return Info.getConfigAccess(context, "com.sun.star.configuration.ConfigurationUpdateAccess", nodePath);
    }

    private static @NonNull String normalizeVersion(@NonNull String version, int length) {
        ArrayList<String> numbers = new ArrayList<String>(Arrays.asList(version.split("\\.")));
        while (numbers.size() < length) {
            numbers.add("0");
        }
        return String.join((CharSequence)".", numbers);
    }

    private static @Nullable XMultiServiceFactory getConfigProvider(@NonNull XComponentContext context) {
        return Lo.createInstanceMCF(context, XMultiServiceFactory.class, "com.sun.star.configuration.ConfigurationProvider");
    }

    private Info() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

