/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.util;

import com.github.openjson.JSONObject;
import com.github.openjson.JSONStringer;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.core.util.ws.WsMessageAll;
import org.apache.openmeetings.core.util.ws.WsMessageRoom;
import org.apache.openmeetings.core.util.ws.WsMessageRoomMsg;
import org.apache.openmeetings.core.util.ws.WsMessageRoomOthers;
import org.apache.openmeetings.core.util.ws.WsMessageUser;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.util.NullStringer;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.ws.IClusterWsMessage;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.registry.IKey;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.registry.PageIdKey;
import org.apache.wicket.protocol.ws.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHelper {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHelper.class);

    public static final <T> Predicate<T> alwaysTrue() {
        return x -> true;
    }

    private WebSocketHelper() {
    }

    public static void sendClient(IWsClient omClient, byte[] b) {
        if (omClient != null) {
            WebSocketHelper.sendClient(omClient, (IWebSocketConnection c) -> {
                try {
                    c.sendMessage(b, 0, b.length);
                }
                catch (Throwable e) {
                    log.error("Error while sending binary message to client", e);
                }
            });
        }
    }

    public static void sendClient(IWsClient omClient, JSONObject msg) {
        log.trace("Sending WebSocket message to Client: {} -> {}", (Object)omClient, (Object)msg);
        if (omClient != null) {
            WebSocketHelper.sendClient(omClient, (IWebSocketConnection c) -> {
                try {
                    c.sendMessage(msg.toString());
                }
                catch (Throwable e) {
                    log.error("Error while sending message to client", e);
                }
            });
        }
    }

    public static void sendClient(IWsClient omClient, RoomMessage m) {
        log.trace("Sending WebSocket message to client: {} {}", (Object)m.getType(), (Object)(m instanceof TextRoomMessage ? ((TextRoomMessage)m).getText() : ""));
        WebSocketHelper.sendClient(omClient, (IWebSocketConnection c) -> {
            try {
                c.sendMessage((IWebSocketPushMessage)m);
            }
            catch (Throwable e) {
                log.error("Error while sending message to client", e);
            }
        });
    }

    public static IApplication getApp() {
        return (IApplication)Application.get((String)OpenmeetingsVariables.getWicketApplicationName());
    }

    private static void sendClient(IWsClient client, Consumer<IWebSocketConnection> wsc) {
        new Thread(() -> {
            Application app = (Application)WebSocketHelper.getApp();
            WebSocketSettings settings = WebSocketSettings.Holder.get((Application)app);
            IWebSocketConnectionRegistry reg = settings.getConnectionRegistry();
            Executor executor = settings.getWebSocketPushMessageExecutor();
            IWebSocketConnection wc = reg.getConnection(app, client.getSessionId(), (IKey)new PageIdKey(Integer.valueOf(client.getPageId())));
            if (wc != null && wc.isOpen()) {
                executor.run(() -> wsc.accept(wc));
            }
        }).start();
    }

    public static boolean send(IClusterWsMessage msg) {
        if (msg instanceof WsMessageRoomMsg) {
            WebSocketHelper.sendRoom(((WsMessageRoomMsg)msg).getMsg(), false);
        } else if (msg instanceof WsMessageRoomOthers) {
            WsMessageRoomOthers m = (WsMessageRoomOthers)msg;
            WebSocketHelper.sendRoomOthers(m.getRoomId(), m.getUid(), m.getMsg(), false);
        } else if (msg instanceof WsMessageRoom) {
            WsMessageRoom m = (WsMessageRoom)msg;
            WebSocketHelper.sendRoom(m.getRoomId(), m.getMsg(), false);
        } else if (msg instanceof WsMessageUser) {
            WsMessageUser m = (WsMessageUser)msg;
            WebSocketHelper.sendUser(m.getUserId(), m.getMsg(), null, false);
        } else if (msg instanceof WsMessageAll) {
            WebSocketHelper.sendAll(((WsMessageAll)msg).getMsg(), false);
        }
        return true;
    }

    public static void sendRoom(RoomMessage m) {
        WebSocketHelper.sendRoom(m, true);
    }

    private static void sendRoom(RoomMessage m, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageRoomMsg(m));
        }
        log.trace("Sending WebSocket message to room: {} {}", (Object)m.getType(), (Object)(m instanceof TextRoomMessage ? ((TextRoomMessage)m).getText() : ""));
        WebSocketHelper.sendRoom(m.getRoomId(), (IWebSocketConnection t, Client c) -> t.sendMessage((IWebSocketPushMessage)m), WebSocketHelper.alwaysTrue());
    }

    public static void sendServer(RoomMessage m) {
        log.trace("Sending WebSocket message to All: {}", (Object)m);
        WebSocketHelper.sendAll((IWebSocketConnection c) -> {
            try {
                c.sendMessage((IWebSocketPushMessage)m);
            }
            catch (Exception e) {
                log.error("Error while sending message to Server", (Throwable)e);
            }
        });
    }

    public static void sendRoom(Long roomId, JSONObject m) {
        WebSocketHelper.sendRoom(roomId, m, true);
    }

    private static void sendRoom(Long roomId, JSONObject m, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageRoom(roomId, m));
        }
        WebSocketHelper.sendRoom(roomId, m, WebSocketHelper.alwaysTrue(), null);
    }

    public static void sendRoomOthers(Long roomId, String uid, JSONObject m) {
        WebSocketHelper.sendRoomOthers(roomId, uid, m, true);
    }

    private static void sendRoomOthers(Long roomId, String uid, JSONObject m, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageRoomOthers(roomId, uid, m));
        }
        WebSocketHelper.sendRoom(roomId, m, c -> !uid.equals(c.getUid()), null);
    }

    public static void sendUser(Long userId, JSONObject m) {
        WebSocketHelper.sendUser(userId, m, null, true);
    }

    static void sendUser(Long userId, JSONObject m, BiFunction<JSONObject, Client, JSONObject> func, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageUser(userId, m));
        }
        WebSocketHelper.send(a -> ((IClientManager)((IApplication)a).getBean(IClientManager.class)).listByUser(userId).stream(), (t, c) -> WebSocketHelper.doSend(t, c, m, func, "user"), WebSocketHelper.alwaysTrue());
    }

    public static void sendAll(String m) {
        WebSocketHelper.sendAll(m, true);
    }

    private static void sendAll(String m, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageAll(m));
        }
        log.trace("Sending text WebSocket message to All: {}", (Object)m);
        WebSocketHelper.sendAll((IWebSocketConnection c) -> WebSocketHelper.doSend(c, m, "ALL"));
    }

    private static void sendAll(Consumer<IWebSocketConnection> sender) {
        new Thread(() -> {
            Application app = (Application)WebSocketHelper.getApp();
            if (app == null) {
                return;
            }
            WebSocketSettings settings = WebSocketSettings.Holder.get((Application)app);
            IWebSocketConnectionRegistry reg = settings.getConnectionRegistry();
            Executor executor = settings.getWebSocketPushMessageExecutor();
            for (IWebSocketConnection wc : reg.getConnections(app)) {
                if (wc == null || !wc.isOpen()) continue;
                executor.run(() -> sender.accept(wc));
            }
        }).start();
    }

    public static void publish(IClusterWsMessage m) {
        IApplication app = WebSocketHelper.getApp();
        new Thread(() -> app.publishWsTopic(m)).start();
    }

    public static void sendRoom(Long roomId, JSONObject m, Predicate<Client> check, BiFunction<JSONObject, Client, JSONObject> func) {
        log.trace("Sending json WebSocket message to room: {}", (Object)m);
        WebSocketHelper.sendRoom(roomId, (IWebSocketConnection t, Client c) -> WebSocketHelper.doSend(t, c, m, func, "room"), check);
    }

    static void doSend(IWebSocketConnection conn, Client c, JSONObject msg, BiFunction<JSONObject, Client, JSONObject> func, String suffix) {
        WebSocketHelper.doSend(conn, (func == null ? msg : func.apply(msg, c)).toString((JSONStringer)new NullStringer()), suffix);
    }

    private static void doSend(IWebSocketConnection c, String msg, String suffix) {
        try {
            c.sendMessage(msg);
        }
        catch (IOException e) {
            log.error("Error while sending message to {}", (Object)suffix, (Object)e);
        }
    }

    private static void sendRoom(Long roomId, BiConsumer<IWebSocketConnection, Client> consumer, Predicate<Client> check) {
        WebSocketHelper.send(a -> ((IClientManager)((IApplication)a).getBean(IClientManager.class)).streamByRoom(roomId), consumer, check);
    }

    static void send(Function<Application, Stream<Client>> func, BiConsumer<IWebSocketConnection, Client> consumer, Predicate<Client> check) {
        new Thread(() -> {
            Application app = (Application)WebSocketHelper.getApp();
            if (app == null) {
                return;
            }
            WebSocketSettings settings = WebSocketSettings.Holder.get((Application)app);
            IWebSocketConnectionRegistry reg = settings.getConnectionRegistry();
            Executor executor = settings.getWebSocketPushMessageExecutor();
            ((Stream)func.apply(app)).filter(check).forEach(c -> {
                IWebSocketConnection wc = reg.getConnection(app, c.getSessionId(), (IKey)new PageIdKey(Integer.valueOf(c.getPageId())));
                if (wc != null && wc.isOpen()) {
                    executor.run(() -> consumer.accept(wc, (Client)c));
                }
            });
        }).start();
    }
}

