/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    private static final int TOTAL_LENGTH = 78;
    private static String version = null;
    private static String revision = null;
    private static String buildDate = null;

    private Version() {
    }

    public static String getVersion() {
        return version;
    }

    public static String getRevision() {
        return revision;
    }

    public static String getBuildDate() {
        return buildDate;
    }

    public static void getLine(StringBuilder sb, String text, char fill) {
        int i;
        sb.append("\t#");
        int l = text.length();
        int headLength = (78 - l) / 2;
        for (i = 0; i < headLength; ++i) {
            sb.append(fill);
        }
        sb.append(text);
        for (i = 0; i < 78 - l - headLength; ++i) {
            sb.append(fill);
        }
        sb.append("#\n");
    }

    public static void logOMStarted() {
        StringBuilder sb = new StringBuilder("\n");
        Version.getLine(sb, "", '#');
        Version.getLine(sb, "Openmeetings is up", ' ');
        Version.getLine(sb, Version.getVersion() + " " + Version.getRevision() + " " + Version.getBuildDate(), ' ');
        Version.getLine(sb, "and ready to use", ' ');
        Version.getLine(sb, "", '#');
        log.debug("{}", (Object)sb);
    }

    static {
        try {
            Properties props = new Properties();
            try (InputStream is = Version.class.getResourceAsStream("version.properties");){
                props.load(is);
            }
            version = props.getProperty("version");
            revision = props.getProperty("revision");
            buildDate = props.getProperty("date");
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
        }
    }
}

