/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.remote;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.openmeetings.core.remote.KRoom;
import org.apache.openmeetings.core.remote.KStream;
import org.apache.openmeetings.core.remote.StreamProcessor;
import org.apache.openmeetings.core.remote.TestStreamProcessor;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.wicket.util.string.Strings;
import org.kurento.client.CertificateKeyType;
import org.kurento.client.Continuation;
import org.kurento.client.Endpoint;
import org.kurento.client.EventListener;
import org.kurento.client.KurentoClient;
import org.kurento.client.MediaObject;
import org.kurento.client.MediaPipeline;
import org.kurento.client.ObjectCreatedEvent;
import org.kurento.client.PlayerEndpoint;
import org.kurento.client.RecorderEndpoint;
import org.kurento.client.RtpEndpoint;
import org.kurento.client.Tag;
import org.kurento.client.Transaction;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcClientNettyWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KurentoHandler {
    private static final Logger log = LoggerFactory.getLogger(KurentoHandler.class);
    public static final String PARAM_ICE = "iceServers";
    public static final String PARAM_CANDIDATE = "candidate";
    private static final String WARN_NO_KURENTO = "Media Server is not accessible";
    public static final String MODE_TEST = "test";
    public static final String TAG_KUID = "kuid";
    public static final String TAG_MODE = "mode";
    public static final String TAG_ROOM = "roomId";
    public static final String TAG_STREAM_UID = "streamUid";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final ScheduledExecutorService kmsRecheckScheduler = Executors.newScheduledThreadPool(1);
    public static final String KURENTO_TYPE = "kurento";
    private static int flowoutTimeout = 5;
    @Value(value="${kurento.ws.url}")
    private String kurentoWsUrl;
    @Value(value="${kurento.turn.url}")
    private String turnUrl;
    @Value(value="${kurento.turn.user}")
    private String turnUser;
    @Value(value="${kurento.turn.secret}")
    private String turnSecret;
    @Value(value="${kurento.turn.mode}")
    private String turnMode;
    @Value(value="${kurento.turn.ttl}")
    private int turnTtl = 60;
    @Value(value="${kurento.check.timeout}")
    private long checkTimeout = 120000L;
    @Value(value="${kurento.object.check.timeout}")
    private long objCheckTimeout = 200L;
    @Value(value="${kurento.watch.thread.count}")
    private int watchThreadCount = 10;
    @Value(value="${kurento.kuid}")
    private String kuid;
    private CertificateKeyType certificateType;
    private KurentoClient client;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final Map<Long, KRoom> rooms = new ConcurrentHashMap<Long, KRoom>();
    private final Set<String> ignoredKuids = new HashSet<String>();
    private Runnable check;
    @Autowired
    private IClientManager cm;
    @Autowired
    private RoomDao roomDao;
    @Autowired
    private TestStreamProcessor testProcessor;
    @Autowired
    private StreamProcessor streamProcessor;

    boolean isConnected() {
        boolean connctd;
        boolean bl = connctd = this.connected.get() && this.client != null && !this.client.isClosed();
        if (!connctd) {
            log.warn(WARN_NO_KURENTO);
        }
        return connctd;
    }

    @PostConstruct
    public void init() {
        this.check = () -> {
            try {
                if (this.client != null) {
                    return;
                }
                log.debug("Reconnecting KMS");
                this.client = KurentoClient.createFromJsonRpcClient((JsonRpcClient)new JsonRpcClientNettyWebSocket(this.kurentoWsUrl){
                    {
                        this.setTryReconnectingMaxTime(0L);
                    }

                    private void notifyRooms(boolean connected) {
                        WebSocketHelper.sendServer((RoomMessage)new TextRoomMessage(null, new User(), RoomMessage.Type.KURENTO_STATUS, new JSONObject().put("connected", connected).toString()));
                    }

                    private void onDisconnect() {
                        log.info("!!! Kurento disconnected");
                        KurentoHandler.this.connected.set(false);
                        this.notifyRooms(false);
                        KurentoHandler.this.clean();
                    }

                    protected void handleReconnectDisconnection(int statusCode, String closeReason) {
                        if (!this.isClosedByUser()) {
                            log.debug("{}JsonRpcWsClient disconnected from {} because {}.", new Object[]{this.label, this.uri, closeReason});
                            this.onDisconnect();
                        } else {
                            super.handleReconnectDisconnection(statusCode, closeReason);
                            this.onDisconnect();
                        }
                    }

                    protected void fireConnected() {
                        log.info("!!! Kurento connected");
                        KurentoHandler.this.connected.set(true);
                        this.notifyRooms(true);
                    }
                });
                this.client.getServerManager().addObjectCreatedListener((EventListener)new KWatchDogCreate());
                this.client.getServerManager().addObjectDestroyedListener(event -> log.debug("Kurento::ObjectDestroyedEvent objectId {}, tags {}, source {}", new Object[]{event.getObjectId(), event.getTags(), event.getSource()}));
            }
            catch (Exception e) {
                this.connected.set(false);
                this.clean();
                log.warn("Fail to create Kurento client, will re-try in {} ms", (Object)this.checkTimeout, (Object)e);
            }
        };
        this.kmsRecheckScheduler.scheduleAtFixedRate(this.check, 0L, this.checkTimeout, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void destroy() {
        this.clean();
        this.kmsRecheckScheduler.shutdownNow();
    }

    private void clean() {
        if (this.client != null) {
            try {
                KurentoClient copy = this.client;
                this.client = null;
                if (!copy.isClosed()) {
                    log.debug("Client will be destroyed ...");
                    copy.destroy();
                    log.debug(".... Client is destroyed");
                }
                this.testProcessor.destroy();
                this.streamProcessor.destroy();
                for (Map.Entry<Long, KRoom> e : this.rooms.entrySet()) {
                    e.getValue().close();
                }
                this.rooms.clear();
            }
            catch (Exception e) {
                log.error("Unexpected error while clean-up", (Throwable)e);
            }
        }
    }

    private static Map<String, String> tagsAsMap(MediaObject pipe) {
        return pipe.getTags().stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue));
    }

    Transaction beginTransaction() {
        return this.client.beginTransaction();
    }

    public void onMessage(IWsClient inClient, JSONObject msg) {
        if (!this.isConnected()) {
            KurentoHandler.sendError(inClient, "Multimedia server is inaccessible");
            return;
        }
        String cmdId = msg.getString("id");
        if (MODE_TEST.equals(msg.optString(TAG_MODE))) {
            this.testProcessor.onMessage(inClient, cmdId, msg);
        } else {
            Client c = (Client)inClient;
            if (c == null || c.getRoomId() == null) {
                log.warn("Incoming message from invalid user");
                return;
            }
            this.streamProcessor.onMessage(c, cmdId, msg);
        }
    }

    public JSONObject getRecordingUser(Long roomId) {
        if (!this.isConnected()) {
            return new JSONObject();
        }
        return this.getRoom(roomId).getRecordingUser();
    }

    public void leaveRoom(Client c) {
        this.remove((IWsClient)c);
        WebSocketHelper.sendAll(KurentoHandler.newKurentoMsg().put("id", (Object)"clientLeave").put("uid", (Object)c.getUid()).toString());
    }

    void sendShareUpdated(Client.StreamDesc sd) {
        this.sendClient(sd.getSid(), KurentoHandler.newKurentoMsg().put("id", (Object)"shareUpdated").put("stream", (Object)sd.toJson()));
    }

    public void sendClient(String sid, JSONObject msg) {
        WebSocketHelper.sendClient((IWsClient)this.cm.getBySid(sid), msg);
    }

    public static void sendError(IWsClient c, String msg) {
        WebSocketHelper.sendClient(c, KurentoHandler.newKurentoMsg().put("id", (Object)"error").put("message", (Object)msg));
    }

    public void remove(IWsClient c) {
        if (!this.isConnected() || c == null) {
            return;
        }
        if (!(c instanceof Client)) {
            this.testProcessor.remove(c);
            return;
        }
        this.streamProcessor.remove((Client)c);
    }

    MediaPipeline createPipiline(Map<String, String> tags, Continuation<Void> continuation) {
        Transaction t = this.beginTransaction();
        MediaPipeline pipe = this.client.createMediaPipeline(t);
        pipe.addTag(t, TAG_KUID, this.kuid);
        tags.forEach((key, value) -> pipe.addTag(t, key, value));
        t.commit(continuation);
        return pipe;
    }

    KRoom getRoom(Long roomId) {
        return this.rooms.computeIfAbsent(roomId, k -> {
            log.debug("Room {} does not exist. Will create now!", (Object)roomId);
            Room r = this.roomDao.get(roomId);
            return new KRoom(r);
        });
    }

    public Collection<KRoom> getRooms() {
        return this.rooms.values();
    }

    public void updateSipCount(Room r, long count) {
        this.getRoom(r.getId()).updateSipCount(count);
    }

    static JSONObject newKurentoMsg() {
        return new JSONObject().put("type", (Object)KURENTO_TYPE);
    }

    public static boolean activityAllowed(Client c, Client.Activity a, Room room) {
        boolean r = false;
        switch (a) {
            case AUDIO: {
                r = c.hasRight(Room.Right.AUDIO);
                break;
            }
            case VIDEO: {
                r = !room.isAudioOnly() && c.hasRight(Room.Right.VIDEO);
                break;
            }
            case AUDIO_VIDEO: {
                r = !room.isAudioOnly() && c.hasRight(Room.Right.AUDIO) && c.hasRight(Room.Right.VIDEO);
                break;
            }
        }
        return r;
    }

    public JSONArray getTurnServers(Client c) {
        return this.getTurnServers(c, false);
    }

    JSONArray getTurnServers(Client c, boolean test) {
        JSONArray arr = new JSONArray();
        if (!Strings.isEmpty((CharSequence)this.turnUrl)) {
            try {
                String[] turnUrls;
                JSONObject turn = new JSONObject();
                if ("rest".equalsIgnoreCase(this.turnMode)) {
                    String uid;
                    Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
                    mac.init(new SecretKeySpec(this.turnSecret.getBytes(), HMAC_SHA1_ALGORITHM));
                    StringBuilder user = new StringBuilder().append((long)(test ? 60 : this.turnTtl * 60) + System.currentTimeMillis() / 1000L);
                    String string = uid = c == null ? null : c.getUid();
                    if (!Strings.isEmpty((CharSequence)uid)) {
                        user.append(':').append(uid);
                    } else if (!Strings.isEmpty((CharSequence)this.turnUser)) {
                        user.append(':').append(this.turnUser);
                    }
                    turn.put("username", (Object)user).put("credential", (Object)Base64.getEncoder().encodeToString(mac.doFinal(user.toString().getBytes())));
                } else {
                    turn.put("username", (Object)this.turnUser).put("credential", (Object)this.turnSecret);
                }
                JSONArray urls = new JSONArray();
                for (String url : turnUrls = this.turnUrl.split(",")) {
                    if (url.startsWith("stun:") || url.startsWith("stuns:") || url.startsWith("turn:") || url.startsWith("turns:")) {
                        urls.put((Object)url);
                        continue;
                    }
                    urls.put((Object)("turn:" + url));
                }
                turn.put("urls", (Object)urls);
                arr.put((Object)turn);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                log.error("Unexpected error while creating turn", (Throwable)e);
            }
        }
        return arr;
    }

    KurentoClient getClient() {
        return this.client;
    }

    String getKuid() {
        return this.kuid;
    }

    @Value(value="${kurento.certificateType}")
    public void setCertificateType(String certificateType) {
        if (certificateType.isEmpty()) {
            return;
        }
        this.certificateType = CertificateKeyType.valueOf((String)certificateType);
    }

    public CertificateKeyType getCertificateType() {
        return this.certificateType;
    }

    static int getFlowoutTimeout() {
        return flowoutTimeout;
    }

    @Value(value="${kurento.flowout.timeout}")
    private void setFlowoutTimeout(int timeout) {
        flowoutTimeout = timeout;
    }

    @Value(value="${kurento.ignored.kuids}")
    private void setIgnoredKuids(String ignoredKuids) {
        if (!Strings.isEmpty((CharSequence)ignoredKuids)) {
            this.ignoredKuids.addAll(List.of(ignoredKuids.split("[, ]")));
        }
    }

    private class KWatchDogCreate
    implements EventListener<ObjectCreatedEvent> {
        private ScheduledExecutorService scheduler;

        public KWatchDogCreate() {
            this.scheduler = Executors.newScheduledThreadPool(KurentoHandler.this.watchThreadCount);
        }

        public void onEvent(ObjectCreatedEvent evt) {
            log.debug("Kurento::ObjectCreated -> {}, source {}", (Object)evt.getObject(), (Object)evt.getSource());
            if (evt.getObject() instanceof MediaPipeline) {
                String roid = evt.getObject().getId();
                this.scheduler.schedule(() -> {
                    if (KurentoHandler.this.client == null) {
                        return;
                    }
                    MediaPipeline pipe = (MediaPipeline)KurentoHandler.this.client.getById(roid, MediaPipeline.class);
                    Map<String, String> tags = KurentoHandler.tagsAsMap((MediaObject)pipe);
                    try {
                        KStream stream;
                        String inKuid = tags.get(KurentoHandler.TAG_KUID);
                        if (inKuid != null && KurentoHandler.this.ignoredKuids.contains(inKuid)) {
                            return;
                        }
                        if (this.validTestPipeline(tags)) {
                            return;
                        }
                        if (KurentoHandler.this.kuid.equals(inKuid) && (stream = KurentoHandler.this.streamProcessor.getByUid(tags.get(KurentoHandler.TAG_STREAM_UID))) != null) {
                            if (stream.getRoomId().equals(Long.valueOf(tags.get(KurentoHandler.TAG_ROOM))) && stream.getPipeline().getId().equals(pipe.getId())) {
                                return;
                            }
                            stream.release();
                        }
                    }
                    catch (Exception e) {
                        log.warn("Unexpected error while checking MediaPipeline {}, tags: {}", new Object[]{pipe.getId(), tags, e});
                    }
                    log.warn("Invalid MediaPipeline {} detected, will be dropped, tags: {}", (Object)pipe.getId(), tags);
                    pipe.release();
                }, KurentoHandler.this.objCheckTimeout, TimeUnit.MILLISECONDS);
            } else if (evt.getObject() instanceof Endpoint) {
                Endpoint curPoint = (Endpoint)evt.getObject();
                String eoid = curPoint.getId();
                Class<WebRtcEndpoint> clazz = null;
                if (curPoint instanceof WebRtcEndpoint) {
                    clazz = WebRtcEndpoint.class;
                } else if (curPoint instanceof RecorderEndpoint) {
                    clazz = RecorderEndpoint.class;
                } else if (curPoint instanceof PlayerEndpoint) {
                    clazz = PlayerEndpoint.class;
                } else if (curPoint instanceof RtpEndpoint) {
                    clazz = RtpEndpoint.class;
                }
                Class<WebRtcEndpoint> fClazz = clazz;
                this.scheduler.schedule(() -> {
                    if (KurentoHandler.this.client == null || fClazz == null) {
                        return;
                    }
                    Endpoint point = (Endpoint)KurentoHandler.this.client.getById(eoid, fClazz);
                    Map<String, String> tags = KurentoHandler.tagsAsMap((MediaObject)point);
                    try {
                        Map<String, String> pipeTags = KurentoHandler.tagsAsMap((MediaObject)point.getMediaPipeline());
                        String inKuid = pipeTags.get(KurentoHandler.TAG_KUID);
                        if (KurentoHandler.this.ignoredKuids.contains(inKuid)) {
                            return;
                        }
                        if (this.validTestPipeline(pipeTags)) {
                            return;
                        }
                        KStream stream = KurentoHandler.this.streamProcessor.getByUid(tags.get("outUid"));
                        log.debug("Kurento::ObjectCreated -> New Endpoint {} detected, tags: {}, kStream: {}", new Object[]{point.getId(), tags, stream});
                        if (stream != null && stream.contains(tags.get("uid"))) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Unexpected error while checking Endpoint {}, tags: {}", new Object[]{point.getId(), tags, e});
                    }
                    log.warn("Invalid Endpoint {} detected, will be dropped, tags: {}", (Object)point.getId(), tags);
                    point.release();
                }, KurentoHandler.this.objCheckTimeout, TimeUnit.MILLISECONDS);
            }
        }

        private boolean validTestPipeline(Map<String, String> tags) {
            return KurentoHandler.this.kuid.equals(tags.get(KurentoHandler.TAG_KUID)) && KurentoHandler.MODE_TEST.equals(tags.get(KurentoHandler.TAG_MODE)) && KurentoHandler.MODE_TEST.equals(tags.get(KurentoHandler.TAG_ROOM));
        }
    }
}

