/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.remote;

import com.github.openjson.JSONObject;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.openmeetings.core.remote.AbstractStream;
import org.apache.openmeetings.core.remote.KRoom;
import org.apache.openmeetings.core.remote.KurentoHandler;
import org.apache.openmeetings.core.remote.StreamProcessor;
import org.apache.openmeetings.core.sip.ISipCallbacks;
import org.apache.openmeetings.core.sip.SipManager;
import org.apache.openmeetings.core.sip.SipStackProcessor;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.record.RecordingChunkDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.record.RecordingChunk;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.wicket.injection.Injector;
import org.kurento.client.BaseRtpEndpoint;
import org.kurento.client.Continuation;
import org.kurento.client.IceCandidate;
import org.kurento.client.ListenerSubscription;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaFlowState;
import org.kurento.client.MediaObject;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaProfileSpecType;
import org.kurento.client.MediaType;
import org.kurento.client.RecorderEndpoint;
import org.kurento.client.RtpEndpoint;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.jsonrpc.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStream
extends AbstractStream
implements ISipCallbacks {
    private static final Logger log = LoggerFactory.getLogger(KStream.class);
    @Inject
    private KurentoHandler kHandler;
    @Inject
    private StreamProcessor processor;
    @Inject
    private RecordingChunkDao chunkDao;
    @Inject
    private SipManager sipManager;
    private final KRoom kRoom;
    private final Date connectedSince;
    private final Client.StreamType streamType;
    private MediaProfileSpecType profile;
    private MediaPipeline pipeline;
    private RecorderEndpoint recorder;
    private BaseRtpEndpoint outgoingMedia = null;
    private Queue<IceCandidate> candidatesQueue = new ConcurrentLinkedQueue<IceCandidate>();
    private RtpEndpoint rtpEndpoint;
    private Optional<SipStackProcessor> sipProcessor = Optional.empty();
    private final Map<String, WebRtcEndpoint> listeners = new ConcurrentHashMap<String, WebRtcEndpoint>();
    private Optional<CompletableFuture<Object>> flowoutFuture = Optional.empty();
    private ListenerSubscription flowoutSubscription;
    private Long chunkId;
    private RecordingChunk.Type type;
    private boolean hasAudio;
    private boolean hasVideo;
    private boolean hasScreen;
    private boolean sipClient;

    public KStream(Client.StreamDesc sd, KRoom kRoom) {
        super(sd.getSid(), sd.getUid());
        this.kRoom = kRoom;
        this.streamType = sd.getType();
        this.connectedSince = new Date();
        Injector.get().inject((Object)this);
    }

    public void startBroadcast(final Client.StreamDesc sd, final String sdpOffer, final Runnable then) {
        if (this.outgoingMedia != null) {
            this.release(false);
        }
        this.hasAudio = sd.hasActivity(Client.Activity.AUDIO);
        this.hasVideo = sd.hasActivity(Client.Activity.VIDEO);
        this.hasScreen = sd.hasActivity(Client.Activity.SCREEN);
        this.sipClient = OmFileHelper.SIP_USER_ID.equals(sd.getClient().getUserId());
        if (sdpOffer.indexOf("m=audio") > -1 && !this.hasAudio || sdpOffer.indexOf("m=video") > -1 && !this.hasVideo && Client.StreamType.SCREEN != this.streamType) {
            log.warn("Broadcast started without enough rights, sid {}, uid {}", (Object)this.sid, (Object)this.uid);
            return;
        }
        this.type = Client.StreamType.SCREEN == this.streamType ? RecordingChunk.Type.SCREEN : (this.hasAudio && this.hasVideo ? RecordingChunk.Type.AUDIO_VIDEO : (this.hasVideo ? RecordingChunk.Type.VIDEO_ONLY : RecordingChunk.Type.AUDIO_ONLY));
        switch (this.type) {
            case AUDIO_VIDEO: {
                this.profile = MediaProfileSpecType.WEBM;
                break;
            }
            case AUDIO_ONLY: {
                this.profile = MediaProfileSpecType.WEBM_AUDIO_ONLY;
                break;
            }
            default: {
                this.profile = MediaProfileSpecType.WEBM_VIDEO_ONLY;
            }
        }
        this.pipeline = this.kHandler.createPipiline(Map.of("roomId", String.valueOf(this.getRoomId()), "streamUid", sd.getUid()), new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                if (KStream.this.sipClient) {
                    KStream.this.addSipProcessor(1L);
                } else {
                    KStream.this.outgoingMedia = KStream.this.createEndpoint(sd.getSid(), sd.getUid(), true);
                    KStream.this.internalStartBroadcast(sd, sdpOffer);
                    KStream.this.notifyOnNewStream(sd);
                }
                then.run();
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("Unable to create pipeline {}", (Object)KStream.this.uid, (Object)cause);
            }
        });
    }

    protected boolean checkFlowOutEventForStopping(MediaType mediaType) {
        return MediaType.AUDIO != mediaType || !this.hasVideo;
    }

    private void internalStartBroadcast(Client.StreamDesc sd, String sdpOffer) {
        this.outgoingMedia.addMediaSessionTerminatedListener(evt -> log.warn("Media stream terminated {}", (Object)sd));
        this.flowoutSubscription = this.outgoingMedia.addMediaFlowOutStateChangeListener(evt -> {
            log.info("Media Flow OUT STATE :: {}, mediaType {}, source {}, sid {}, uid {}", new Object[]{evt.getState(), evt.getMediaType(), evt.getSource(), this.sid, this.uid});
            if (MediaFlowState.NOT_FLOWING == evt.getState() && this.checkFlowOutEventForStopping(evt.getMediaType())) {
                log.warn("FlowOut Future is created, sid {}, uid {}", (Object)this.sid, (Object)this.uid);
                this.flowoutFuture = Optional.of(new CompletableFuture<Object>().completeAsync(() -> {
                    log.warn("KStream will be dropped {}, sid {}, uid {}", new Object[]{sd, this.sid, this.uid});
                    if (Client.StreamType.SCREEN == this.streamType) {
                        this.processor.doStopSharing(this.sid, this.uid);
                    }
                    this.stopBroadcast();
                    return null;
                }, CompletableFuture.delayedExecutor(KurentoHandler.getFlowoutTimeout(), TimeUnit.SECONDS)));
            } else {
                this.dropFlowoutFuture();
            }
        });
        this.outgoingMedia.addMediaFlowInStateChangeListener(evt -> log.warn("Media Flow IN :: {}, {}, {}, sid {}, uid {}", new Object[]{evt.getState(), evt.getMediaType(), evt.getSource(), this.sid, this.uid}));
        if (!this.sipClient) {
            this.addListener(sd.getSid(), sd.getUid(), sdpOffer);
            this.addSipProcessor(this.kRoom.getSipCount());
        }
        if (this.kRoom.isRecording()) {
            this.startRecord();
        }
    }

    private void notifyOnNewStream(Client.StreamDesc sd) {
        Client c = sd.getClient();
        WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
        if (this.hasAudio || this.hasVideo || this.hasScreen) {
            WebSocketHelper.sendRoomOthers(this.getRoomId(), c.getUid(), KurentoHandler.newKurentoMsg().put("id", (Object)"newStream").put("iceServers", (Object)this.kHandler.getTurnServers(c)).put("stream", (Object)sd.toJson()));
        }
    }

    public void broadcastRestarted() {
        if (this.outgoingMedia != null && this.flowoutSubscription != null) {
            this.outgoingMedia.removeMediaFlowOutStateChangeListener(this.flowoutSubscription);
        }
        this.dropFlowoutFuture();
    }

    private void dropFlowoutFuture() {
        this.flowoutFuture.ifPresent(f -> {
            log.warn("FlowOut Future is canceled");
            f.cancel(true);
            this.flowoutFuture = Optional.empty();
        });
    }

    public void addListener(String sid, String uid, String sdpOffer) {
        boolean self = uid.equals(this.uid);
        log.info("USER: have started, sid {}, uid {}, mode {} in kRoom {}", new Object[]{sid, uid, self ? "broadcasting" : "receiving", this.getRoomId()});
        log.trace("USER {}: SdpOffer is {}", (Object)uid, (Object)sdpOffer);
        if (!self && this.outgoingMedia == null) {
            log.warn("Trying to add listener too early, sid {}, uid {}", (Object)sid, (Object)uid);
            return;
        }
        BaseRtpEndpoint endpoint = this.getEndpointForUser(sid, uid);
        String sdpAnswer = endpoint.processOffer(sdpOffer);
        if (endpoint instanceof WebRtcEndpoint) {
            log.debug("gather candidates, sid {}, uid {}", (Object)sid, (Object)uid);
            ((WebRtcEndpoint)endpoint).gatherCandidates();
        }
        log.trace("USER {}: SdpAnswer is {}", (Object)this.uid, (Object)sdpAnswer);
        this.kHandler.sendClient(sid, KurentoHandler.newKurentoMsg().put("id", (Object)"videoResponse").put("uid", (Object)this.uid).put("sdpAnswer", (Object)sdpAnswer));
    }

    private BaseRtpEndpoint getEndpointForUser(String sid, String uid) {
        if (uid.equals(this.uid)) {
            log.debug("PARTICIPANT {}: configuring loopback", (Object)this.uid);
            return this.outgoingMedia;
        }
        log.debug("PARTICIPANT {}: receiving video from {}", (Object)uid, (Object)this.uid);
        WebRtcEndpoint listener = this.listeners.remove(uid);
        if (listener != null) {
            log.debug("PARTICIPANT {}: re-started video receiving, will drop previous endpoint", (Object)uid);
            listener.release();
        }
        log.debug("PARTICIPANT {}: creating new endpoint for {}", (Object)uid, (Object)this.uid);
        listener = this.createEndpoint(sid, uid, false);
        this.listeners.put(uid, listener);
        log.debug("PARTICIPANT {}: obtained endpoint for {}", (Object)uid, (Object)this.uid);
        Client cur = this.processor.getBySid(this.sid);
        if (cur == null) {
            log.warn("Client for endpoint dooesn't exists");
        } else {
            Client.StreamDesc sd = cur.getStream(this.uid);
            if (sd == null) {
                log.warn("Stream for endpoint dooesn't exists");
            } else {
                if (sd.hasActivity(Client.Activity.AUDIO)) {
                    this.outgoingMedia.connect((MediaElement)listener, MediaType.AUDIO);
                }
                if (Client.StreamType.SCREEN == this.streamType || sd.hasActivity(Client.Activity.VIDEO)) {
                    this.outgoingMedia.connect((MediaElement)listener, MediaType.VIDEO);
                }
            }
        }
        return listener;
    }

    private void setTags(MediaObject endpoint, String uid) {
        endpoint.addTag("outUid", this.uid);
        endpoint.addTag("uid", uid);
    }

    private RtpEndpoint getRtpEndpoint(MediaPipeline pipeline) {
        RtpEndpoint endpoint = (RtpEndpoint)new RtpEndpoint.Builder(pipeline).build();
        this.setTags((MediaObject)endpoint, this.uid);
        return endpoint;
    }

    private WebRtcEndpoint createEndpoint(String sid, String uid, boolean recv) {
        WebRtcEndpoint endpoint = KStream.createWebRtcEndpoint(this.pipeline, recv, this.kHandler.getCertificateType());
        this.setTags((MediaObject)endpoint, uid);
        this.reApplyIceCandiates(endpoint, recv);
        endpoint.addIceCandidateFoundListener(evt -> this.kHandler.sendClient(sid, KurentoHandler.newKurentoMsg().put("id", (Object)"iceCandidate").put("uid", (Object)this.uid).put("candidate", (Object)KStream.convert(JsonUtils.toJsonObject((Object)evt.getCandidate())))));
        return endpoint;
    }

    private void reApplyIceCandiates(WebRtcEndpoint endpoint, boolean recv) {
        if (recv && !this.candidatesQueue.isEmpty()) {
            log.trace("addIceCandidate iceCandidate reply from not ready, uid: {}", (Object)this.uid);
            this.candidatesQueue.stream().forEach(arg_0 -> ((WebRtcEndpoint)endpoint).addIceCandidate(arg_0));
            this.candidatesQueue.clear();
        }
    }

    public void startRecord() {
        log.debug("startRecord outMedia OK ? {}", (Object)(this.outgoingMedia != null ? 1 : 0));
        if (this.outgoingMedia == null) {
            this.release(true);
            return;
        }
        String chunkUid = "rec_" + this.kRoom.getRecordingId() + "_" + UUID.randomUUID();
        this.recorder = KStream.createRecorderEndpoint(this.pipeline, OmFileHelper.getRecUri((File)OmFileHelper.getRecordingChunk((Long)this.getRoomId(), (String)chunkUid)), this.profile);
        this.setTags((MediaObject)this.recorder, this.uid);
        this.recorder.addRecordingListener(evt -> {
            this.chunkId = this.chunkDao.start(this.kRoom.getRecordingId(), this.type, chunkUid, this.sid);
        });
        this.recorder.addStoppedListener(evt -> {
            this.chunkDao.stop(this.chunkId);
            this.chunkId = null;
        });
        switch (this.profile) {
            case WEBM: {
                this.outgoingMedia.connect((MediaElement)this.recorder, MediaType.AUDIO);
                this.outgoingMedia.connect((MediaElement)this.recorder, MediaType.VIDEO);
                break;
            }
            case WEBM_VIDEO_ONLY: {
                this.outgoingMedia.connect((MediaElement)this.recorder, MediaType.VIDEO);
                break;
            }
            default: {
                this.outgoingMedia.connect((MediaElement)this.recorder, MediaType.AUDIO);
            }
        }
        this.recorder.record((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.info("Recording started successfully");
            }

            public void onError(Throwable cause) throws Exception {
                log.error("Failed to start recording", cause);
            }
        });
    }

    public void stopRecord() {
        this.stopRecorder(true, () -> {});
    }

    public void remove(Client c) {
        WebRtcEndpoint point = this.listeners.remove(c.getUid());
        if (point != null) {
            point.release();
        }
    }

    public void stopBroadcast() {
        this.kRoom.onStopBroadcast(this);
    }

    public void pauseSharing() {
        this.releaseListeners();
    }

    private void releaseListeners() {
        log.debug("PARTICIPANT {}: Releasing listeners", (Object)this.uid);
        for (Map.Entry<String, WebRtcEndpoint> entry : this.listeners.entrySet()) {
            final String inUid = entry.getKey();
            log.trace("PARTICIPANT {}: Released incoming EP for {}", (Object)this.uid, (Object)inUid);
            WebRtcEndpoint ep = entry.getValue();
            this.outgoingMedia.disconnect((MediaElement)ep, (Continuation)new Continuation<Void>(){

                public void onSuccess(Void result) throws Exception {
                    log.trace("PARTICIPANT {}: Disconnected successfully incoming EP for {}", (Object)KStream.this.uid, (Object)inUid);
                }

                public void onError(Throwable cause) throws Exception {
                    log.warn("PARTICIPANT {}: Could not disconnect incoming EP for {}", (Object)KStream.this.uid, (Object)inUid);
                }
            });
            ep.release((Continuation)new Continuation<Void>(){

                public void onSuccess(Void result) throws Exception {
                    log.trace("PARTICIPANT {}: Released successfully incoming EP for {}", (Object)KStream.this.uid, (Object)inUid);
                }

                public void onError(Throwable cause) throws Exception {
                    log.warn("PARTICIPANT {}: Could not release incoming EP for {}", (Object)KStream.this.uid, (Object)inUid);
                }
            });
        }
        this.listeners.clear();
    }

    @Override
    public void release(boolean remove) {
        if (this.outgoingMedia != null) {
            this.releaseListeners();
            this.stopRecorder(false, () -> {
                this.releaseRtp();
                this.outgoingMedia.release((Continuation)new Continuation<Void>(){

                    public void onSuccess(Void result) throws Exception {
                        log.trace("PARTICIPANT {}: Released successfully", (Object)KStream.this.uid);
                    }

                    public void onError(Throwable cause) throws Exception {
                        log.warn("PARTICIPANT {}: Could not release", (Object)KStream.this.uid, (Object)cause);
                    }
                });
                this.pipeline.release((Continuation)new Continuation<Void>(){

                    public void onSuccess(Void result) throws Exception {
                        log.trace("PARTICIPANT {}: Released Pipeline", (Object)KStream.this.uid);
                    }

                    public void onError(Throwable cause) throws Exception {
                        log.warn("PARTICIPANT {}: Could not release Pipeline", (Object)KStream.this.uid, (Object)cause);
                    }
                });
                this.outgoingMedia = null;
                this.doRemove(remove);
            });
        } else {
            this.doRemove(remove);
        }
    }

    private void doRemove(boolean remove) {
        if (remove) {
            this.processor.release(this, false);
        }
    }

    private void releaseRecorder(Runnable then) {
        this.outgoingMedia.disconnect((MediaElement)this.recorder, (Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("PARTICIPANT {}: Recorder disconnected successfully", (Object)KStream.this.uid);
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("PARTICIPANT {}: Could not disconnect recorder", (Object)KStream.this.uid, (Object)cause);
            }
        });
        this.recorder.release((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("PARTICIPANT {}: Recorder released successfully", (Object)KStream.this.uid);
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("PARTICIPANT {}: Could not release recorder", (Object)KStream.this.uid, (Object)cause);
            }
        });
        this.recorder = null;
        then.run();
    }

    private void stopRecorder(boolean wait, final Runnable then) {
        if (this.recorder != null) {
            Continuation<Void> stop = new Continuation<Void>(){

                public void onSuccess(Void result) throws Exception {
                    log.trace("PARTICIPANT {}: Recording stopped", (Object)KStream.this.uid);
                    KStream.this.releaseRecorder(then);
                }

                public void onError(Throwable cause) throws Exception {
                    log.warn("PARTICIPANT {}: Could not stop recording", (Object)KStream.this.uid, (Object)cause);
                    KStream.this.releaseRecorder(then);
                }
            };
            if (wait) {
                this.recorder.stopAndWait((Continuation)stop);
            } else {
                this.recorder.stop((Continuation)stop);
            }
        } else {
            then.run();
        }
    }

    private void releaseRtp() {
        if (this.rtpEndpoint != null) {
            this.rtpEndpoint.release((Continuation)new Continuation<Void>(){

                public void onSuccess(Void result) throws Exception {
                    log.trace("PARTICIPANT {}: RtpEndpoint released successfully", (Object)KStream.this.uid);
                }

                public void onError(Throwable cause) throws Exception {
                    log.warn("PARTICIPANT {}: Could not release RtpEndpoint", (Object)KStream.this.uid, (Object)cause);
                }
            });
            this.rtpEndpoint = null;
        }
        this.sipProcessor.ifPresent(SipStackProcessor::destroy);
        this.sipProcessor = Optional.empty();
    }

    public void addIceCandidate(IceCandidate candidate, String uid) {
        if (this.uid.equals(uid)) {
            if (!(this.outgoingMedia instanceof WebRtcEndpoint)) {
                if (!this.sipClient) {
                    log.info("addIceCandidate iceCandidate while not ready yet, uid: {}, candidate: {}", (Object)uid, (Object)candidate.getCandidate());
                    this.candidatesQueue.add(candidate);
                }
                return;
            }
            ((WebRtcEndpoint)this.outgoingMedia).addIceCandidate(candidate);
        } else {
            WebRtcEndpoint endpoint = this.listeners.get(uid);
            log.debug("Add candidate for {}, listener found ? {}", (Object)uid, (Object)(endpoint != null ? 1 : 0));
            if (endpoint != null) {
                endpoint.addIceCandidate(candidate);
            } else {
                log.warn("addIceCandidate iceCandidate could not find endpoint, uid: {}, candidate: {}", (Object)uid, (Object)candidate.getCandidate());
            }
        }
    }

    private static JSONObject convert(JsonObject o) {
        return new JSONObject(o.toString());
    }

    public Date getConnectedSince() {
        return this.connectedSince;
    }

    public Long getRoomId() {
        return this.kRoom.getRoom().getId();
    }

    MediaPipeline getPipeline() {
        return this.pipeline;
    }

    public Client.StreamType getStreamType() {
        return this.streamType;
    }

    public MediaProfileSpecType getProfile() {
        return this.profile;
    }

    public RecorderEndpoint getRecorder() {
        return this.recorder;
    }

    public Long getChunkId() {
        return this.chunkId;
    }

    public RecordingChunk.Type getType() {
        return this.type;
    }

    public boolean contains(String uid) {
        return this.uid.equals(uid) || this.listeners.containsKey(uid);
    }

    public String toString() {
        return "KStream [kRoom=" + this.kRoom + ", streamType=" + this.streamType + ", profile=" + this.profile + ", recorder=" + this.recorder + ", outgoingMedia=" + this.outgoingMedia + ", listeners=" + this.listeners + ", flowoutFuture=" + this.flowoutFuture + ", chunkId=" + this.chunkId + ", type=" + this.type + ", sid=" + this.sid + ", uid=" + this.uid + "]";
    }

    void addSipProcessor(long count) {
        if (count > 0L) {
            if (this.sipProcessor.isEmpty()) {
                try {
                    this.sipProcessor = this.sipManager.createSipStackProcessor(UUID.randomUUID().toString(), this.kRoom.getRoom(), this);
                    this.sipProcessor.ifPresent(SipStackProcessor::register);
                }
                catch (Exception e) {
                    log.error("Unexpected error while creating SipProcessor", (Throwable)e);
                }
            }
        } else if (this.sipClient) {
            this.release();
        } else {
            this.releaseRtp();
        }
    }

    @Override
    public void onRegisterOk() {
        this.rtpEndpoint = this.getRtpEndpoint(this.pipeline);
        if (!this.sipClient) {
            if (this.hasAudio) {
                this.outgoingMedia.connect((MediaElement)this.rtpEndpoint, MediaType.AUDIO);
            }
            if (this.hasVideo) {
                this.outgoingMedia.connect((MediaElement)this.rtpEndpoint, MediaType.VIDEO);
            }
        }
        this.sipProcessor.get().invite(this.kRoom.getRoom(), null);
    }

    @Override
    public void onInviteOk(String sdp, Consumer<String> answerConsumer) {
        String answer = this.rtpEndpoint.processOffer(sdp.replace("a=sendrecv", this.sipClient ? "a=sendonly" : "a=recvonly"));
        answerConsumer.accept(answer);
        log.debug(answer);
        if (this.sipClient) {
            Client.StreamDesc sd = this.processor.getBySid(this.sid).getStream(this.uid);
            try {
                this.outgoingMedia = this.rtpEndpoint;
                this.internalStartBroadcast(sd, sdp);
                this.notifyOnNewStream(sd);
            }
            catch (Exception e) {
                log.error("Unexpected error");
            }
        }
    }
}

