/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.converter;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleConsumer;
import org.apache.openmeetings.core.converter.BaseConverter;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.util.process.ProcessHelper;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VideoConverter
extends BaseConverter {
    private static final Logger log = LoggerFactory.getLogger(VideoConverter.class);
    private static final double STEP = 0.2;

    public void convertVideo(FileItem f, StoredFile sf, ProcessResultList logs, Optional<DoubleConsumer> progress) {
        try {
            File mp4 = f.getFile("mp4");
            f.setType(BaseFileItem.Type.VIDEO);
            String ext = sf.getExt();
            String input = f.getFile(ext).getCanonicalPath();
            boolean sameExt = "mp4".equals(ext);
            Path tmp = null;
            if (sameExt) {
                tmp = Files.createTempFile("video", ".mp4", new FileAttribute[0]);
                input = Files.move(mp4.toPath(), tmp, StandardCopyOption.REPLACE_EXISTING).toFile().getCanonicalPath();
            }
            progress.ifPresent(theProgress -> theProgress.accept(0.2));
            ArrayList<String> args = new ArrayList<String>(List.of(this.getPathToFFMPEG(), "-y"));
            if (sf.isAudio()) {
                args.addAll(List.of("-loop", "1", "-framerate", "24", "-i", new File(OmFileHelper.getCssImagesDir(), "audio.jpg").getCanonicalPath()));
            }
            args.addAll(List.of("-i", input, "-c:v", "h264", "-c:a", "aac", "-pix_fmt", "yuv420p", "-vf", "pad=ceil(iw/2)*2:ceil(ih/2)*2"));
            if (sf.isAudio()) {
                args.add("-shortest");
            }
            args.add(mp4.getCanonicalPath());
            ProcessResult res = ProcessHelper.exec((String)("convert to MP4 :: " + f.getHash()), args);
            logs.add(res);
            progress.ifPresent(theProgress -> theProgress.accept(0.2));
            if (sameExt && tmp != null) {
                if (res.isOk()) {
                    Files.delete(tmp);
                } else {
                    Files.move(tmp, mp4.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            progress.ifPresent(theProgress -> theProgress.accept(0.2));
            BaseConverter.Dimension dim = VideoConverter.getDimension(res.getError(), new BaseConverter.Dimension(100, 100));
            progress.ifPresent(theProgress -> theProgress.accept(0.2));
            f.setWidth(Integer.valueOf(dim.getWidth()));
            f.setHeight(Integer.valueOf(dim.getHeight()));
            this.convertToPng((BaseFileItem)f, mp4.getCanonicalPath(), logs);
            progress.ifPresent(theProgress -> theProgress.accept(0.2));
        }
        catch (Exception err) {
            log.error("[convertVideo]", (Throwable)err);
            logs.add(new ProcessResult("convertToMP4", err.getMessage(), err));
        }
    }
}

