/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPersistentPageStore;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.pageStore.disk.NestedFolders;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePageStore
extends AbstractPersistentPageStore
implements IPersistentPageStore {
    private static final String ATTRIBUTE_PAGE_TYPE = "user.wicket_page_type";
    private static final String FILE_SUFFIX = ".data";
    private static final Logger log = LoggerFactory.getLogger(FilePageStore.class);
    private final Bytes maxSizePerSession;
    private final NestedFolders folders;

    public FilePageStore(String applicationName, File fileStoreFolder, Bytes maxSizePerSession) {
        super(applicationName);
        this.folders = new NestedFolders(new File(fileStoreFolder, applicationName + "-filestore"));
        this.maxSizePerSession = (Bytes)Args.notNull((Object)maxSizePerSession, (String)"maxSizePerSession");
    }

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    private File getPageFile(String sessionId, int id, boolean create) {
        File folder = this.folders.get(sessionId, create);
        return new File(folder, id + FILE_SUFFIX);
    }

    @Override
    protected IManageablePage getPersistedPage(String sessionIdentifier, int id) {
        byte[] data = this.readFile(sessionIdentifier, id);
        if (data == null) {
            return null;
        }
        return new SerializedPage(id, "unknown", data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String sessionIdentifier, int id) {
        File file = this.getPageFile(sessionIdentifier, id, false);
        if (!file.exists()) {
            return null;
        }
        byte[] data = null;
        try {
            FileChannel channel = FileChannel.open(file.toPath(), new OpenOption[0]);
            try {
                int size = (int)channel.size();
                MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                data = new byte[size];
                buf.get(data);
            }
            finally {
                IOUtils.closeQuietly((Closeable)channel);
            }
        }
        catch (IOException ex) {
            log.warn("cannot read page data for session {} page {}", new Object[]{sessionIdentifier, id, ex});
        }
        return data;
    }

    @Override
    protected void removePersistedPage(String sessionIdentifier, IManageablePage page) {
        File file = this.getPageFile(sessionIdentifier, page.getPageId(), false);
        if (file.exists() && !file.delete()) {
            log.warn("cannot remove page data for session {} page {}", (Object)sessionIdentifier, (Object)page.getPageId());
        }
    }

    @Override
    protected void removeAllPersistedPages(String sessionIdentifier) {
        this.folders.remove(sessionIdentifier);
    }

    @Override
    protected void addPersistedPage(String sessionIdentifier, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("FilePageStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        String type = serializedPage.getPageType();
        byte[] data = serializedPage.getData();
        this.writeFile(sessionIdentifier, serializedPage.getPageId(), type, data);
        this.checkMaxSize(sessionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String sessionIdentifier, int pageId, String pageType, byte[] data) {
        File file = this.getPageFile(sessionIdentifier, pageId, true);
        try {
            FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            try {
                ByteBuffer buffer = ByteBuffer.wrap(data);
                channel.write(buffer);
            }
            finally {
                IOUtils.closeQuietly((Closeable)channel);
            }
        }
        catch (IOException ex) {
            log.warn("cannot store page data for session {} page {}", new Object[]{sessionIdentifier, pageId, ex});
        }
        this.setPageType(file, pageType);
    }

    private void checkMaxSize(String sessionIdentifier) {
        File[] files = this.folders.get(sessionIdentifier, true).listFiles();
        Arrays.sort(files, new LastModifiedComparator());
        long total = 0L;
        for (File candidate : files) {
            if ((total += candidate.length()) <= this.maxSizePerSession.bytes() || org.apache.wicket.util.file.Files.remove((File)candidate)) continue;
            log.warn("cannot remove page data for session {} page {}", (Object)sessionIdentifier, (Object)candidate.getName());
        }
    }

    @Override
    public Set<String> getSessionIdentifiers() {
        HashSet<String> sessionIdentifiers = new HashSet<String>();
        for (File folder : this.folders.getAll()) {
            sessionIdentifiers.add(folder.getName());
        }
        return sessionIdentifiers;
    }

    @Override
    public List<IPersistedPage> getPersistedPages(String sessionIdentifier) {
        ArrayList<IPersistedPage> pages = new ArrayList<IPersistedPage>();
        File folder = this.folders.get(sessionIdentifier, false);
        if (folder.exists()) {
            File[] files = folder.listFiles();
            Arrays.sort(files, new LastModifiedComparator());
            for (File file : files) {
                int pageId;
                String name = file.getName();
                if (!name.endsWith(FILE_SUFFIX)) continue;
                try {
                    pageId = Integer.parseInt(name.substring(0, name.length() - FILE_SUFFIX.length()), 10);
                }
                catch (Exception ex) {
                    log.debug("unexpected file {}", (Object)file.getAbsolutePath());
                    continue;
                }
                String pageType = this.getPageType(file);
                pages.add(new AbstractPersistentPageStore.PersistedPage(pageId, pageType, file.length()));
            }
        }
        return pages;
    }

    protected String getPageType(File file) {
        String pageType = null;
        try {
            UserDefinedFileAttributeView view = this.getAttributeView(file);
            ByteBuffer buffer = ByteBuffer.allocate(view.size(ATTRIBUTE_PAGE_TYPE));
            view.read(ATTRIBUTE_PAGE_TYPE, buffer);
            buffer.flip();
            pageType = Charset.defaultCharset().decode(buffer).toString();
        }
        catch (Exception ex) {
            log.debug("cannot get pageType for {}", (Object)file);
        }
        return pageType;
    }

    private UserDefinedFileAttributeView getAttributeView(File file) {
        return Files.getFileAttributeView(file.toPath(), UserDefinedFileAttributeView.class, new LinkOption[0]);
    }

    protected void setPageType(File file, String pageType) {
        try {
            UserDefinedFileAttributeView view = this.getAttributeView(file);
            view.write(ATTRIBUTE_PAGE_TYPE, Charset.defaultCharset().encode(pageType));
        }
        catch (Exception ex) {
            log.debug("cannot set pageType for {}", (Object)file, (Object)ex);
        }
    }

    @Override
    public Bytes getTotalSize() {
        long total = 0L;
        for (File folder : this.folders.getAll()) {
            for (File file : folder.listFiles()) {
                String name = file.getName();
                if (!name.endsWith(FILE_SUFFIX)) continue;
                total += file.length();
            }
        }
        return Bytes.bytes((long)total);
    }

    public static class LastModifiedComparator
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            return Long.compare(f2.lastModified(), f1.lastModified());
        }
    }
}

