/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork.iwana;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IWork13PackageParser
extends AbstractParser {
    public static final String IWORK13_COMMON_ENTRY = "Metadata/BuildVersionHistory.plist";
    private static final Set<MediaType> supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(IWork13DocumentType.KEYNOTE13.getType(), IWork13DocumentType.NUMBERS13.getType(), IWork13DocumentType.PAGES13.getType())));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipFile zipFile = null;
        ZipInputStream zipStream = null;
        if (stream instanceof TikaInputStream) {
            TikaInputStream tis = (TikaInputStream)stream;
            Object container = ((TikaInputStream)stream).getOpenContainer();
            if (container instanceof ZipFile) {
                zipFile = (ZipFile)container;
            } else if (tis.hasFile()) {
                zipFile = new ZipFile(tis.getFile());
            } else {
                zipStream = new ZipInputStream(stream);
            }
        } else {
            zipStream = new ZipInputStream(stream);
        }
        MediaType type = null;
        if (zipFile != null) {
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                if (type != null) continue;
                type = IWork13DocumentType.detectIfPossible(entry);
            }
        } else {
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                if (type == null) {
                    type = IWork13DocumentType.detectIfPossible(entry);
                }
                entry = zipStream.getNextEntry();
            }
        }
        if (type != null) {
            metadata.add("Content-Type", type.toString());
        }
    }

    public static enum IWork13DocumentType {
        KEYNOTE13(MediaType.application((String)"vnd.apple.keynote.13")),
        NUMBERS13(MediaType.application((String)"vnd.apple.numbers.13")),
        PAGES13(MediaType.application((String)"vnd.apple.pages.13")),
        UNKNOWN13(MediaType.application((String)"vnd.apple.unknown.13"));

        private final MediaType mediaType;

        private IWork13DocumentType(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public static MediaType detect(ZipFile zipFile) {
            MediaType type = null;
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                type = IWork13DocumentType.detectIfPossible(entry);
                if (type == null) continue;
                return type;
            }
            return UNKNOWN13.getType();
        }

        public static MediaType detectIfPossible(ZipEntry entry) {
            String name = entry.getName();
            if (!name.endsWith(".iwa")) {
                return null;
            }
            if (name.equals("Index/MasterSlide.iwa") || name.startsWith("Index/MasterSlide-")) {
                return KEYNOTE13.getType();
            }
            if (name.equals("Index/Slide.iwa") || name.startsWith("Index/Slide-")) {
                return KEYNOTE13.getType();
            }
            if (name.equals("Index/Document.iwa")) {
                return UNKNOWN13.getType();
            }
            return null;
        }

        public MediaType getType() {
            return this.mediaType;
        }
    }
}

